/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing.accents;

import dev.architectury.platform.Platform;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3737;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.config.libraries.IItemLibrary;
import org.orecruncher.dsurround.config.libraries.ITagLibrary;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.processing.accents.ArmorAccents;
import org.orecruncher.dsurround.processing.accents.FloorSqueakAccent;
import org.orecruncher.dsurround.processing.accents.IFootstepAccentProvider;
import org.orecruncher.dsurround.processing.accents.WaterySurfaceAccent;
import org.orecruncher.dsurround.sound.ISoundFactory;

public class FootstepAccents {
    static final ITagLibrary TAG_LIBRARY = ContainerManager.resolve(ITagLibrary.class);
    private final ObjectArray<IFootstepAccentProvider> providers = new ObjectArray();

    public FootstepAccents(Configuration config, IItemLibrary itemLibrary) {
        this.providers.add(new ArmorAccents(config, itemLibrary));
        this.providers.add(new FloorSqueakAccent(config));
        if (!Platform.isModLoaded((String)"presencefootsteps")) {
            this.providers.add(new WaterySurfaceAccent(config));
        }
    }

    public void collect(class_1309 entity, class_2338 pos, class_2680 blockState, ObjectArray<ISoundFactory> in) {
        boolean isWaterLogged = blockState.method_26204() instanceof class_3737 && !blockState.method_26227().method_15769();
        this.providers.forEach(provider -> {
            if (provider.isEnabled()) {
                provider.collect(entity, pos, blockState, isWaterLogged, in);
            }
        });
    }
}

