/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing.fog;

import java.util.Iterator;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_4543;
import net.minecraft.class_758;
import org.jetbrains.annotations.NotNull;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.config.biome.BiomeInfo;
import org.orecruncher.dsurround.config.libraries.IBiomeLibrary;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.processing.fog.VanillaFogRangeCalculator;

public class BiomeFogRangeCalculator
extends VanillaFogRangeCalculator {
    private static final float SCALE_ADJUST = 0.002f;
    private final IBiomeLibrary biomeLibrary;
    private class_2338 lastBlockPos;
    private float activeScale;
    private float targetScale;

    public BiomeFogRangeCalculator(IBiomeLibrary biomeLibrary, Configuration.FogOptions fogOptions) {
        super("Biome", fogOptions);
        this.biomeLibrary = biomeLibrary;
        this.targetScale = 0.0f;
        this.activeScale = 0.0f;
        this.lastBlockPos = class_2338.field_10980;
    }

    @Override
    public boolean enabled() {
        return this.fogOptions.enableBiomeFog;
    }

    @Override
    @NotNull
    public class_758.class_7285 render(@NotNull class_758.class_7285 data, float renderDistance, float partialTick) {
        if (Float.compare(this.activeScale, this.targetScale) != 0) {
            if (this.targetScale < this.activeScale) {
                this.activeScale -= 0.002f;
                if (this.activeScale < this.targetScale) {
                    this.activeScale = this.targetScale;
                }
            } else if (this.targetScale > this.activeScale) {
                this.activeScale += 0.002f;
                if (this.activeScale > this.targetScale) {
                    this.activeScale = this.targetScale;
                }
            }
        }
        if (Float.compare(this.activeScale, 0.0f) == 0) {
            return data;
        }
        float scale = 1.0f - this.activeScale;
        class_758.class_7285 result = new class_758.class_7285(data.field_38339);
        result.field_38341 = data.field_38341 * scale;
        result.field_38340 = data.field_38340 * scale * scale;
        return result;
    }

    @Override
    public void tick() {
        class_2338 currentPosition = GameUtils.getPlayer().map(class_1297::method_23312).orElseThrow();
        if (this.lastBlockPos.equals((Object)currentPosition)) {
            return;
        }
        this.lastBlockPos = currentPosition;
        this.targetScale = this.sampleArea(currentPosition, 6);
    }

    @Override
    public void disconnect() {
        this.targetScale = 0.0f;
        this.activeScale = 0.0f;
        this.lastBlockPos = class_2338.field_10980;
    }

    private float sampleArea(class_2338 pos, int range) {
        class_4543 biomeManager = GameUtils.getWorld().map(class_1937::method_22385).orElseThrow();
        Iterator iterator = class_2338.method_25996((class_2338)pos, (int)range, (int)range, (int)range).iterator();
        float intensityAccum = 0.0f;
        float intensityCount = 0.0f;
        while (iterator.hasNext()) {
            class_2338 p = (class_2338)iterator.next();
            class_1959 b = (class_1959)biomeManager.method_27344(p).comp_349();
            BiomeInfo info = this.biomeLibrary.getBiomeInfo(b);
            intensityAccum += info.getFogDensity().getIntensity();
            intensityCount += 1.0f;
        }
        return intensityAccum / intensityCount;
    }
}

