/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing.fog;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum FogDensity {
    NONE("none", 0.0f, 0.0f, 0.0f, 0.0f),
    LIGHT("light", 0.3f, 282.5f, 304.5f, 15.0f),
    NORMAL("normal", 0.47f, 270.0f, 317.0f, 10.0f),
    MEDIUM("medium", 0.64f, 257.5f, 329.5f, 10.0f),
    HEAVY("heavy", 0.8f, 257.5f, 342.0f, 5.0f);

    private final String name;
    private final float start;
    private final float end;
    private final float reserve;
    private final float intensity;
    private static final Map<String, FogDensity> BY_NAME;
    public static final Codec<FogDensity> CODEC;

    private FogDensity(String name, float intensity, float start, float end, float reserve) {
        this.name = name;
        this.intensity = intensity;
        this.start = start;
        this.end = end;
        this.reserve = reserve;
    }

    public boolean inRange(float celestialAngleDegrees) {
        return celestialAngleDegrees >= this.start && celestialAngleDegrees <= this.end;
    }

    public String getName() {
        return this.name;
    }

    public float getIntensity() {
        return this.intensity;
    }

    public float getStartAngle() {
        return this.start;
    }

    public float getEndAngle() {
        return this.end;
    }

    public float getReserve() {
        return this.reserve;
    }

    static {
        BY_NAME = Arrays.stream(FogDensity.values()).collect(Collectors.toMap(FogDensity::getName, category -> category));
        CODEC = Codec.STRING.comapFlatMap(DataResult.partialGet(BY_NAME::get, () -> "unknown sound event type"), FogDensity::getName);
    }

    private static class Constants {
        public static final float START = 270.0f;
        public static final float END = 317.0f;
        public static final float RESERVE = 10.0f;

        private Constants() {
        }
    }
}

