/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing.fog;

import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_758;
import org.jetbrains.annotations.NotNull;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.config.libraries.IBiomeLibrary;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.logging.ModLog;
import org.orecruncher.dsurround.lib.seasons.ISeasonalInformation;
import org.orecruncher.dsurround.processing.fog.BiomeFogRangeCalculator;
import org.orecruncher.dsurround.processing.fog.IFogRangeCalculator;
import org.orecruncher.dsurround.processing.fog.MorningFogRangeCalculator;
import org.orecruncher.dsurround.processing.fog.WeatherFogRangeCalculator;

public class HolisticFogRangeCalculator
implements IFogRangeCalculator {
    protected final IModLog logger;
    protected final Configuration.FogOptions fogOptions;
    protected final ObjectArray<IFogRangeCalculator> calculators = new ObjectArray(3);

    public HolisticFogRangeCalculator(IModLog logger, Configuration.FogOptions fogOptions) {
        this.logger = ModLog.createChild(logger, "HolisticFogRangeCalculator");
        this.fogOptions = fogOptions;
        IBiomeLibrary biomeLibrary = ContainerManager.resolve(IBiomeLibrary.class);
        ISeasonalInformation seasonInfo = ContainerManager.resolve(ISeasonalInformation.class);
        this.calculators.add(new BiomeFogRangeCalculator(biomeLibrary, this.fogOptions));
        this.calculators.add(new MorningFogRangeCalculator(seasonInfo, this.fogOptions));
        this.calculators.add(new WeatherFogRangeCalculator(this.fogOptions));
    }

    @Override
    @NotNull
    public String getName() {
        return "HolisticFogRangeCalculator";
    }

    @Override
    public boolean enabled() {
        return this.fogOptions.enableFogEffects;
    }

    @Override
    @NotNull
    public class_758.class_7285 render(@NotNull class_758.class_7285 data, float renderDistance, float partialTick) {
        if (!this.enabled()) {
            return data;
        }
        float start = data.field_38340;
        float end = data.field_38341;
        for (IFogRangeCalculator calc : this.calculators) {
            if (!calc.enabled()) continue;
            class_758.class_7285 result = calc.render(data, renderDistance, partialTick);
            if (result.field_38340 > result.field_38341 || result.field_38340 < 0.0f || result.field_38341 < 0.0f) {
                this.logger.warn("Fog calculator '%s' reporting invalid fog range (start %f, end %f); ignored", calc.getName(), Float.valueOf(result.field_38340), Float.valueOf(result.field_38341));
                continue;
            }
            start = Math.min(start, result.field_38340);
            end = Math.min(end, result.field_38341);
        }
        class_758.class_7285 result = new class_758.class_7285(data.field_38339);
        result.field_38342 = data.field_38342;
        result.field_38340 = start;
        result.field_38341 = end;
        return result;
    }

    @Override
    public void tick() {
        if (GameUtils.isInGame()) {
            this.calculators.forEach(IFogRangeCalculator::tick);
        }
    }

    @Override
    public void disconnect() {
        this.calculators.forEach(IFogRangeCalculator::disconnect);
    }

    public Optional<String> getDisabledText() {
        if (!this.enabled()) {
            return Optional.of("(ALL DISABLED)");
        }
        String result = this.calculators.stream().filter(e -> !e.enabled()).map(IFogRangeCalculator::getName).collect(Collectors.joining(", "));
        if (result.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of("(DISABLED: " + result + ")");
    }
}

