/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing.fog;

import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_6005;
import net.minecraft.class_758;
import org.jetbrains.annotations.NotNull;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.MinecraftClock;
import org.orecruncher.dsurround.lib.random.Randomizer;
import org.orecruncher.dsurround.lib.seasons.ISeasonalInformation;
import org.orecruncher.dsurround.processing.fog.FogDensity;
import org.orecruncher.dsurround.processing.fog.VanillaFogRangeCalculator;

public class MorningFogRangeCalculator
extends VanillaFogRangeCalculator {
    private static final class_6005<FogDensity> SPRING_FOG = new class_6005.class_6006().method_34975((Object)FogDensity.NORMAL, 30).method_34975((Object)FogDensity.MEDIUM, 20).method_34975((Object)FogDensity.HEAVY, 10).method_34974();
    private static final class_6005<FogDensity> SUMMER_FOG = new class_6005.class_6006().method_34975((Object)FogDensity.LIGHT, 20).method_34975((Object)FogDensity.NONE, 10).method_34974();
    private static final class_6005<FogDensity> AUTUMN_FOG = new class_6005.class_6006().method_34975((Object)FogDensity.NORMAL, 10).method_34975((Object)FogDensity.MEDIUM, 20).method_34975((Object)FogDensity.HEAVY, 10).method_34974();
    private static final class_6005<FogDensity> WINTER_FOG = new class_6005.class_6006().method_34975((Object)FogDensity.LIGHT, 20).method_34975((Object)FogDensity.NORMAL, 20).method_34975((Object)FogDensity.MEDIUM, 10).method_34974();
    protected final ISeasonalInformation seasonInfo;
    protected final MinecraftClock clock;
    protected int fogDay = -1;
    protected FogDensity type = FogDensity.NONE;

    public MorningFogRangeCalculator(ISeasonalInformation seasonInfo, Configuration.FogOptions fogOptions) {
        super("Morning", fogOptions);
        this.seasonInfo = seasonInfo;
        this.clock = new MinecraftClock();
    }

    @Override
    public boolean enabled() {
        return this.fogOptions.enableMorningFog;
    }

    @Override
    @NotNull
    public class_758.class_7285 render(@NotNull class_758.class_7285 data, float renderDistance, float partialTick) {
        float angle;
        if (this.type != FogDensity.NONE && this.type.inRange(angle = this.getCelestialAngleDegrees())) {
            float mid = (this.type.getStartAngle() + this.type.getEndAngle()) / 2.0f;
            float factor = (1.0f - class_3532.method_15379((float)(angle - mid)) / (mid - this.type.getStartAngle())) * this.type.getIntensity();
            float shift = data.field_38340 * factor;
            float newEnd = data.field_38341 - shift;
            float newStart = class_3532.method_15363((float)(data.field_38340 - shift * 2.0f), (float)(this.type.getReserve() + 1.0f), (float)newEnd);
            class_758.class_7285 result = new class_758.class_7285(data.field_38339);
            result.field_38340 = newStart;
            result.field_38341 = newEnd;
            return result;
        }
        return data;
    }

    @Override
    public void tick() {
        GameUtils.getWorld().ifPresent(this.clock::update);
        int day = this.clock.getDay();
        if (this.fogDay != day) {
            this.fogDay = day;
            this.type = this.isFogAllowed() ? this.getFogType() : FogDensity.NONE;
        }
    }

    @Override
    public void disconnect() {
        this.fogDay = -1;
        this.type = FogDensity.NONE;
    }

    private boolean isFogAllowed() {
        return GameUtils.getWorld().map(w -> w.method_8597().comp_645()).orElse(false);
    }

    private float getCelestialAngleDegrees() {
        return GameUtils.getWorld().map(w -> Float.valueOf(w.method_30274(1.0f) * 360.0f)).orElseThrow().floatValue();
    }

    @NotNull
    protected FogDensity getFogType() {
        class_6005<FogDensity> selections;
        if (this.seasonInfo.isSpring()) {
            selections = SPRING_FOG;
        } else if (this.seasonInfo.isSummer()) {
            selections = SUMMER_FOG;
        } else if (this.seasonInfo.isAutumn()) {
            selections = AUTUMN_FOG;
        } else if (this.seasonInfo.isWinter()) {
            selections = WINTER_FOG;
        } else {
            return FogDensity.NONE;
        }
        return (FogDensity)((Object)selections.method_34973((class_5819)Randomizer.current()).orElseThrow());
    }
}

