/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing.scanner;

import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3486;
import net.minecraft.class_4543;
import net.minecraft.class_6880;
import org.orecruncher.dsurround.config.SyntheticBiome;
import org.orecruncher.dsurround.config.biome.BiomeInfo;
import org.orecruncher.dsurround.config.libraries.IBiomeLibrary;
import org.orecruncher.dsurround.config.libraries.IDimensionInformation;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.processing.scanner.AbstractScanner;
import org.orecruncher.dsurround.processing.scanner.CeilingScanner;

public final class BiomeScanner
extends AbstractScanner {
    public static final int SCAN_INTERVAL = 4;
    private static final int UNDERGROUND_THRESHOLD_OFFSET = 8;
    private static final int SURVEY_HORIZONTAL_DIMENSION = 18;
    private static final int SURVEY_HORIZONTAL_OFFSET = 8;
    private static final int SURVEY_VERTICAL_DIMENSION = 16;
    private static final int SURVEY_VERTICAL_OFFSET = 3;
    private static final int MAX_SURVEY_VOLUME = 5184;
    private class_2960 surveyedDimension;
    private boolean isUnderWater;
    private BiomeInfo logicalBiomeInfo;
    private final class_2338.class_2339 mutable = new class_2338.class_2339();
    private int biomeArea;
    private Reference2IntOpenHashMap<BiomeInfo> weights = new Reference2IntOpenHashMap(8);
    private class_1959 surveyedBiome = null;
    private class_2338 surveyedPosition = class_2338.field_10980;
    private final IBiomeLibrary biomeLibrary;
    private final IDimensionInformation dimensionInformation;
    private final CeilingScanner ceilingScanner;

    public BiomeScanner(IBiomeLibrary biomeLibrary, IDimensionInformation dimensionInformation, CeilingScanner ceilingScanner) {
        this.biomeLibrary = biomeLibrary;
        this.dimensionInformation = dimensionInformation;
        this.ceilingScanner = ceilingScanner;
    }

    public BiomeInfo playerLogicBiomeInfo() {
        return this.logicalBiomeInfo;
    }

    public class_2960 getDimInfo() {
        return this.surveyedDimension;
    }

    public boolean isUnderWater() {
        return this.isUnderWater;
    }

    @Override
    public void tick(long tickCount) {
        if (tickCount % 4L != 0L) {
            return;
        }
        class_1657 player = GameUtils.getPlayer().orElseThrow();
        class_1937 world = player.method_37908();
        class_2338 position = player.method_24515();
        class_4543 biomes = world.method_22385();
        class_6880 playerBiome = biomes.method_22393(position);
        if (this.surveyedBiome != playerBiome.comp_349() || !this.surveyedDimension.equals((Object)this.dimensionInformation.name()) || !this.surveyedPosition.equals((Object)position)) {
            this.surveyedBiome = (class_1959)playerBiome.comp_349();
            this.surveyedPosition = position;
            this.surveyedDimension = this.dimensionInformation.name();
            this.weights = new Reference2IntOpenHashMap(8);
            this.isUnderWater = player.method_5777(class_3486.field_15517);
            if (this.isUnderWater) {
                BiomeInfo playerBiomeInfo = this.biomeLibrary.getBiomeInfo((class_1959)playerBiome.comp_349());
                SyntheticBiome internalBiome = playerBiomeInfo.isRiver() ? SyntheticBiome.UNDER_RIVER : (playerBiomeInfo.isDeepOcean() ? SyntheticBiome.UNDER_DEEP_OCEAN : (playerBiomeInfo.isOcean() ? SyntheticBiome.UNDER_OCEAN : SyntheticBiome.UNDER_WATER));
                this.logicalBiomeInfo = this.biomeLibrary.getBiomeInfo(internalBiome);
                this.biomeArea = 1;
                this.weights.addTo((Object)this.logicalBiomeInfo, 1);
                return;
            }
            this.logicalBiomeInfo = this.resolveBiome(biomes, position);
            for (int z = 0; z < 18; ++z) {
                int dZ = z - 8 + this.surveyedPosition.method_10260();
                this.mutable.method_33099(dZ);
                for (int x = 0; x < 18; ++x) {
                    int dX = x - 8 + this.surveyedPosition.method_10263();
                    this.mutable.method_33097(dX);
                    for (int y = 0; y < 16; ++y) {
                        int dY = y - 3 + this.surveyedPosition.method_10264();
                        this.mutable.method_33098(dY);
                        BiomeInfo info = this.resolveBiome(biomes, (class_2338)this.mutable);
                        this.weights.addTo((Object)info, 1);
                    }
                }
            }
            this.biomeArea = 5184;
        }
    }

    private BiomeInfo resolveBiome(class_4543 access, class_2338 pos) {
        class_1959 biome = (class_1959)access.method_22393(pos).comp_349();
        BiomeInfo biomeInfo = this.biomeLibrary.getBiomeInfo(biome);
        if (biomeInfo.isCave()) {
            return biomeInfo;
        }
        int y = pos.method_10264();
        if (y < this.dimensionInformation.seaLevel() - 8) {
            return this.biomeLibrary.getBiomeInfo(SyntheticBiome.UNDERGROUND);
        }
        if (!this.dimensionInformation.alwaysOutside() && this.ceilingScanner.isReallyInside()) {
            return this.biomeLibrary.getBiomeInfo(SyntheticBiome.INSIDE);
        }
        if (y >= this.dimensionInformation.getSpaceHeight()) {
            return this.biomeLibrary.getBiomeInfo(SyntheticBiome.SPACE);
        }
        if (y >= this.dimensionInformation.getCloudHeight()) {
            return this.biomeLibrary.getBiomeInfo(SyntheticBiome.CLOUDS);
        }
        return biomeInfo;
    }

    public int getBiomeArea() {
        return this.biomeArea;
    }

    public Reference2IntOpenHashMap<BiomeInfo> getBiomes() {
        return this.weights;
    }
}

