/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing.scanner;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import org.orecruncher.dsurround.config.DimensionInfo;
import org.orecruncher.dsurround.config.libraries.IDimensionLibrary;
import org.orecruncher.dsurround.config.libraries.ITagLibrary;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.world.WorldUtils;
import org.orecruncher.dsurround.processing.scanner.AbstractScanner;

public final class CeilingScanner
extends AbstractScanner {
    private static final ITagLibrary TAG_LIBRARY = ContainerManager.resolve(ITagLibrary.class);
    private static final int SURVEY_INTERVAL = 4;
    private static final int INSIDE_SURVEY_RANGE = 3;
    private static final float INSIDE_THRESHOLD = 0.6306818f;
    private static final Cell[] cells;
    private static final float TOTAL_POINTS;
    private static final ObjectArray<class_6862<class_2248>> NON_CEILING;
    private final IDimensionLibrary dimensionLibrary;
    private boolean reallyInside = false;
    private float coverageRatio = 0.0f;

    public CeilingScanner(IDimensionLibrary dimensionLibrary) {
        this.dimensionLibrary = dimensionLibrary;
    }

    @Override
    public void tick(long tickCount) {
        if (tickCount % 4L != 0L) {
            return;
        }
        class_638 world = GameUtils.getWorld().orElseThrow();
        DimensionInfo dimInfo = this.dimensionLibrary.getData((class_1937)world);
        if (dimInfo.alwaysOutside()) {
            this.reallyInside = false;
        } else {
            class_1657 player = GameUtils.getPlayer().orElseThrow();
            class_2338 pos = player.method_24515();
            float score = 0.0f;
            for (Cell cell : cells) {
                score += cell.score(pos);
            }
            this.coverageRatio = 1.0f - score / TOTAL_POINTS;
            this.reallyInside = this.coverageRatio > 0.6306818f;
        }
    }

    public boolean isReallyInside() {
        return this.reallyInside;
    }

    public float getCoverageRatio() {
        return this.coverageRatio;
    }

    static {
        NON_CEILING = new ObjectArray();
        ArrayList<Cell> cellList = new ArrayList<Cell>();
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                cellList.add(new Cell(new class_2382(x, 0, z), 3));
            }
        }
        Collections.sort(cellList);
        cells = cellList.toArray(new Cell[0]);
        float totalPoints = 0.0f;
        for (Cell c : cellList) {
            totalPoints += c.potentialPoints();
        }
        TOTAL_POINTS = totalPoints;
        NON_CEILING.add((class_6862<class_2248>)class_3481.field_15503);
        NON_CEILING.add((class_6862<class_2248>)class_3481.field_25147);
        NON_CEILING.add((class_6862<class_2248>)class_3481.field_16584);
        NON_CEILING.add((class_6862<class_2248>)class_3481.field_15504);
    }

    private static final class Cell
    implements Comparable<Cell> {
        private final class_2382 offset;
        private final float points;
        private final class_2338.class_2339 working;

        public Cell(class_2382 offset, int range) {
            this.offset = offset;
            float xV = range - Math.abs(offset.method_10263()) + 1;
            float zV = range - Math.abs(offset.method_10260()) + 1;
            float candidate = Math.min(xV, zV);
            this.points = candidate * candidate;
            this.working = new class_2338.class_2339();
        }

        public float potentialPoints() {
            return this.points;
        }

        public float score(class_2338 playerPos) {
            this.working.method_10103(playerPos.method_10263() + this.offset.method_10263(), playerPos.method_10264() + this.offset.method_10264(), playerPos.method_10260() + this.offset.method_10260());
            class_1937 world = (class_1937)GameUtils.getWorld().orElseThrow();
            int playerHeight = Math.max(playerPos.method_10264() + 1, 0);
            this.working.method_33098(WorldUtils.getPrecipitationHeight(world, (class_2338)this.working));
            while (this.working.method_10264() > playerHeight) {
                class_2680 state = world.method_8320((class_2338)this.working);
                if (this.actsAsCeiling(state)) {
                    return 0.0f;
                }
                this.working.method_33098(this.working.method_10264() - 1);
            }
            return this.points;
        }

        @Override
        public int compareTo(Cell cell) {
            return -Float.compare(this.potentialPoints(), cell.potentialPoints());
        }

        public String toString() {
            return this.offset.toString() + " points: " + this.points;
        }

        private boolean actsAsCeiling(class_2680 state) {
            if (!state.method_51366()) {
                return false;
            }
            for (class_6862<class_2248> tag : NON_CEILING) {
                if (!TAG_LIBRARY.is(tag, state)) continue;
                return false;
            }
            return true;
        }
    }
}

