/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing.scanner;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_9380;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.effects.IBlockEffect;
import org.orecruncher.dsurround.effects.IEffectSystem;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.di.Cacheable;
import org.orecruncher.dsurround.lib.random.IRandomizer;
import org.orecruncher.dsurround.lib.scanner.CuboidScanner;
import org.orecruncher.dsurround.lib.scanner.ScanContext;

@Cacheable
public class SystemsScanner
extends CuboidScanner {
    private static final Predicate<IBlockEffect> EFFECT_PREDICATE = system -> {
        system.tick();
        return system.isDone();
    };
    private final Configuration config;
    private final ObjectArray<IEffectSystem> systems = new ObjectArray();
    private int lastRange;

    public SystemsScanner(Configuration config, ScanContext locus) {
        super(locus, "SystemsScanner", config.blockEffects.blockEffectRange);
        this.config = config;
        this.lastRange = config.blockEffects.blockEffectRange;
    }

    public void addEffectSystem(IEffectSystem system) {
        this.systems.add(system);
    }

    @Override
    public void resetFullScan() {
        super.resetFullScan();
        this.systems.forEach(IEffectSystem::clear);
    }

    @Override
    public void tick() {
        Predicate<IBlockEffect> filter;
        super.tick();
        if (this.lastRange != this.config.blockEffects.blockEffectRange) {
            this.lastRange = this.config.blockEffects.blockEffectRange;
            this.setRange(this.lastRange);
            return;
        }
        class_1657 player = GameUtils.getPlayer().orElseThrow();
        class_2338 current = player.method_24515();
        boolean sittingStill = this.lastPos.equals((Object)current);
        this.lastPos = current;
        if (!sittingStill) {
            int range = this.config.blockEffects.blockEffectRange;
            class_9380 blockBox = class_9380.method_58237((class_2338)current.method_10069(-range, -range, -range), (class_2338)current.method_10069(range, range, range));
            filter = system -> {
                if (blockBox.method_58244(system.getPos())) {
                    system.tick();
                } else {
                    system.remove();
                }
                return system.isDone();
            };
        } else {
            filter = EFFECT_PREDICATE;
        }
        this.processIfEnabled(true, system -> system.tick(filter));
    }

    protected void processIfEnabled(boolean clearSystems, Consumer<IEffectSystem> systemConsumer) {
        for (IEffectSystem system : this.systems) {
            if (system.isEnabled()) {
                systemConsumer.accept(system);
                continue;
            }
            if (!clearSystems) continue;
            system.clear();
        }
    }

    @Override
    public boolean doBlockUnscan() {
        return true;
    }

    @Override
    public void blockScan(class_1937 world, class_2680 state, class_2338 pos, IRandomizer rand) {
        this.processIfEnabled(false, system -> system.blockScan(world, state, pos));
    }

    @Override
    public void blockUnscan(class_1937 world, class_2680 state, class_2338 pos, IRandomizer rand) {
        this.processIfEnabled(false, system -> system.blockUnscan(world, state, pos));
    }

    public void gatherDiagnostics(Collection<class_2561> output) {
        this.systems.forEach(system -> {
            Object text = system.gatherDiagnostics();
            if (!system.isEnabled()) {
                text = (String)text + " (disabled)";
            }
            output.add((class_2561)class_2561.method_43470((String)text));
        });
    }
}

