/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.runtime.audio;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import net.minecraft.class_4231;
import net.minecraft.class_4234;
import org.jetbrains.annotations.NotNull;
import org.orecruncher.dsurround.mixins.audio.MixinSoundBuffer;

public final class Conversion {
    public static class_4234 convert(class_4234 inputStream) {
        AudioFormat format = inputStream.method_19719();
        if (format.getChannels() == 1) {
            return inputStream;
        }
        return new MonoStream(inputStream);
    }

    public static void convert(class_4231 buffer) {
        MixinSoundBuffer accessor = (MixinSoundBuffer)buffer;
        AudioFormat format = accessor.dsurround_getFormat();
        if (format.getChannels() == 1) {
            return;
        }
        int bits = format.getSampleSizeInBits();
        if (bits != 8 && bits != 16) {
            return;
        }
        boolean bigendian = format.isBigEndian();
        AudioFormat monoformat = new AudioFormat(format.getEncoding(), format.getSampleRate(), bits, 1, format.getFrameSize() >> 1, format.getFrameRate(), bigendian);
        ByteBuffer source = accessor.dsurround_getSample();
        if (source == null) {
            return;
        }
        int sourceLength = source.limit();
        int skip = format.getFrameSize();
        for (int i = 0; i < sourceLength; i += skip) {
            int v;
            int c2;
            int c1;
            int targetIdx = i >> 1;
            if (bits == 8) {
                c1 = source.get(i) >> 1;
                c2 = source.get(i + 1) >> 1;
                v = c1 + c2;
                source.put(targetIdx, (byte)v);
                continue;
            }
            c1 = source.getShort(i) >> 1;
            c2 = source.getShort(i + 2) >> 1;
            v = c1 + c2;
            source.putShort(targetIdx, (short)v);
        }
        accessor.dsurround_setFormat(monoformat);
        source.rewind();
        source.limit(sourceLength >> 1);
    }

    private record MonoStream(class_4234 source) implements class_4234
    {
        @NotNull
        public AudioFormat method_19719() {
            return this.source.method_19719();
        }

        @NotNull
        public ByteBuffer method_19720(int i) throws IOException {
            return this.source.method_19720(i);
        }

        public void close() throws IOException {
            this.source.close();
        }
    }
}

