/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.runtime.audio;

import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_4224;
import net.minecraft.class_4231;
import net.minecraft.class_4235;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.eventing.ClientEventHooks;
import org.orecruncher.dsurround.eventing.ClientState;
import org.orecruncher.dsurround.eventing.CollectDiagnosticsEvent;
import org.orecruncher.dsurround.lib.Singleton;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.threading.Worker;
import org.orecruncher.dsurround.mixinutils.IChannelHandle;
import org.orecruncher.dsurround.mixinutils.ISourceContext;
import org.orecruncher.dsurround.runtime.audio.AudioUtilities;
import org.orecruncher.dsurround.runtime.audio.Conversion;
import org.orecruncher.dsurround.runtime.audio.SourceContext;
import org.orecruncher.dsurround.runtime.audio.WorldContext;
import org.orecruncher.dsurround.runtime.audio.effects.Effects;

public final class SoundFXProcessor {
    private static final IModLog LOGGER = ContainerManager.resolve(IModLog.class);
    private static final int SOUND_PROCESS_ITERATION = 50;
    static boolean isAvailable;
    private static SourceContext[] sources;
    private static Worker soundProcessor;
    private static String diagnosticString;
    private static final Singleton<ExecutorService> threadPool;
    private static WorldContext worldContext;

    public static WorldContext getWorldContext() {
        return worldContext;
    }

    public static boolean isAvailable() {
        return isAvailable;
    }

    public static void initialize() {
        Effects.initialize();
        sources = new SourceContext[AudioUtilities.getMaxSounds()];
        if (soundProcessor == null) {
            soundProcessor = new Worker("Enhanced Sound Processor", SoundFXProcessor::processSounds, 50, LOGGER);
            soundProcessor.start();
        }
        isAvailable = true;
    }

    public static void deinitialize() {
        if (SoundFXProcessor.isAvailable()) {
            isAvailable = false;
            if (soundProcessor != null) {
                soundProcessor.stop();
                soundProcessor = null;
            }
            if (sources != null) {
                Arrays.fill(sources, null);
                sources = null;
            }
            Effects.deinitialize();
        }
    }

    private static boolean shouldIgnoreSound(class_1113 sound) {
        return sound.method_4787() || sound.method_4777() == class_1113.class_1114.field_5478 || sound.method_4774() == class_3419.field_15250 || sound.method_4774() == class_3419.field_15253 || sound.method_4774() == class_3419.field_15252;
    }

    public static void onSoundPlay(class_1113 sound, class_4235.class_4236 entry) {
        if (!SoundFXProcessor.isAvailable()) {
            return;
        }
        if (SoundFXProcessor.shouldIgnoreSound(sound)) {
            return;
        }
        ISourceContext source = (ISourceContext)((IChannelHandle)entry).dsurround_getSource();
        assert (source != null);
        int id = source.dsurround_getId();
        if (id > 0) {
            SourceContext ctx = new SourceContext(id);
            ctx.attachSound(sound);
            ctx.enable();
            source.dsurround_setData(ctx);
        }
    }

    public static void onSourcePlay(class_4224 source) {
        ISourceContext context = (ISourceContext)source;
        Optional<SourceContext> data = context.dsurround_getData();
        data.ifPresent(ctx -> {
            int id = ctx.getId();
            ctx.exec();
            SoundFXProcessor.sources[id - 1] = ctx;
        });
    }

    public static void tick(class_4224 source) {
        ISourceContext src = (ISourceContext)source;
        Optional<SourceContext> data = src.dsurround_getData();
        data.ifPresent(SourceContext::tick);
    }

    public static void stopSoundPlay(class_4224 source) {
        ISourceContext sourceContext = (ISourceContext)source;
        Optional<SourceContext> data = sourceContext.dsurround_getData();
        data.ifPresent(sc -> {
            SoundFXProcessor.sources[sc.getId() - 1] = null;
        });
    }

    public static void doMonoConversion(class_4224 source, class_4231 buffer) {
        if (!Client.Config.enhancedSounds.enableMonoConversion) {
            return;
        }
        Optional<SourceContext> data = ((ISourceContext)source).dsurround_getData();
        data.ifPresent(ctx -> {
            class_1113 s = ctx.getSound();
            if (s != null && s.method_4777() != class_1113.class_1114.field_5478 && !s.method_4787()) {
                Conversion.convert(buffer);
            }
        });
    }

    public static void clientTick(class_310 client) {
        if (SoundFXProcessor.isAvailable()) {
            worldContext = new WorldContext();
        }
    }

    private static void processSounds() {
        try {
            ExecutorService pool = threadPool.get();
            assert (pool != null);
            ObjectArray<Future> tasks = new ObjectArray<Future>(sources.length);
            for (SourceContext ctx : sources) {
                if (ctx == null || !ctx.shouldExecute()) continue;
                tasks.add(pool.submit(ctx));
            }
            diagnosticString = "(ticked: %d)".formatted(tasks.size());
            tasks.forEach(task -> {
                try {
                    task.get();
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
            });
        }
        catch (Throwable t) {
            LOGGER.error(t, "Error in SoundContext ForkJoinPool", new Object[0]);
        }
    }

    private static void onGatherText(CollectDiagnosticsEvent event) {
        if (SoundFXProcessor.isAvailable() && soundProcessor != null) {
            String msg = soundProcessor.getDiagnosticString() + " " + diagnosticString;
            event.add(CollectDiagnosticsEvent.Section.Systems, msg);
        } else {
            event.getSectionText(CollectDiagnosticsEvent.Section.Systems).add((class_2561)class_2561.method_43470((String)"Enhanced sound processing disabled"));
        }
    }

    static {
        diagnosticString = "";
        threadPool = new Singleton<Supplier<ExecutorService>>(() -> {
            Configuration.EnhancedSounds config = ContainerManager.resolve(Configuration.EnhancedSounds.class);
            int threads = config.backgroundThreadWorkers;
            if (threads == 0) {
                threads = 2;
            }
            LOGGER.info("Threads allocated to enhanced sound processor: %d", threads);
            return Executors.newFixedThreadPool(threads);
        });
        worldContext = new WorldContext();
        ClientEventHooks.COLLECT_DIAGNOSTICS.register(SoundFXProcessor::onGatherText);
        ClientState.TICK_START.register(SoundFXProcessor::clientTick);
    }
}

