/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.runtime.sets.impl;

import net.minecraft.class_1657;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import org.orecruncher.dsurround.config.BiomeTrait;
import org.orecruncher.dsurround.config.biome.BiomeInfo;
import org.orecruncher.dsurround.config.libraries.IBiomeLibrary;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.Lazy;
import org.orecruncher.dsurround.lib.scripting.IVariableAccess;
import org.orecruncher.dsurround.lib.scripting.VariableSet;
import org.orecruncher.dsurround.mixinutils.IBiomeExtended;
import org.orecruncher.dsurround.runtime.sets.IBiomeVariables;

public class BiomeVariables
extends VariableSet<IBiomeVariables>
implements IBiomeVariables {
    private final IBiomeLibrary biomeLibrary;
    private final Lazy<String> precipitationType = new Lazy<String>(() -> {
        class_2338 pos = GameUtils.getPlayer().orElseThrow().method_24515();
        return this.biome.method_48162(pos).name();
    });
    private final Lazy<String> id = new Lazy<String>(() -> this.info.getBiomeId().toString());
    private class_1959 biome;
    private BiomeInfo info;

    public BiomeVariables(IBiomeLibrary biomeLibrary) {
        super("biome");
        this.biomeLibrary = biomeLibrary;
    }

    @Override
    public IBiomeVariables getInterface() {
        return this;
    }

    @Override
    public void update(IVariableAccess variableAccess) {
        class_1959 newBiome = null;
        if (GameUtils.isInGame()) {
            class_1657 player = GameUtils.getPlayer().orElseThrow();
            newBiome = (class_1959)player.method_37908().method_23753(player.method_23312()).comp_349();
        }
        this.setBiome(newBiome, variableAccess);
    }

    public void setBiome(class_1959 biome, IVariableAccess variableAccess) {
        if (biome != null) {
            BiomeInfo info = this.biomeLibrary.getBiomeInfo(biome);
            this.setBiome(biome, info, variableAccess);
        } else {
            this.setBiome(null, null, variableAccess);
        }
    }

    public void setBiome(class_1959 biome, BiomeInfo info, IVariableAccess variableAccess) {
        this.biome = biome;
        this.info = info;
        this.id.reset();
        this.precipitationType.reset();
        for (BiomeTrait trait2 : BiomeTrait.values()) {
            variableAccess.put(trait2.getName(), false);
        }
        if (this.info != null) {
            this.info.getTraits().forEach(trait -> variableAccess.put(trait.getName(), true));
        }
    }

    @Override
    public String getModId() {
        return this.info.getBiomeId().method_12836();
    }

    @Override
    public String getId() {
        return (String)this.id.get();
    }

    @Override
    public String getName() {
        return this.info.getBiomeName();
    }

    @Override
    public float getRainfall() {
        return ((IBiomeExtended)this.biome).dsurround_getWeather().comp_846();
    }

    @Override
    public float getTemperature() {
        return this.biome.method_8712();
    }

    @Override
    public String getPrecipitationType() {
        return (String)this.precipitationType.get();
    }

    @Override
    public String getTraits() {
        return this.info.getTraits().toString();
    }

    @Override
    public boolean is(String trait) {
        return this.info.hasTrait(trait);
    }

    @Override
    public boolean isAllOf(String ... trait) {
        if (trait == null) {
            return false;
        }
        for (String t : trait) {
            if (this.is(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isOneOf(String ... trait) {
        if (trait == null) {
            return false;
        }
        for (String t : trait) {
            if (!this.is(t)) continue;
            return true;
        }
        return false;
    }
}

