/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.runtime.sets.impl;

import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.registry.RegistryUtils;
import org.orecruncher.dsurround.lib.scripting.IVariableAccess;
import org.orecruncher.dsurround.lib.scripting.VariableSet;
import org.orecruncher.dsurround.lib.world.WorldUtils;
import org.orecruncher.dsurround.runtime.sets.IPlayerVariables;

public class PlayerVariables
extends VariableSet<IPlayerVariables>
implements IPlayerVariables {
    private boolean isSuffocating;
    private boolean canSeeSky;
    private boolean canRainOn;
    private boolean isCreative;
    private boolean isBurning;
    private boolean isFlying;
    private boolean isSprinting;
    private boolean isInLava;
    private boolean isInvisible;
    private boolean isInWater;
    private boolean isWet;
    private boolean isRiding;
    private boolean isOnGround;
    private boolean isMoving;
    private float health;
    private float maxHealth;
    private float foodLevel;
    private float foodSaturationLevel;
    private double x;
    private double y;
    private double z;

    public PlayerVariables() {
        super("player");
    }

    @Override
    public void update(IVariableAccess variableAccess) {
        if (GameUtils.isInGame()) {
            class_1657 player = GameUtils.getPlayer().orElseThrow();
            class_1702 hm = player.method_7344();
            class_1937 world = player.method_37908();
            this.isCreative = player.method_7337();
            this.isBurning = player.method_5809();
            this.isFlying = player.method_31549().field_7479;
            this.isSprinting = player.method_5624();
            this.isInLava = player.method_5771();
            this.isInvisible = player.method_5767();
            this.isInWater = player.method_5869();
            this.isWet = player.method_5721();
            this.isRiding = player.method_5765();
            this.isOnGround = player.method_24828();
            this.isMoving = player.field_7483 != player.field_7505;
            this.health = player.method_6032();
            this.maxHealth = player.method_6063();
            this.foodLevel = hm.method_7586();
            this.foodSaturationLevel = hm.method_7589();
            this.x = player.method_23317();
            this.y = player.method_23318();
            this.z = player.method_23321();
            this.isSuffocating = !player.method_7337() && player.method_5669() < 0;
            this.canRainOn = world.method_8311(player.method_24515().method_10069(0, 2, 0));
            this.canSeeSky = this.canRainOn && WorldUtils.getTopSolidOrLiquidBlock(world, player.method_24515()).method_10264() <= player.method_24515().method_10264();
        } else {
            this.isCreative = false;
            this.isBurning = false;
            this.isFlying = false;
            this.isSprinting = false;
            this.isInLava = false;
            this.isInvisible = false;
            this.isInWater = false;
            this.isWet = false;
            this.isRiding = false;
            this.isOnGround = false;
            this.health = 20.0f;
            this.maxHealth = 20.0f;
            this.foodLevel = 20.0f;
            this.foodSaturationLevel = 20.0f;
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
            this.isSuffocating = false;
            this.canRainOn = false;
            this.canSeeSky = false;
        }
    }

    @Override
    public IPlayerVariables getInterface() {
        return this;
    }

    @Override
    public boolean isCreative() {
        return this.isCreative;
    }

    @Override
    public boolean isBurning() {
        return this.isBurning;
    }

    @Override
    public boolean isSuffocating() {
        return this.isSuffocating;
    }

    @Override
    public boolean isFlying() {
        return this.isFlying;
    }

    @Override
    public boolean isSprinting() {
        return this.isSprinting;
    }

    @Override
    public boolean isInLava() {
        return this.isInLava;
    }

    @Override
    public boolean isInvisible() {
        return this.isInvisible;
    }

    @Override
    public boolean isInWater() {
        return this.isInWater;
    }

    @Override
    public boolean isMoving() {
        return this.isMoving;
    }

    @Override
    public boolean isWet() {
        return this.isWet;
    }

    @Override
    public boolean isRiding() {
        return this.isRiding;
    }

    @Override
    public boolean isOnGround() {
        return this.isOnGround;
    }

    @Override
    public boolean canRainOn() {
        return this.canRainOn;
    }

    @Override
    public boolean canSeeSky() {
        return this.canSeeSky;
    }

    @Override
    public float getHealth() {
        return this.health;
    }

    @Override
    public float getMaxHealth() {
        return this.maxHealth;
    }

    @Override
    public float getFoodLevel() {
        return this.foodLevel;
    }

    @Override
    public float getFoodSaturationLevel() {
        return this.foodSaturationLevel;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public boolean hasEffect(String effect) {
        try {
            class_2960 id = class_2960.method_60654((String)effect);
            class_6880.class_6883 r = RegistryUtils.getRegistryEntry(class_7924.field_41208, id).orElseThrow();
            return GameUtils.getPlayer().map(p -> p.method_6059((class_6880)r)).orElse(false);
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

