/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.runtime.sets.impl;

import net.minecraft.class_1657;
import net.minecraft.class_1937;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.scripting.IVariableAccess;
import org.orecruncher.dsurround.lib.scripting.VariableSet;
import org.orecruncher.dsurround.lib.seasons.ISeasonalInformation;
import org.orecruncher.dsurround.runtime.sets.IWeatherVariables;

public class WeatherVariables
extends VariableSet<IWeatherVariables>
implements IWeatherVariables {
    private final ISeasonalInformation seasonalInformation;
    private float temperature;
    private boolean isRaining;
    private boolean isThundering;
    private float rainIntensity;
    private float thunderIntensity;
    private boolean isFrosty;
    private boolean canWaterFreeze;

    public WeatherVariables(ISeasonalInformation seasonalInformation) {
        super("weather");
        this.seasonalInformation = seasonalInformation;
    }

    @Override
    public IWeatherVariables getInterface() {
        return this;
    }

    @Override
    public void update(IVariableAccess variableAccess) {
        if (GameUtils.isInGame()) {
            class_1657 player = GameUtils.getPlayer().orElseThrow();
            class_1937 world = player.method_37908();
            this.rainIntensity = world.method_8430(1.0f);
            this.thunderIntensity = world.method_8478(1.0f);
            this.isRaining = world.method_8419();
            this.isThundering = world.method_8546();
            this.temperature = this.seasonalInformation.getTemperature(player.method_24515());
            this.isFrosty = this.seasonalInformation.isColdTemperature(player.method_24515());
            this.canWaterFreeze = this.seasonalInformation.isSnowTemperature(player.method_24515());
        } else {
            this.rainIntensity = 0.0f;
            this.thunderIntensity = 0.0f;
            this.isRaining = false;
            this.isThundering = false;
            this.temperature = 0.0f;
            this.isFrosty = false;
            this.canWaterFreeze = false;
        }
    }

    @Override
    public boolean isRaining() {
        return this.isRaining;
    }

    @Override
    public boolean isThundering() {
        return this.isThundering;
    }

    @Override
    public float getRainIntensity() {
        return this.rainIntensity;
    }

    @Override
    public float getThunderIntensity() {
        return this.thunderIntensity;
    }

    @Override
    public float getTemperature() {
        return this.temperature;
    }

    @Override
    public boolean isFrosty() {
        return this.isFrosty;
    }

    @Override
    public boolean canWaterFreeze() {
        return this.canWaterFreeze;
    }
}

