/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.sound;

import com.google.common.base.MoreObjects;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1106;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5195;
import net.minecraft.class_5819;
import net.minecraft.class_5862;
import net.minecraft.class_5863;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.orecruncher.dsurround.lib.IdentityUtils;
import org.orecruncher.dsurround.lib.random.Randomizer;
import org.orecruncher.dsurround.sound.BackgroundSoundLoop;
import org.orecruncher.dsurround.sound.ISoundFactory;
import org.orecruncher.dsurround.sound.SoundCodecHelpers;
import org.orecruncher.dsurround.sound.SoundFactoryBuilder;

public record SoundFactory(Optional<class_2960> location, class_3414 soundEvent, class_5863 volume, class_5863 pitch, class_3419 category, boolean isRepeatable, int repeatDelay, boolean global, class_1113.class_1114 attenuation, MusicSettings musicSettings) implements Comparable<ISoundFactory>,
ISoundFactory
{
    public static final Codec<SoundFactory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IdentityUtils.CODEC.optionalFieldOf("location").forGetter(SoundFactory::location), (App)SoundCodecHelpers.SOUND_EVENT_CODEC.fieldOf("soundEvent").forGetter(SoundFactory::soundEvent), (App)SoundCodecHelpers.SOUND_PROPERTY_RANGE.optionalFieldOf("volume", (Object)class_5862.method_33908((float)1.0f)).forGetter(SoundFactory::volume), (App)SoundCodecHelpers.SOUND_PROPERTY_RANGE.optionalFieldOf("pitch", (Object)class_5862.method_33908((float)1.0f)).forGetter(SoundFactory::pitch), (App)SoundCodecHelpers.SOUND_CATEGORY_CODEC.optionalFieldOf("category", (Object)class_3419.field_15256).forGetter(SoundFactory::category), (App)Codec.BOOL.optionalFieldOf("isRepeatable", (Object)false).forGetter(SoundFactory::isRepeatable), (App)Codec.INT.optionalFieldOf("repeatDelay", (Object)0).forGetter(SoundFactory::repeatDelay), (App)Codec.BOOL.optionalFieldOf("global", (Object)false).forGetter(SoundFactory::global), (App)SoundCodecHelpers.ATTENUATION_CODEC.optionalFieldOf("attenuation", (Object)class_1113.class_1114.field_5476).forGetter(SoundFactory::attenuation), (App)MusicSettings.CODEC.optionalFieldOf("music", (Object)MusicSettings.DEFAULT).forGetter(SoundFactory::musicSettings)).apply((Applicative)instance, SoundFactory::new));
    private static final Map<class_3414, class_5195> MUSIC_MAP = new HashMap<class_3414, class_5195>();

    @Override
    public class_2960 getLocation() {
        return this.location.orElse(this.soundEvent.method_14833());
    }

    @Override
    public BackgroundSoundLoop createBackgroundSoundLoop() {
        return new BackgroundSoundLoop(this.soundEvent).setVolume(this.getVolume()).setPitch(this.getPitch());
    }

    @Override
    public BackgroundSoundLoop createBackgroundSoundLoopAt(class_2338 pos) {
        return new BackgroundSoundLoop(this.soundEvent, pos).setVolume(this.getVolume()).setPitch(this.getPitch());
    }

    @Override
    public class_1109 createAsAdditional() {
        return new class_1109(this.soundEvent.method_14833(), this.category, this.getVolume(), this.getPitch(), (class_5819)Randomizer.current(), this.isRepeatable, this.repeatDelay, this.attenuation, 0.0, 0.0, 0.0, true);
    }

    @Override
    public class_1106 attachToEntity(class_1297 entity) {
        return new class_1106(this.soundEvent, this.category, this.getVolume(), this.getPitch(), entity, Randomizer.current().method_43055());
    }

    @Override
    public class_1109 createAtLocation(double posX, double posY, double posZ, float volumeScale) {
        return new class_1109(this.soundEvent.method_14833(), this.category, this.getVolume() * volumeScale, this.getPitch(), (class_5819)Randomizer.current(), this.isRepeatable, this.repeatDelay, this.attenuation, posX, posY, posZ, this.global);
    }

    @Override
    public class_5195 createAsMusic() {
        return MUSIC_MAP.computeIfAbsent(this.soundEvent, key -> {
            class_6880 holder = class_6880.method_40223((Object)key);
            return new class_5195(holder, this.musicSettings.minDelay, this.musicSettings.maxDelay, this.musicSettings.replaceCurrentMusic);
        });
    }

    private float getVolume() {
        return this.volume.method_33920((class_5819)Randomizer.current());
    }

    private float getPitch() {
        return this.pitch.method_33920((class_5819)Randomizer.current());
    }

    @Override
    public int hashCode() {
        return this.getLocation().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SoundFactory)) return false;
        SoundFactory f = (SoundFactory)obj;
        if (!this.getLocation().equals((Object)f.getLocation())) return false;
        return true;
    }

    @Override
    public int compareTo(@NotNull ISoundFactory o) {
        return this.getLocation().method_12833(o.getLocation());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("location", (Object)this.getLocation()).add("soundEvent", (Object)this.soundEvent.method_14833()).toString();
    }

    static ISoundFactory from(SoundFactoryBuilder builder) {
        return new SoundFactory(Optional.empty(), builder.soundEvent, builder.volume, builder.pitch, builder.category, builder.isRepeatable, builder.repeatDelay, builder.global, builder.attenuation, new MusicSettings(builder.musicMinDelay, builder.musicMaxDelay, builder.musicReplaceMusic));
    }

    public record MusicSettings(int minDelay, int maxDelay, boolean replaceCurrentMusic) {
        public static final MusicSettings DEFAULT = new MusicSettings(6000, 24000, false);
        public static final Codec<MusicSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("min_delay", (Object)DEFAULT.minDelay()).forGetter(MusicSettings::minDelay), (App)Codec.INT.optionalFieldOf("max_delay", (Object)DEFAULT.maxDelay()).forGetter(MusicSettings::maxDelay), (App)Codec.BOOL.optionalFieldOf("replace_current_music", (Object)DEFAULT.replaceCurrentMusic()).forGetter(MusicSettings::replaceCurrentMusic)).apply((Applicative)instance, MusicSettings::new));
    }
}

