/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.sound;

import net.minecraft.class_1113;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5195;
import net.minecraft.class_5862;
import net.minecraft.class_5863;
import net.minecraft.class_5866;
import org.orecruncher.dsurround.config.libraries.ISoundLibrary;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.sound.ISoundFactory;
import org.orecruncher.dsurround.sound.SoundFactory;

public final class SoundFactoryBuilder {
    final class_3414 soundEvent;
    class_5863 volume;
    class_5863 pitch;
    class_3419 category;
    boolean isRepeatable = false;
    int repeatDelay = 0;
    boolean global = false;
    class_1113.class_1114 attenuation;
    int musicMinDelay = SoundFactory.MusicSettings.DEFAULT.minDelay();
    int musicMaxDelay = SoundFactory.MusicSettings.DEFAULT.maxDelay();
    boolean musicReplaceMusic = SoundFactory.MusicSettings.DEFAULT.replaceCurrentMusic();

    SoundFactoryBuilder(class_3414 soundEvent) {
        this.soundEvent = soundEvent;
        this.volume = class_5862.method_33908((float)1.0f);
        this.pitch = class_5862.method_33908((float)1.0f);
        this.category = class_3419.field_15256;
        this.attenuation = class_1113.class_1114.field_5476;
    }

    public SoundFactoryBuilder volume(float vol) {
        return this.volume((class_5863)class_5862.method_33908((float)vol));
    }

    public SoundFactoryBuilder volume(float min, float max) {
        return this.volume((class_5863)(Float.compare(min, max) == 0 ? class_5862.method_33908((float)min) : class_5866.method_33934((float)min, (float)max)));
    }

    public SoundFactoryBuilder volume(class_5863 provider) {
        this.volume = provider;
        return this;
    }

    public SoundFactoryBuilder pitch(float pitch) {
        return this.pitch((class_5863)class_5862.method_33908((float)pitch));
    }

    public SoundFactoryBuilder pitch(float min, float max) {
        return this.pitch((class_5863)(Float.compare(min, max) == 0 ? class_5862.method_33908((float)min) : class_5866.method_33934((float)min, (float)max)));
    }

    public SoundFactoryBuilder pitch(class_5863 provider) {
        this.pitch = provider;
        return this;
    }

    public SoundFactoryBuilder category(class_3419 category) {
        this.category = category;
        return this;
    }

    public SoundFactoryBuilder repeatable() {
        this.isRepeatable = true;
        this.repeatDelay = 0;
        return this;
    }

    public SoundFactoryBuilder repeatable(int delay) {
        this.isRepeatable = true;
        this.repeatDelay = delay;
        return this;
    }

    public SoundFactoryBuilder attenuation(class_1113.class_1114 attenuation) {
        this.attenuation = attenuation;
        this.global = attenuation == class_1113.class_1114.field_5478;
        return this;
    }

    public SoundFactoryBuilder global() {
        this.attenuation = class_1113.class_1114.field_5478;
        this.global = true;
        return this;
    }

    public SoundFactoryBuilder setMusicMinDelay(int delay) {
        this.musicMinDelay = delay;
        return this;
    }

    public SoundFactoryBuilder setMusicMaxDelay(int delay) {
        this.musicMaxDelay = delay;
        return this;
    }

    public SoundFactoryBuilder setMusicReplaceCurrentMusic(boolean flag) {
        this.musicReplaceMusic = flag;
        return this;
    }

    public ISoundFactory build() {
        return SoundFactory.from(this);
    }

    public static SoundFactoryBuilder create(String soundEventId) {
        class_3414 se = ContainerManager.resolve(ISoundLibrary.class).getSound(soundEventId);
        return SoundFactoryBuilder.create(se);
    }

    public static SoundFactoryBuilder create(class_2960 soundEventId) {
        class_3414 se = ContainerManager.resolve(ISoundLibrary.class).getSound(soundEventId);
        return SoundFactoryBuilder.create(se);
    }

    public static SoundFactoryBuilder create(class_3414 soundEvent) {
        return new SoundFactoryBuilder(soundEvent);
    }

    public static SoundFactoryBuilder create(class_5195 music) {
        return new SoundFactoryBuilder((class_3414)music.method_27279().comp_349()).setMusicMinDelay(music.method_27280()).setMusicMaxDelay(music.method_27281()).setMusicReplaceCurrentMusic(music.method_27282());
    }
}

