/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.sound;

import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Objects;
import net.minecraft.class_1103;
import net.minecraft.class_1113;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.config.libraries.ISoundLibrary;
import org.orecruncher.dsurround.gui.sound.ConfigSoundInstance;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.Library;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.system.ITickCount;
import org.orecruncher.dsurround.lib.threading.IClientTasking;
import org.orecruncher.dsurround.sound.IAudioPlayer;

public final class SoundInstanceHandler {
    private static final IClientTasking CLIENT_TASKING = ContainerManager.resolve(IClientTasking.class);
    private static final ISoundLibrary SOUND_LIBRARY = ContainerManager.resolve(ISoundLibrary.class);
    private static final IAudioPlayer AUDIO_PLAYER = ContainerManager.resolve(IAudioPlayer.class);
    private static final ITickCount TICK_COUNT = ContainerManager.resolve(ITickCount.class);
    private static final Configuration.SoundSystem SOUND_SYSTEM_CONFIG = ContainerManager.resolve(Configuration.SoundSystem.class);
    private static final Object2LongOpenHashMap<class_2960> SOUND_CULL = new Object2LongOpenHashMap(32);

    private static boolean isSoundBlocked(class_2960 id) {
        return SOUND_LIBRARY.isBlocked(id);
    }

    private static boolean isSoundCulled(class_2960 id) {
        return SOUND_LIBRARY.isCulled(id);
    }

    private static boolean isSoundCulledLogical(class_2960 sound) {
        int cullInterval = SoundInstanceHandler.SOUND_SYSTEM_CONFIG.cullInterval;
        if (cullInterval > 0 && SoundInstanceHandler.isSoundCulled(sound)) {
            long lastOccurrence = SOUND_CULL.getLong((Object)Objects.requireNonNull(sound));
            long currentTick = TICK_COUNT.getTickCount();
            if (currentTick - lastOccurrence < (long)cullInterval) {
                return true;
            }
            SOUND_CULL.put((Object)sound, currentTick);
        }
        return false;
    }

    public static boolean shouldBlockSoundPlay(class_1113 theSound) {
        if (theSound instanceof ConfigSoundInstance) {
            return false;
        }
        class_2960 id = theSound.method_4775();
        return SoundInstanceHandler.isSoundBlocked(id) || SoundInstanceHandler.isSoundCulledLogical(id);
    }

    public static boolean remapSoundPlay(class_1113 theSound) {
        return SOUND_LIBRARY.remapSound(theSound).map(s -> {
            AUDIO_PLAYER.play((class_1113)s);
            return true;
        }).orElse(false);
    }

    public static boolean inRange(class_243 listener, class_1113 sound, int pad) {
        if (sound.method_4787() || sound.method_4777() == class_1113.class_1114.field_5478 || sound.method_4774() == class_3419.field_15252) {
            return true;
        }
        if (sound instanceof class_1103) {
            return true;
        }
        if (sound.method_4784() == 0.0 && sound.method_4779() == 0.0 && sound.method_4778() == 0.0) {
            return true;
        }
        if (sound.method_4776() == null) {
            try {
                CLIENT_TASKING.execute(() -> sound.method_4783(GameUtils.getSoundManager()));
            }
            catch (Throwable t) {
                Library.LOGGER.error(t, "Unable to set sound on sound instance", new Object[0]);
            }
        }
        if (sound.method_4781() > 1.0f) {
            return true;
        }
        int distSq = sound.method_4776().method_4770() + pad;
        distSq *= distSq;
        return listener.method_1028(sound.method_4784(), sound.method_4779(), sound.method_4778()) < (double)distSq;
    }

    public static boolean inRange(class_243 listener, class_1113 sound) {
        return SoundInstanceHandler.inRange(listener, sound, 0);
    }
}

