/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.sound;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import org.orecruncher.dsurround.config.data.SoundMetadataConfig;

public final class SoundMetadata {
    private final class_2561 title;
    private final class_2561 subTitle;
    private final List<Credit> credits;
    private final class_3419 category;
    private final boolean isDefault;

    public SoundMetadata() {
        this.title = class_2561.method_43473();
        this.subTitle = class_2561.method_43473();
        this.credits = ImmutableList.of();
        this.category = class_3419.field_15256;
        this.isDefault = true;
    }

    public SoundMetadata(class_2960 location) {
        this.title = class_2561.method_43473();
        this.subTitle = class_2561.method_43473();
        this.credits = ImmutableList.of();
        this.isDefault = false;
        this.category = this.estimateSoundSource(location);
    }

    public SoundMetadata(class_2960 location, SoundMetadataConfig cfg) {
        Objects.requireNonNull(cfg);
        this.isDefault = false;
        this.title = (class_2561)cfg.title().map(class_2561::method_43471).orElse(class_2561.method_43473());
        this.subTitle = (class_2561)cfg.subtitle().map(class_2561::method_43471).orElse(class_2561.method_43473());
        if (cfg.credits() == null || cfg.credits().isEmpty()) {
            this.credits = ImmutableList.of();
        } else {
            ArrayList<Credit> temp = new ArrayList<Credit>(cfg.credits().size());
            for (SoundMetadataConfig.CreditEntry entry : cfg.credits()) {
                class_2561 name = class_2561.method_30163((String)class_124.method_539((String)entry.name()));
                class_2561 author = class_2561.method_30163((String)class_124.method_539((String)entry.author()));
                Optional<class_2561> webSite = entry.website().map(website -> class_2561.method_30163((String)class_124.method_539((String)website)));
                class_2561 license = class_2561.method_30163((String)class_124.method_539((String)entry.license()));
                Credit creditEntry = new Credit(name, author, webSite, license);
                temp.add(creditEntry);
            }
            this.credits = ImmutableList.copyOf(temp);
        }
        this.category = cfg.category().orElseGet(() -> this.estimateSoundSource(location));
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    private class_3419 estimateSoundSource(class_2960 location) {
        String path = location.method_12832();
        if (path.startsWith("music")) {
            return class_3419.field_15253;
        }
        if (path.startsWith("block")) {
            return class_3419.field_15245;
        }
        if (path.startsWith("entity") && path.endsWith("step")) {
            return class_3419.field_15254;
        }
        if (path.startsWith("entity")) {
            return class_3419.field_15251;
        }
        if (path.startsWith("weather")) {
            return class_3419.field_15252;
        }
        if (path.startsWith("ambient")) {
            return class_3419.field_15256;
        }
        return class_3419.field_15256;
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public class_2561 getSubTitle() {
        return this.subTitle;
    }

    public List<Credit> getCredits() {
        return this.credits;
    }

    public class_3419 getCategory() {
        return this.category;
    }

    public record Credit(class_2561 name, class_2561 author, Optional<class_2561> webSite, class_2561 license) {
    }
}

