/*
 * Decompiled with CFR 0.152.
 */
package com.mythicmetals.ability;

import com.mythicmetals.armor.ArmorSet;
import com.mythicmetals.item.tools.ToolSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public class Ability {
    private final String tooltip;
    private final int level;
    private final Set<class_1792> items;
    private boolean showLevel = true;

    public Ability(String translationKey, int level) {
        this.tooltip = translationKey;
        this.level = level;
        this.items = new HashSet<class_1792>();
    }

    public Ability(String translationKey, int level, boolean showLevel) {
        this.tooltip = translationKey;
        this.level = level;
        this.items = new HashSet<class_1792>();
        this.showLevel = showLevel;
    }

    public int getLevel() {
        return this.level;
    }

    public Set<class_1792> getItems() {
        return this.items;
    }

    public void addItem(class_1792 item, class_2583 style) {
        this.items.add(item);
        if (FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.CLIENT)) {
            this.addTooltip(item, style);
        }
    }

    public void addArmorSet(ArmorSet armorSet, class_2583 style) {
        this.items.add((class_1792)armorSet.getHelmet());
        this.items.add((class_1792)armorSet.getChestplate());
        this.items.add((class_1792)armorSet.getLeggings());
        this.items.add((class_1792)armorSet.getBoots());
        if (FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.CLIENT)) {
            this.addTooltip((class_1792)armorSet.getHelmet(), style);
            this.addTooltip((class_1792)armorSet.getChestplate(), style);
            this.addTooltip((class_1792)armorSet.getLeggings(), style);
            this.addTooltip((class_1792)armorSet.getBoots(), style);
        }
    }

    public void addToolSet(ToolSet toolSet, class_2583 style) {
        this.items.add((class_1792)toolSet.getSword());
        this.items.add((class_1792)toolSet.getAxe());
        this.items.add((class_1792)toolSet.getHoe());
        this.items.add((class_1792)toolSet.getPickaxe());
        this.items.add((class_1792)toolSet.getShovel());
        if (FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.CLIENT)) {
            this.addTooltip((class_1792)toolSet.getSword(), style);
            this.addTooltip((class_1792)toolSet.getAxe(), style);
            this.addTooltip((class_1792)toolSet.getHoe(), style);
            this.addTooltip((class_1792)toolSet.getPickaxe(), style);
            this.addTooltip((class_1792)toolSet.getShovel(), style);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void addTooltip(class_1792 item, class_2583 style) {
        ItemTooltipCallback.EVENT.register((stack, context, type, lines) -> {
            class_5250 text = class_2561.method_43470((String)"");
            if (stack.method_31574(item)) {
                text.method_10852((class_2561)class_2561.method_43471((String)("abilities.mythicmetals." + this.tooltip)));
                text.method_10862(style);
                if (this.showLevel) {
                    text.method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)("enchantment.level." + this.level)));
                }
                if (lines.size() > 2) {
                    int enchantCount = stack.method_58657().method_57541();
                    lines.add(enchantCount + 1, text);
                } else {
                    lines.add(text);
                }
            }
        });
    }

    public static void addTooltipOnStack(class_1799 stack, List<class_2561> lines, class_2583 style, String translationKey) {
        class_5250 text = class_2561.method_43470((String)"");
        text.method_10852((class_2561)class_2561.method_43471((String)translationKey));
        text.method_10862(style);
        if (lines.size() > 2) {
            int enchantCount = stack.method_58657().method_57541();
            lines.add(enchantCount + 1, (class_2561)text);
        } else {
            lines.add((class_2561)text);
        }
    }
}

