/*
 * Decompiled with CFR 0.152.
 */
package com.mythicmetals.command;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mythicmetals.MythicMetals;
import com.mythicmetals.armor.ArmorSet;
import com.mythicmetals.armor.MythicArmor;
import com.mythicmetals.block.BlockSet;
import com.mythicmetals.block.MythicBlocks;
import com.mythicmetals.command.ArmorSetArgumentType;
import com.mythicmetals.command.BlockSetArgumentType;
import com.mythicmetals.command.OreConfigArgumentType;
import com.mythicmetals.command.ToolSetArgumentType;
import com.mythicmetals.command.WikiExporter;
import com.mythicmetals.config.MythicOreConfigs;
import com.mythicmetals.config.OreConfig;
import com.mythicmetals.item.tools.MythicTools;
import com.mythicmetals.item.tools.ToolSet;
import com.mythicmetals.misc.RegistryHelper;
import com.mythicmetals.misc.StringUtilsAtHome;
import io.wispforest.owo.util.ReflectionUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1531;
import net.minecraft.class_173;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3039;
import net.minecraft.class_3218;
import net.minecraft.class_3489;
import net.minecraft.class_52;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8056;
import net.minecraft.class_8113;
import net.minecraft.class_8567;
import net.minecraft.class_9334;
import net.minecraft.class_9433;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MythicCommands {
    public static final String ITEM_SCALE = "{ .sized-image style=\"--image-width: 40%;\" }";
    public static final String RECIPE_SCALE = "{ .sized-recipe style=\"--image-width: 40%;\" }";
    public static final String ICON_SCALE = "{ .sized-image style=\"--image-width: 8%;\" }";
    public static final String BR = "<br>\n";
    public static BiMap<String, OreConfig> ORE_CONFIG = HashBiMap.create();

    private MythicCommands() {
    }

    public static void init() {
        ReflectionUtils.iterateAccessibleStaticFields(MythicOreConfigs.class, OreConfig.class, (value, name, field) -> ORE_CONFIG.put((Object)name, value));
        ArgumentTypeRegistry.registerArgumentType((class_2960)RegistryHelper.id("toolset"), ToolSetArgumentType.class, (class_2314)class_2319.method_41999(ToolSetArgumentType::toolSet));
        ArgumentTypeRegistry.registerArgumentType((class_2960)RegistryHelper.id("armorset"), ArmorSetArgumentType.class, (class_2314)class_2319.method_41999(ArmorSetArgumentType::armorSet));
        ArgumentTypeRegistry.registerArgumentType((class_2960)RegistryHelper.id("ore-config"), OreConfigArgumentType.class, (class_2314)class_2319.method_41999(OreConfigArgumentType::oreConfig));
        ArgumentTypeRegistry.registerArgumentType((class_2960)RegistryHelper.id("blockset"), BlockSetArgumentType.class, (class_2314)class_2319.method_41999(BlockSetArgumentType::blockSet));
    }

    public static void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, access, env) -> {
            LiteralCommandNode mythicRoot = ((LiteralArgumentBuilder)class_2170.method_9247((String)"mythicmetals").requires(src -> src.method_9259(2))).build();
            LiteralCommandNode range = class_2170.method_9247((String)"range").build();
            LiteralCommandNode tools = class_2170.method_9247((String)"tools").build();
            LiteralCommandNode allTools = ((LiteralArgumentBuilder)class_2170.method_9247((String)"tools-all").executes(MythicCommands::exportAllTools)).build();
            LiteralCommandNode ores = class_2170.method_9247((String)"ores").build();
            LiteralCommandNode armor = class_2170.method_9247((String)"armor").build();
            LiteralCommandNode wiki = class_2170.method_9247((String)"wiki").build();
            LiteralCommandNode armorStand = class_2170.method_9247((String)"armor-stand").build();
            LiteralCommandNode loot = class_2170.method_9247((String)"test-loot-table").build();
            LiteralCommandNode display = class_2170.method_9247((String)"place-display").build();
            LiteralCommandNode placeBlocks = ((LiteralArgumentBuilder)class_2170.method_9247((String)"place-all-blocks").executes(context -> MythicCommands.placeAllBlocksets((CommandContext<class_2168>)context, Map.of()))).build();
            ArgumentCommandNode rangeType = ((RequiredArgumentBuilder)class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).suggests(MythicCommands::dumpType).executes(MythicCommands::dumpAllOreConfigs)).build();
            ArgumentCommandNode exportOres = ((RequiredArgumentBuilder)class_2170.method_9244((String)"ore-config", (ArgumentType)OreConfigArgumentType.oreConfig()).executes(MythicCommands::exportOreData)).build();
            ArgumentCommandNode exportTools = ((RequiredArgumentBuilder)class_2170.method_9244((String)"toolset", (ArgumentType)ToolSetArgumentType.toolSet()).executes(MythicCommands::exportTools)).build();
            ArgumentCommandNode exportArmor = ((RequiredArgumentBuilder)class_2170.method_9244((String)"armorset", (ArgumentType)ArmorSetArgumentType.armorSet()).executes(MythicCommands::exportArmor)).build();
            ArgumentCommandNode placeDisplay = ((RequiredArgumentBuilder)class_2170.method_9244((String)"material", (ArgumentType)StringArgumentType.word()).suggests(MythicCommands::material).executes(MythicCommands::placeMythicDisplay)).build();
            ArgumentCommandNode lootTables = ((RequiredArgumentBuilder)class_2170.method_9244((String)"loot_table", (ArgumentType)class_9433.class_9436.method_58482((class_7157)access)).suggests(class_3039.field_13605).then(class_2170.method_9244((String)"rolls", (ArgumentType)IntegerArgumentType.integer()).executes(MythicCommands::testLootTable))).build();
            RequiredArgumentBuilder trimPattern = (RequiredArgumentBuilder)class_2170.method_9244((String)"trim_pattern", (ArgumentType)StringArgumentType.word()).suggests(MythicCommands::trimTypes).executes(context -> {
                String matQuery = StringArgumentType.getString((CommandContext)context, (String)"material");
                String trimQuery = StringArgumentType.getString((CommandContext)context, (String)"trim_pattern");
                return MythicCommands.armorStandCommand((CommandContext<class_2168>)context, matQuery, trimQuery);
            });
            ArgumentCommandNode summonTrims = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"material", (ArgumentType)StringArgumentType.word()).suggests(MythicCommands::armorMaterial).executes(context -> {
                String mat = StringArgumentType.getString((CommandContext)context, (String)"material");
                return MythicCommands.armorStandCommand((CommandContext<class_2168>)context, mat, null);
            })).then((ArgumentBuilder)trimPattern)).build();
            ores.addChild((CommandNode)exportOres);
            tools.addChild((CommandNode)exportTools);
            armor.addChild((CommandNode)exportArmor);
            wiki.addChild((CommandNode)ores);
            wiki.addChild((CommandNode)tools);
            wiki.addChild((CommandNode)allTools);
            wiki.addChild((CommandNode)armor);
            range.addChild((CommandNode)rangeType);
            loot.addChild((CommandNode)lootTables);
            armorStand.addChild((CommandNode)summonTrims);
            display.addChild((CommandNode)placeDisplay);
            mythicRoot.addChild((CommandNode)range);
            mythicRoot.addChild((CommandNode)wiki);
            mythicRoot.addChild((CommandNode)armorStand);
            mythicRoot.addChild((CommandNode)loot);
            mythicRoot.addChild((CommandNode)placeBlocks);
            mythicRoot.addChild((CommandNode)display);
            dispatcher.getRoot().addChild((CommandNode)mythicRoot);
        });
    }

    private static int exportAllTools(CommandContext<class_2168> context) {
        Path folder = Path.of(String.valueOf(FabricLoader.getInstance().getConfigDir()) + "/mythicmetals", new String[0]);
        try {
            Files.createDirectory(folder, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException ignored) {
            MythicMetals.LOGGER.debug("Folder already exists");
        }
        catch (IOException e) {
            MythicMetals.LOGGER.error("Failed to create folder", (Throwable)e);
        }
        ReflectionUtils.iterateAccessibleStaticFields(MythicTools.class, ToolSet.class, (value, name, field) -> {
            Path file = Path.of(String.valueOf(FabricLoader.getInstance().getConfigDir()) + "/mythicmetals/" + name.toLowerCase(Locale.ROOT) + "-tools.md", new String[0]);
            try {
                Files.createFile(file, new FileAttribute[0]);
                Files.writeString(file, (CharSequence)WikiExporter.computeToolset(value), new OpenOption[0]);
                String logString = "Successfully exported equipment/%s-tools".formatted(name.toLowerCase(Locale.ROOT));
                MythicMetals.LOGGER.info(logString);
            }
            catch (IOException e) {
                MythicMetals.LOGGER.error("Failed to write wiki data");
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Failed to %s wiki data to disk!".formatted(name)), false);
            }
        });
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Exported all the tools (in the shed) to wiki format into the config folder"), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Remember to delete it to regenerate it!"), false);
        return 0;
    }

    public static int placeAllBlocksets(CommandContext<class_2168> context, Map<String, ArrayList<class_2248>> extraBlocks) {
        class_2168 source = (class_2168)context.getSource();
        class_3218 world = source.method_9225();
        AtomicInteger x = new AtomicInteger((int)source.method_9222().field_1352);
        AtomicInteger y = new AtomicInteger((int)source.method_9222().field_1351);
        int z = (int)source.method_9222().field_1350;
        ReflectionUtils.iterateAccessibleStaticFields(MythicBlocks.class, BlockSet.class, (blockSet, name, field) -> {
            y.set((int)source.method_9222().field_1351);
            if (blockSet.getOre() != null) {
                world.method_8501(class_2338.method_49637((double)x.get(), (double)y.getAndIncrement(), (double)z), blockSet.getOre().method_9564());
            }
            blockSet.getOreVariants().forEach(block -> world.method_8501(class_2338.method_49637((double)x.get(), (double)y.getAndIncrement(), (double)z), block.method_9564()));
            if (blockSet.getOreStorageBlock() != null) {
                world.method_8501(class_2338.method_49637((double)x.get(), (double)y.getAndIncrement(), (double)z), blockSet.getOreStorageBlock().method_9564());
            }
            if (blockSet.getStorageBlock() != null) {
                world.method_8501(class_2338.method_49637((double)x.get(), (double)y.getAndIncrement(), (double)z), blockSet.getStorageBlock().method_9564());
            }
            if (blockSet.getAnvil() != null) {
                world.method_8501(class_2338.method_49637((double)x.get(), (double)y.getAndIncrement(), (double)z), blockSet.getAnvil().method_9564());
            }
            if (extraBlocks.containsKey(name)) {
                ((ArrayList)extraBlocks.get(name)).forEach(extraBlock -> world.method_8501(class_2338.method_49637((double)x.get(), (double)y.getAndIncrement(), (double)z), extraBlock.method_9564()));
            }
            x.incrementAndGet();
        });
        source.method_9226(() -> class_2561.method_43470((String)"Placed all blocksets starting at %s,%s,%s".formatted(source.method_9222().field_1352, source.method_9222().field_1351, source.method_9222().field_1350)), true);
        return 0;
    }

    public static int placeMythicDisplay(CommandContext<class_2168> context) {
        int placements = -1;
        String material = StringArgumentType.getString(context, (String)"material");
        if (!MythicTools.TOOL_MAP.containsKey(material) && !MythicArmor.ARMOR_MAP.containsKey(material) && MythicBlocks.BLOCKSET_MAP.containsKey(material)) {
            MythicMetals.LOGGER.error("Failed to find material: {}", (Object)material);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Could not find any items for the material %s".formatted(material)), false);
            return -1;
        }
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        class_2338 startPos = ((class_2168)context.getSource()).method_9228().method_24515();
        MythicCommands.placeStructure((class_1937)world, startPos);
        if (material.equals("all")) {
            // empty if block
        }
        if (MythicTools.TOOL_MAP.containsKey(material)) {
            ToolSet toolSet = MythicTools.TOOL_MAP.get(material);
            class_8113.class_8122 displayEntitySword = new class_8113.class_8122(class_1299.field_42456, (class_1937)world);
            class_8113.class_8122 displayEntityPickaxe = new class_8113.class_8122(class_1299.field_42456, (class_1937)world);
            class_8113.class_8122 displayEntityAxe = new class_8113.class_8122(class_1299.field_42456, (class_1937)world);
            class_8113.class_8122 displayEntityShovel = new class_8113.class_8122(class_1299.field_42456, (class_1937)world);
            class_8113.class_8122 displayEntityHoe = new class_8113.class_8122(class_1299.field_42456, (class_1937)world);
            displayEntitySword.method_48897(toolSet.getSword().method_7854());
            displayEntityPickaxe.method_48897(toolSet.getPickaxe().method_7854());
            displayEntityAxe.method_48897(toolSet.getAxe().method_7854());
            displayEntityShovel.method_48897(toolSet.getShovel().method_7854());
            displayEntityHoe.method_48897(toolSet.getHoe().method_7854());
            displayEntitySword.method_23327((double)startPos.method_10263() + 1.25, (double)startPos.method_10264() + 3.5, (double)startPos.method_10260() + 1.2);
            displayEntityPickaxe.method_23327((double)startPos.method_10263() + 2.5, (double)startPos.method_10264() + 3.5, (double)startPos.method_10260() + 1.2);
            displayEntityAxe.method_23327((double)startPos.method_10263() + 3.75, (double)startPos.method_10264() + 3.5, (double)startPos.method_10260() + 1.2);
            displayEntityShovel.method_23327((double)(startPos.method_10263() + 5), (double)startPos.method_10264() + 3.5, (double)startPos.method_10260() + 1.2);
            displayEntityHoe.method_23327((double)startPos.method_10263() + 6.25, (double)startPos.method_10264() + 3.5, (double)startPos.method_10260() + 1.2);
            displayEntitySword.method_36456(180.0f);
            displayEntityPickaxe.method_36456(180.0f);
            displayEntityAxe.method_36456(180.0f);
            displayEntityShovel.method_36456(180.0f);
            displayEntityHoe.method_36456(180.0f);
            world.method_8649((class_1297)displayEntitySword);
            world.method_8649((class_1297)displayEntityPickaxe);
            world.method_8649((class_1297)displayEntityAxe);
            world.method_8649((class_1297)displayEntityShovel);
            world.method_8649((class_1297)displayEntityHoe);
        }
        if (MythicArmor.ARMOR_MAP.containsKey(material)) {
            // empty if block
        }
        if (MythicBlocks.BLOCKSET_MAP.containsKey(material)) {
            // empty if block
        }
        return placements;
    }

    private static void placeStructure(class_1937 world, class_2338 start) {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 5; ++j) {
                world.method_8501(class_2338.method_49637((double)(start.method_10263() + i), (double)start.method_10264(), (double)(start.method_10260() + j)), class_2246.field_10107.method_9564());
                if (j != 0) continue;
                for (int y = 0; y < 6; ++y) {
                    world.method_8501(class_2338.method_49637((double)(start.method_10263() + i), (double)(start.method_10264() + y), (double)(start.method_10260() + j)), class_2246.field_10107.method_9564());
                }
            }
        }
    }

    private static int testLootTable(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        try {
            class_6880 lootTable = class_9433.class_9436.method_58481(ctx, (String)"loot_table");
            int rolls = IntegerArgumentType.getInteger(ctx, (String)"rolls");
            class_8567 lootContextParameterSet = new class_8567.class_8568(((class_2168)ctx.getSource()).method_9225()).method_51877(class_181.field_1226, (Object)source.method_9228()).method_51874(class_181.field_24424, (Object)source.method_9222()).method_51875(class_173.field_1179);
            HashMap<class_1792, Integer> map = new HashMap<class_1792, Integer>();
            for (int i = 0; i < rolls; ++i) {
                ObjectArrayList list = ((class_52)lootTable.comp_349()).method_51878(lootContextParameterSet);
                list.forEach(itemStack -> {
                    int count = map.getOrDefault(itemStack.method_7909(), 0);
                    map.put(itemStack.method_7909(), itemStack.method_7947() + count);
                });
            }
            map.forEach((item, integer) -> source.method_9226(() -> class_2561.method_43470((String)(String.valueOf(item) + ": " + integer.toString())), false));
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
        return 0;
    }

    private static int exportArmor(CommandContext<class_2168> context) {
        String name;
        String id;
        ArmorSet armorSet = ArmorSetArgumentType.getArmorSet(context, "armorset");
        class_2168 source = (class_2168)context.getSource();
        StringBuilder output = new StringBuilder();
        String armorMaterial = class_7923.field_41178.method_10221((Object)armorSet.getHelmet()).method_12832().split("_helmet")[0];
        String armorTypeName = StringUtilsAtHome.toTitleCase(armorMaterial.replace("_", " ") + " Armor");
        output.append("\n");
        output.append("<center class=tooltip>").append("\n");
        output.append("<h3>**").append(armorTypeName).append("**</h3>").append("\n");
        output.append("![Image of %s model](../../assets/armor-models/256/%s.png)".formatted(armorTypeName, armorMaterial + "_256")).append("\n");
        for (class_1738 armor : armorSet.getArmorItems()) {
            id = class_7923.field_41178.method_10221((Object)armor).method_12832();
            name = StringUtilsAtHome.toTitleCase(id.replace('_', ' '));
            int protection = armor.method_7687();
            output.append("\n");
            output.append("<center class=tooltip>").append("\n");
            output.append("<h4>**").append(name).append("**</h4>").append("\n");
            output.append("![Image of %s](../../assets/mythicmetals/%s.png)".formatted(name, id)).append(ITEM_SCALE).append(BR);
            for (int i = 1; i < protection; i += 2) {
                output.append("![armor](../../assets/icon/full_armor_icon.png)").append(ICON_SCALE).append("\n");
            }
            if ((protection & 1) == 1) {
                output.append("![armor](../../assets/icon/half_armor_icon.png)").append(ICON_SCALE).append("\n");
            }
            output.append(BR);
            output.append("+%s Armor".formatted(protection));
            if (armor.method_26353() > 0.0f) {
                output.append(", +%s Toughness".formatted(Float.valueOf(armor.method_26353())));
            }
            output.append(BR);
            if (((class_1741)armor.method_7686().comp_349()).comp_2304() > 0.0f) {
                output.append("+%s Knockback Resistance").append(BR);
            }
            output.append("%s Durability".formatted(armor.method_7854().method_7936())).append(BR);
        }
        output.append("===HEADERS===\n");
        output.append("## Obtaining\n\n");
        output.append("### Crafting\n\n");
        output.append(armorTypeName).append(" can be crafted from ").append(armorMaterial).append(" TODO - LINK TO MATERIAL.");
        output.append("It is crafted just like any other armor").append(BR);
        for (class_1738 armor : armorSet.getArmorItems()) {
            id = class_7923.field_41178.method_10221((Object)armor).method_12832();
            name = StringUtilsAtHome.toTitleCase(id.replace('_', ' '));
            output.append("![Image of the recipe for %s](../../assets/mythicmetals/recipes/armor/%s.png)".formatted(name, id)).append(RECIPE_SCALE).append(BR);
        }
        output.append("## Usages\n\n");
        output.append("## Trivia\n\n");
        output.append("## History\n\n");
        MythicMetals.LOGGER.info((CharSequence)output);
        source.method_9226(() -> class_2561.method_43470((String)"Exported armor to wiki format in logs"), false);
        return 0;
    }

    private static int exportOreData(CommandContext<class_2168> context) {
        OreConfig oreConfig = OreConfigArgumentType.getOreConfig(context, "ore-config");
        class_2168 source = (class_2168)context.getSource();
        BlockSet blockSet = MythicBlocks.BLOCKSET_MAP.get(ORE_CONFIG.inverse().get((Object)oreConfig));
        String oreName = StringUtilsAtHome.toTitleCase(blockSet.getName() + " Ores");
        String template = WikiExporter.createOreTemplate(oreName, blockSet, oreConfig);
        source.method_9226(() -> class_2561.method_43470((String)"Exported ore stats for %s to wiki format".formatted(oreName)), false);
        MythicMetals.LOGGER.info(template);
        return 2;
    }

    private static int exportTools(CommandContext<class_2168> context) {
        ToolSet toolset = ToolSetArgumentType.getToolSet(context, "toolset");
        class_2168 source = (class_2168)context.getSource();
        MythicMetals.LOGGER.info(WikiExporter.computeToolset(toolset));
        source.method_9226(() -> class_2561.method_43470((String)"Exported tools to wiki format"), false);
        return 0;
    }

    public static boolean summonArmorStandWithTrim(class_1937 world, @Nullable class_8053 trim, ArmorSet armorSet, float x, float z) {
        if (world.field_9236) {
            return false;
        }
        if (armorSet.equals(MythicArmor.TIDESINGER)) {
            return false;
        }
        AtomicBoolean success = new AtomicBoolean(true);
        class_1531 armorStand = new class_1531(world, (double)x, (double)(world.method_31600() - 50), (double)z);
        armorSet.getArmorItems().forEach(armorItem -> {
            class_1799 armorStack = new class_1799((class_1935)armorItem);
            if (!armorStack.method_31573(class_3489.field_41890)) {
                MythicMetals.LOGGER.debug("Armor Item %s is not trimmable".formatted(armorStack.method_7964()));
            }
            if (trim != null) {
                armorStack.method_57379(class_9334.field_49607, (Object)trim);
            }
            if (success.get()) {
                armorStand.method_5673(armorItem.method_7685(), armorStack);
            }
        });
        world.method_8649((class_1297)armorStand);
        return success.get();
    }

    public static ArrayList<class_8053> getAllArmorTrims(class_1937 world) {
        if (world.field_9236) {
            return new ArrayList<class_8053>();
        }
        ArrayList<class_8053> list = new ArrayList<class_8053>();
        world.method_30349().method_30530(class_7924.field_42083).method_40270().forEach(armorMaterialEntry -> world.method_30349().method_30530(class_7924.field_42082).method_40270().forEach(armorTrimEntry -> list.add(new class_8053((class_6880)armorMaterialEntry, (class_6880)armorTrimEntry))));
        return list;
    }

    public static ArrayList<String> getAllTrimPatternStrs(class_1937 world) {
        if (world.field_9236) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        world.method_30349().method_30530(class_7924.field_42082).method_40270().forEach(armorTrimEntry -> list.add(((class_8056)armorTrimEntry.comp_349()).comp_1213().method_12832()));
        return list;
    }

    private static CompletableFuture<Suggestions> dumpType(CommandContext<class_2168> ctx, SuggestionsBuilder suggestion) {
        suggestion.suggest("console");
        return suggestion.buildFuture();
    }

    private static CompletableFuture<Suggestions> armorMaterial(CommandContext<class_2168> ctx, SuggestionsBuilder suggestion) {
        MythicArmor.ARMOR_MAP.forEach((s, armorSet) -> suggestion.suggest(s));
        suggestion.suggest("all");
        return suggestion.buildFuture();
    }

    private static CompletableFuture<Suggestions> material(CommandContext<class_2168> ctx, SuggestionsBuilder suggestion) {
        HashSet<String> placeableMaterials = new HashSet<String>();
        placeableMaterials.addAll(MythicTools.TOOL_MAP.keySet());
        placeableMaterials.addAll(MythicArmor.ARMOR_MAP.keySet());
        placeableMaterials.add("all");
        placeableMaterials.forEach(arg_0 -> ((SuggestionsBuilder)suggestion).suggest(arg_0));
        return suggestion.buildFuture();
    }

    private static CompletableFuture<Suggestions> trimTypes(CommandContext<class_2168> ctx, SuggestionsBuilder suggestion) {
        ArrayList<class_8056> list = new ArrayList<class_8056>();
        ((class_2168)ctx.getSource()).method_30497().method_30530(class_7924.field_42082).method_40270().forEach(armorTrimEntry -> list.add((class_8056)armorTrimEntry.comp_349()));
        list.forEach(trimPattern -> suggestion.suggest(trimPattern.comp_1213().method_12832()));
        suggestion.suggest("all").suggest("none");
        return suggestion.buildFuture();
    }

    private static int dumpAllOreConfigs(CommandContext<class_2168> context) {
        if (StringArgumentType.getString(context, (String)"type").equals("console")) {
            ReflectionUtils.iterateAccessibleStaticFields(MythicOreConfigs.class, OreConfig.class, (feature, name, field) -> {
                if (!feature.offset && !feature.trapezoid) {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(name.toUpperCase(Locale.ROOT) + " has the range between " + feature.bottom + " to " + feature.top + ", with a discard chance of " + feature.discardChance * 100.0f + "%")), false);
                }
                if (feature.offset) {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(name.toUpperCase(Locale.ROOT) + " has the range between " + feature.bottom + "(offset) to " + feature.top + ", with a discard chance of " + feature.discardChance * 100.0f + "%")), false);
                }
                if (feature.trapezoid) {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(name.toUpperCase(Locale.ROOT) + " has a triangle range between " + feature.bottom + " to " + feature.top + ", where the sweet spot is at Y = " + (feature.bottom + feature.top) / 2 + " with a discard chance of " + feature.discardChance * 100.0f + "%")), false);
                }
            });
            return 1;
        }
        return -1;
    }

    private static int armorStandCommand(CommandContext<class_2168> context, @NotNull String material, @Nullable String rawTrim) {
        String trimQuery;
        ArrayList<Object> armorTrims = new ArrayList();
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        class_243 pos = ((class_2168)context.getSource()).method_9222();
        float x = (float)((int)pos.field_1352) + 0.5f;
        float z = (float)((int)pos.field_1350) + 0.5f;
        String string = trimQuery = rawTrim == null ? "none" : rawTrim;
        if (trimQuery.equals("none")) {
            if (material.equals("all")) {
                int count = 0;
                TreeSet<String> armorSetStrings = new TreeSet<String>(MythicArmor.ARMOR_MAP.keySet());
                for (String armorSetName : armorSetStrings) {
                    if (!MythicCommands.summonArmorStandWithTrim((class_1937)world, null, MythicArmor.ARMOR_MAP.get(armorSetName), x, z)) continue;
                    x += 1.0f;
                    ++count;
                }
                int finalCount = count;
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Summoned and dropping %d armorstands".formatted(finalCount)), true);
                return finalCount;
            }
            if (MythicCommands.summonArmorStandWithTrim((class_1937)world, null, MythicArmor.ARMOR_MAP.get(material), x, z)) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Summoned and dropping one armorstand"), true);
                return 1;
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Unable to summon the armor stand. It might be untrimmable"), false);
            return -1;
        }
        if (material.equals("all")) {
            if (MythicArmor.ARMOR_MAP.isEmpty()) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Unable to summon. Somehow the armor map is empty..."), false);
                return -1;
            }
            if (trimQuery.equals("all")) {
                armorTrims.addAll(MythicCommands.getAllArmorTrims((class_1937)world).stream().toList());
            } else if (MythicCommands.getAllTrimPatternStrs((class_1937)world).contains(trimQuery)) {
                armorTrims.addAll(MythicCommands.getAllArmorTrims((class_1937)world).stream().filter(trim -> ((class_8056)trim.method_48424().comp_349()).comp_1213().method_12832().equals(trimQuery)).toList());
            }
            MutableInt mutX = new MutableInt((Number)pos.field_1352);
            MutableInt mutZ = new MutableInt((Number)pos.field_1350);
            MutableInt count = new MutableInt(0);
            TreeSet<String> armorSetStrings = new TreeSet<String>(MythicArmor.ARMOR_MAP.keySet());
            for (String armorSetName : armorSetStrings) {
                armorTrims.forEach((Consumer<Object>)((Consumer<class_8053>)armorTrim -> {
                    if (MythicCommands.summonArmorStandWithTrim((class_1937)world, armorTrim, MythicArmor.ARMOR_MAP.get(armorSetName), mutX.getValue().intValue(), mutZ.getValue().intValue())) {
                        mutX.increment();
                        count.increment();
                    }
                }));
                mutZ.increment();
                mutX.setValue((Number)pos.field_1352);
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Summoned and dropping %d armorstands with trims".formatted(count.getValue())), true);
            return count.getValue();
        }
        if (MythicArmor.ARMOR_MAP.get(material) != null) {
            if (trimQuery.equals("all")) {
                armorTrims = MythicCommands.getAllArmorTrims((class_1937)world);
            } else {
                List<class_8053> trims = MythicCommands.getAllArmorTrims((class_1937)world).stream().filter(trim -> ((class_8056)trim.method_48424().comp_349()).comp_1213().method_12832().equals(trimQuery)).toList();
                armorTrims.addAll(trims);
            }
            int splitPoint = armorTrims.size() / world.method_30349().method_30530(class_7924.field_42083).method_10204();
            int xOffset = 0;
            int zOffset = 0;
            int count = 0;
            for (int i = 0; i < armorTrims.size(); ++i) {
                if (i % splitPoint == 0) {
                    xOffset += 2;
                    zOffset = 0;
                }
                ArmorSet armorSet = MythicArmor.ARMOR_MAP.get(material);
                if (MythicCommands.summonArmorStandWithTrim((class_1937)world, (class_8053)armorTrims.get(i), armorSet, (int)pos.field_1352 + xOffset, (int)pos.field_1350 + zOffset)) {
                    ++count;
                    zOffset += 2;
                    continue;
                }
                xOffset -= 2;
            }
            String feedback = "Summoned and dropping %d armorstands".formatted(count);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)feedback), true);
            return count;
        }
        return -1;
    }
}

