/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.common_classes;

import com.mojang.datafixers.util.Pair;
import java.util.Map;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class TagUtility {
    public static final class_2960 GLASS_TAG = TagUtility.commonTag("glass");
    public static final class_2960 GLASS_PANE_TAG = TagUtility.commonTag("glass_panes");

    public static class_2960 getATagOrCreateANew(String suffixTag, String suffixAlt, BlockType blockType, ServerDynamicResourcesHandler handler, class_3300 manager) {
        String resLocMOD = blockType.getNamespace() + ":" + blockType.getTypeName();
        class_2960 RLocLogs = class_2960.method_60654((String)(resLocMOD + "_" + suffixTag));
        class_2960 RLocStems = class_2960.method_60654((String)(resLocMOD + "_" + suffixAlt));
        class_2960 RLocFolders = class_2960.method_60654((String)(blockType.getNamespace() + ":" + suffixTag + "/" + blockType.getTypeName()));
        class_2960 RLocEC = EveryCompat.res(blockType.getAppendableId() + "_" + suffixTag);
        if (manager.method_14486(ResType.TAGS.getPath(RLocLogs.method_45138("blocks/"))).isPresent()) {
            return RLocLogs;
        }
        if (manager.method_14486(ResType.TAGS.getPath(RLocStems.method_45138("blocks/"))).isPresent()) {
            return RLocStems;
        }
        if (manager.method_14486(ResType.TAGS.getPath(RLocEC.method_45138("blocks/"))).isPresent()) {
            return RLocEC;
        }
        if (manager.method_14486(ResType.TAGS.getPath(RLocFolders.method_45138("blocks/"))).isPresent()) {
            return RLocFolders;
        }
        TagUtility.createAndAddDefaultTags(RLocEC, handler, blockType, new class_2248[0]);
        return RLocEC;
    }

    public static boolean createAndAddDefaultTags(class_2960 resLoc, ServerDynamicResourcesHandler handler, BlockType blockType, class_2248 ... blocks) {
        if (blockType instanceof WoodType) {
            WoodType woodType = (WoodType)blockType;
            return TagUtility.createAndAddCustomTags(resLoc, handler, woodType.log, woodType.getBlockOfThis("stripped_log"), woodType.getBlockOfThis("wood"), woodType.getBlockOfThis("stripped_wood"));
        }
        return TagUtility.createAndAddCustomTags(resLoc, handler, blocks);
    }

    public static boolean createAndAddCustomTags(class_2960 resLoc, ServerDynamicResourcesHandler handler, class_2248 ... blocks) {
        boolean isTagCreated = false;
        SimpleTagBuilder tagBuilder = SimpleTagBuilder.of((class_2960)resLoc);
        for (class_2248 block : blocks) {
            if (block == null) continue;
            tagBuilder.addEntry((Object)block);
            isTagCreated = true;
        }
        if (isTagCreated) {
            ((DynamicDataPack)handler.dynamicPack).addTag(tagBuilder, class_7924.field_41254);
            ((DynamicDataPack)handler.dynamicPack).addTag(tagBuilder, class_7924.field_41197);
        }
        return isTagCreated;
    }

    public static <T extends BlockType, B extends class_2248> void addTagToAllBlocks(Map<T, B> blocks, String nameStone, String modId, String tag, boolean includeBlock, boolean includeItem, DynamicDataPack pack) {
        if (PlatHelper.isModLoaded((String)modId)) {
            boolean isTagCreated = false;
            SimpleTagBuilder tagBuilder = SimpleTagBuilder.of((class_2960)class_2960.method_60655((String)modId, (String)tag));
            for (Map.Entry<T, B> entry : blocks.entrySet()) {
                BlockType stoneType = (BlockType)entry.getKey();
                class_2248 block = (class_2248)entry.getValue();
                if (!stoneType.getTypeName().equals(nameStone)) continue;
                tagBuilder.addEntry((Object)block);
                isTagCreated = true;
            }
            if (isTagCreated) {
                if (includeBlock) {
                    pack.addTag(tagBuilder, class_7924.field_41254);
                }
                if (includeItem) {
                    pack.addTag(tagBuilder, class_7924.field_41197);
                }
            }
        }
    }

    public static <T extends BlockType, B extends class_2248> void addTagToAllBlocks(Map<T, B> blocks, String nameStone, String modId, class_6862<class_2248> tag, boolean includeBlock, boolean includeItem, DynamicDataPack pack) {
        if (PlatHelper.isModLoaded((String)modId)) {
            boolean isTagCreated = false;
            SimpleTagBuilder tagBuilder = SimpleTagBuilder.of(tag);
            for (Map.Entry<T, B> entry : blocks.entrySet()) {
                BlockType stoneType = (BlockType)entry.getKey();
                class_2248 block = (class_2248)entry.getValue();
                if (!stoneType.getTypeName().equals(nameStone)) continue;
                tagBuilder.addEntry((Object)block);
                isTagCreated = true;
            }
            if (isTagCreated) {
                if (includeBlock) {
                    pack.addTag(tagBuilder, class_7924.field_41254);
                }
                if (includeItem) {
                    pack.addTag(tagBuilder, class_7924.field_41197);
                }
            }
        }
    }

    public static <T extends BlockType, B extends class_2248> void addTagToAllBlocks(Map<T, B> blocks, String regexBlockId, String nameStone, String modId, class_6862<class_2248> tag, boolean includeBlock, boolean includeItem, DynamicDataPack pack) {
        if (PlatHelper.isModLoaded((String)modId)) {
            boolean isTagCreated = false;
            SimpleTagBuilder tagBuilder = SimpleTagBuilder.of(tag);
            for (Map.Entry<T, B> entry : blocks.entrySet()) {
                BlockType stoneType = (BlockType)entry.getKey();
                class_2248 block = (class_2248)entry.getValue();
                String blockPath = Utils.getID((class_2248)block).method_12832();
                String blockId = blockPath.substring(blockPath.lastIndexOf("/") + 1);
                if (!stoneType.getTypeName().equals(nameStone) || !blockId.matches(regexBlockId)) continue;
                tagBuilder.addEntry((Object)block);
                isTagCreated = true;
            }
            if (isTagCreated) {
                if (includeBlock) {
                    pack.addTag(tagBuilder, class_7924.field_41254);
                }
                if (includeItem) {
                    pack.addTag(tagBuilder, class_7924.field_41197);
                }
            }
        }
    }

    public static Pair<class_2960, Boolean> getATagId(String idTag, String idAlt, class_3300 manager) {
        class_2960 RLocId = class_2960.method_60654((String)idTag);
        class_2960 RLocIdAlt = class_2960.method_60654((String)idAlt);
        if (TagUtility.doTagExistFor(RLocId, manager)) {
            return Pair.of((Object)RLocId, (Object)true);
        }
        if (TagUtility.doTagExistFor(RLocIdAlt, manager)) {
            return Pair.of((Object)RLocIdAlt, (Object)true);
        }
        return Pair.of(null, (Object)false);
    }

    private static boolean doTagExistFor(class_2960 resLoc, class_3300 manager) {
        boolean blockTag = manager.method_14486(ResType.TAGS.getPath(resLoc.method_45138("blocks/"))).isPresent();
        boolean itemTag = manager.method_14486(ResType.TAGS.getPath(resLoc.method_45138("items/"))).isPresent();
        return blockTag || itemTag;
    }

    private static class_2960 commonTag(String suffix) {
        return class_2960.method_60655((String)"c", (String)suffix);
    }
}

