/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.kosmx.playerAnim.core.util.MathHelper;
import dev.kosmx.playerAnim.core.util.Pair;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.config.ClientConfig;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3675;
import net.minecraft.class_4280;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class EmoteListWidget
extends class_4280<EmoteEntry> {
    protected List<EmoteEntry> emotes = new ArrayList<EmoteEntry>();
    private boolean compactMode;

    public EmoteListWidget(class_310 minecraftClient, int i, int j, int k, int l) {
        super(minecraftClient, i, j, k, l);
        this.field_22744 = false;
    }

    public int method_25322() {
        if (this.compactMode) {
            return this.field_22758;
        }
        return this.field_22758 / 2;
    }

    protected int method_25329() {
        if (!this.compactMode) {
            return super.method_25329();
        }
        return this.method_46426() + this.method_25322() - 6;
    }

    protected void method_44398(@NotNull class_332 guiGraphics, int i, int j, int k, int l, int m) {
        if (this.compactMode && this.method_57717()) {
            int o = this.method_25342() - 2;
            int p = this.method_55442() - 6 - 1;
            int q = i - 2;
            int r = i + k + 2;
            guiGraphics.method_25294(o, q, p, r, l);
            guiGraphics.method_25294(o + 1, q + 1, p - 1, r - 1, m);
        } else {
            super.method_44398(guiGraphics, i, j, k, l, m);
        }
    }

    protected void method_44397(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int index, int left, int top, int width, int height) {
        try {
            super.method_44397(guiGraphics, mouseX, mouseY, partialTick, index, left, top, width, height);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setEmotes(Iterable<EmoteHolder> list, boolean showInvalid) {
        this.emotes.clear();
        for (EmoteHolder emoteHolder : list) {
            this.emotes.add(new EmoteEntry(emoteHolder));
        }
        if (showInvalid) {
            for (EmoteHolder emoteHolder : this.getEmptyEmotes()) {
                this.emotes.add(new EmoteEntry(emoteHolder));
            }
        }
        this.emotes.sort(Comparator.comparing(o -> o.emote.name.getString().toLowerCase()));
        this.filter(() -> "");
    }

    public void filter(Supplier<String> string) {
        this.method_25339();
        for (EmoteEntry emote : this.emotes) {
            if (!emote.emote.name.getString().toLowerCase().contains(string.get()) && !emote.emote.description.getString().toLowerCase().contains(string.get()) && !emote.emote.author.getString().toLowerCase().equals(string.get())) continue;
            this.method_25321((class_350.class_351)emote);
        }
        this.method_25307(0.0);
    }

    public Iterable<EmoteHolder> getEmptyEmotes() {
        LinkedList<EmoteHolder> empties = new LinkedList<EmoteHolder>();
        for (Pair<UUID, class_3675.class_306> pair : ((ClientConfig)EmoteInstance.config).emoteKeyMap) {
            if (EmoteHolder.list.containsKey(pair.getLeft())) continue;
            empties.add(new EmoteHolder.Empty((UUID)pair.getLeft()));
        }
        return empties;
    }

    public void setCompactMode(boolean compactMode) {
        this.compactMode = compactMode;
    }

    public class EmoteEntry
    extends class_4280.class_4281<EmoteEntry> {
        public final EmoteHolder emote;

        public EmoteEntry(EmoteHolder emote) {
            this.emote = emote;
        }

        public void method_25343(@NotNull class_332 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            class_2960 texture;
            int maxX = x + entryWidth - 3 - (EmoteListWidget.this.compactMode && EmoteListWidget.this.method_57717() ? 7 : 0);
            matrices.method_44379(x - 1, y - 1, maxX, y + entryHeight + 1);
            if (hovered) {
                matrices.method_25294(x - 1, y - 1, maxX, y + entryHeight + 1, MathHelper.colorHelper((int)66, (int)66, (int)66, (int)128));
            }
            class_327 class_3272 = ((EmoteListWidget)EmoteListWidget.this).field_22740.field_1772;
            class_2561 class_25612 = this.emote.name;
            Objects.requireNonNull(((EmoteListWidget)EmoteListWidget.this).field_22740.field_1772);
            EmoteListWidget.method_49605((class_332)matrices, (class_327)class_3272, (class_2561)class_25612, (int)(x + 34), (int)(x + 34), (int)(y + 1), (int)maxX, (int)(y + 1 + 9), (int)0xFFFFFF);
            matrices.method_27535(((EmoteListWidget)EmoteListWidget.this).field_22740.field_1772, this.emote.description, x + 34, y + 12, 0x808080);
            if (!this.emote.author.getString().isEmpty()) {
                class_5250 text = class_2561.method_43471((String)"emotecraft.emote.author").method_27692(class_124.field_1065).method_10852(this.emote.author);
                matrices.method_27535(((EmoteListWidget)EmoteListWidget.this).field_22740.field_1772, (class_2561)text, x + 34, y + 23, 0x808080);
            }
            if ((texture = this.emote.getIconIdentifier()) != null) {
                RenderSystem.enableBlend();
                matrices.method_25293(texture, x, y, 32, 32, 0.0f, 0.0f, 256, 256, 256, 256);
                RenderSystem.disableBlend();
            }
            matrices.method_44380();
        }

        public EmoteHolder getEmote() {
            return this.emote;
        }

        @NotNull
        public class_2561 method_37006() {
            return this.emote.name;
        }
    }
}

