/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.network;

import io.github.kosmx.emotes.api.proxy.INetworkInstance;
import io.github.kosmx.emotes.arch.mixin.EntityTrackerAccessor;
import io.github.kosmx.emotes.arch.mixin.ServerChunkCacheAccessor;
import io.github.kosmx.emotes.arch.network.AbstractServerNetwork;
import io.github.kosmx.emotes.arch.network.EmotesMixinNetwork;
import io.github.kosmx.emotes.arch.network.NetworkPlatformTools;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.common.network.GeyserEmotePacket;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.server.network.AbstractServerEmotePlay;
import io.github.kosmx.emotes.server.network.IServerNetworkInstance;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2802;
import net.minecraft.class_3215;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_5629;
import org.jetbrains.annotations.Nullable;

public final class CommonServerNetworkHandler
extends AbstractServerEmotePlay<class_1657> {
    public static CommonServerNetworkHandler instance = new CommonServerNetworkHandler();

    private CommonServerNetworkHandler() {
    }

    public static void init() {
    }

    public void receiveMessage(byte[] bytes, class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            try {
                this.receiveMessage(bytes, player, (INetworkInstance)CommonServerNetworkHandler.getHandler(serverPlayer.field_13987));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static IServerNetworkInstance getHandler(class_3244 handler) {
        return ((EmotesMixinNetwork)handler).emotecraft$getServerNetworkInstance();
    }

    public void receiveStreamMessage(byte[] bytes, class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.receiveStreamMessage(serverPlayer, CommonServerNetworkHandler.getHandler(serverPlayer.field_13987), ByteBuffer.wrap(bytes));
        }
    }

    public void receiveStreamMessage(class_3222 player, IServerNetworkInstance handler, ByteBuffer buf) {
        try {
            if (((EmotesMixinNetwork)((Object)handler)).emotecraft$getServerNetworkInstance().allowEmoteStreamC2S()) {
                ByteBuffer packet = ((AbstractServerNetwork)((Object)handler)).receiveStreamChunk(buf);
                if (packet != null) {
                    this.receiveMessage(packet.array(), player, (INetworkInstance)handler);
                }
            } else {
                handler.disconnect("Emote stream is disabled on this server");
            }
        }
        catch (IOException e) {
            EmoteInstance.instance.getLogger().log(Level.WARNING, e.getMessage(), e);
        }
    }

    @Override
    protected UUID getUUIDFromPlayer(class_1657 player) {
        return player.method_5667();
    }

    @Override
    protected class_1657 getPlayerFromUUID(UUID player) {
        return NetworkPlatformTools.getServer().method_3760().method_14602(player);
    }

    @Override
    protected long getRuntimePlayerID(class_1657 player) {
        return player.method_5628();
    }

    @Override
    protected IServerNetworkInstance getPlayerNetworkInstance(class_1657 sourcePlayer) {
        if (!(sourcePlayer instanceof class_3222)) {
            return null;
        }
        class_3222 player = (class_3222)sourcePlayer;
        return ((EmotesMixinNetwork)player.field_13987).emotecraft$getServerNetworkInstance();
    }

    @Override
    protected void sendForEveryoneElse(GeyserEmotePacket packet, class_1657 player) {
        this.sendForEveryoneElse((NetData)null, packet, player);
    }

    @Override
    protected void sendForEveryoneElse(@Nullable NetData data, @Nullable GeyserEmotePacket geyserPacket, class_1657 player) {
        this.getTrackedPlayers((class_1297)player).forEach(target -> {
            if (target != player) {
                try {
                    if (data != null && NetworkPlatformTools.canSendPlay(target, NetworkPlatformTools.EMOTE_CHANNEL_ID.comp_2242())) {
                        IServerNetworkInstance playerNetwork = this.getPlayerNetworkInstance((class_1657)target);
                        playerNetwork.sendMessage(new EmotePacket.Builder(data), null);
                    } else if (geyserPacket != null && NetworkPlatformTools.canSendPlay(target, NetworkPlatformTools.GEYSER_CHANNEL_ID.comp_2242())) {
                        IServerNetworkInstance playerNetwork = this.getPlayerNetworkInstance((class_1657)target);
                        playerNetwork.sendGeyserPacket(ByteBuffer.wrap(geyserPacket.write()));
                    }
                }
                catch (IOException e) {
                    EmoteInstance.instance.getLogger().log(Level.WARNING, e.getMessage(), e);
                }
            }
        });
    }

    @Override
    protected void sendForPlayerInRange(NetData data, class_1657 player, UUID target) {
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 sourcePlayer = (class_3222)player;
        try {
            class_3222 targetPlayer = sourcePlayer.field_13995.method_3760().method_14602(target);
            if (targetPlayer != null && targetPlayer.method_52372().method_52361(sourcePlayer.method_31476())) {
                this.getPlayerNetworkInstance((class_1657)targetPlayer).sendMessage(new EmotePacket.Builder(data), null);
            }
        }
        catch (IOException e) {
            EmoteInstance.instance.getLogger().log(Level.WARNING, e.getMessage(), e);
        }
    }

    @Override
    protected void sendForPlayer(NetData data, class_1657 ignore, UUID target) {
        try {
            class_1657 player = this.getPlayerFromUUID(target);
            IServerNetworkInstance playerNetwork = this.getPlayerNetworkInstance(player);
            EmotePacket.Builder packetBuilder = new EmotePacket.Builder(data);
            playerNetwork.sendMessage(packetBuilder, null);
        }
        catch (IOException e) {
            EmoteInstance.instance.getLogger().log(Level.WARNING, e.getMessage(), e);
        }
    }

    private Collection<class_3222> getTrackedPlayers(class_1297 entity) {
        class_2802 level = entity.method_37908().method_8398();
        if (level instanceof class_3215) {
            class_3215 chunkCache = (class_3215)level;
            ServerChunkCacheAccessor storage = (ServerChunkCacheAccessor)chunkCache.field_17254;
            EntityTrackerAccessor tracker = (EntityTrackerAccessor)storage.getTrackedEntity().get(entity.method_5628());
            if (tracker != null) {
                return tracker.getPlayersTracking().stream().map(class_5629::method_32311).collect(Collectors.toUnmodifiableSet());
            }
            return Collections.emptyList();
        }
        throw new IllegalArgumentException("server function called on logical client");
    }
}

