/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.api;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories_compat.api.tags.CollectionAddition;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1299;
import org.slf4j.Logger;

public interface EntityBindingModifier {
    public static final Logger LOGGER = LogUtils.getLogger();

    public static EntityBindingModifier from(final Map<String, SlotType> slotTypes, Map<class_1299<?>, Map<String, SlotType>> bindingEntries) {
        return type -> {
            final Map entityBindings = bindingEntries.computeIfAbsent(type, entityType -> new HashMap());
            return new CollectionAddition<String>(){

                @Override
                public void add(String accessoryType) {
                    if (!slotTypes.containsKey(accessoryType)) {
                        LOGGER.warn("Unable to locate the given slot for a given entity binding, it will be skipped: [Name: {}]", (Object)accessoryType);
                        return;
                    }
                    if (entityBindings.containsKey(accessoryType)) {
                        return;
                    }
                    entityBindings.put(accessoryType, (SlotType)slotTypes.get(accessoryType));
                }

                @Override
                public void add(Collection<String> accessoryTypes) {
                    accessoryTypes.forEach(this::add);
                }
            };
        };
    }

    public CollectionAddition<String> addTo(class_1299<?> var1);
}

