/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.curios;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.DropRule;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.events.AccessoryChangeCallback;
import io.wispforest.accessories.api.events.AdjustAttributeModifierCallback;
import io.wispforest.accessories.api.events.CanEquipCallback;
import io.wispforest.accessories.api.events.CanUnequipCallback;
import io.wispforest.accessories.api.events.ContainersChangeCallback;
import io.wispforest.accessories.api.events.OnDeathCallback;
import io.wispforest.accessories.api.events.OnDropCallback;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories_compat.curios.wrapper.CuriosConversionUtils;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.TriState;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.event.CurioAttributeModifierEvent;
import top.theillusivec4.curios.api.event.CurioCanEquipEvent;
import top.theillusivec4.curios.api.event.CurioCanUnequipEvent;
import top.theillusivec4.curios.api.event.CurioChangeEvent;
import top.theillusivec4.curios.api.event.CurioDropsEvent;
import top.theillusivec4.curios.api.event.DropRulesEvent;
import top.theillusivec4.curios.api.event.SlotModifiersUpdatedEvent;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.common.capability.CurioInventoryCapability;

public class AccessoriesEventHooks {
    public static void initAccessoriesEventHooks() {
        CanUnequipCallback.EVENT.register((stack, reference) -> CuriosConversionUtils.convertToFabric(((CurioCanUnequipEvent)NeoForge.EVENT_BUS.post((Event)new CurioCanUnequipEvent(stack, CuriosConversionUtils.objectsConvertToC(reference)))).getUnequipResult()));
        CanEquipCallback.EVENT.register((stack, reference) -> CuriosConversionUtils.convertToFabric(((CurioCanEquipEvent)NeoForge.EVENT_BUS.post((Event)new CurioCanEquipEvent(stack, CuriosConversionUtils.objectsConvertToC(reference), TriState.DEFAULT))).getEquipResult()));
        ContainersChangeCallback.EVENT.register((livingEntity, capability, changedContainers) -> {
            if (changedContainers.isEmpty()) {
                return;
            }
            LinkedHashSet convertedSlots = changedContainers.keySet().stream().map(container -> CuriosConversionUtils.slotConvertToC(container.getSlotName())).collect(Collectors.toCollection(LinkedHashSet::new));
            NeoForge.EVENT_BUS.post((Event)new SlotModifiersUpdatedEvent(livingEntity, (Set)convertedSlots));
        });
        AccessoryChangeCallback.EVENT.register((prevStack, currentStack, reference, stateChange) -> NeoForge.EVENT_BUS.post((Event)new CurioChangeEvent(reference.entity(), reference.slotName(), reference.slot(), prevStack, currentStack)));
        AdjustAttributeModifierCallback.EVENT.register((stack, reference, builder) -> {
            class_2960 slotLocation = class_2960.method_60655((String)"curios", (String)AccessoryAttributeBuilder.createSlotPath((SlotReference)reference));
            ((CurioAttributeModifierEvent)NeoForge.EVENT_BUS.post((Event)new CurioAttributeModifierEvent(stack, CuriosConversionUtils.objectsConvertToC(reference), slotLocation, (Multimap)HashMultimap.create()))).getModifiers().forEach((arg_0, arg_1) -> ((AccessoryAttributeBuilder)builder).addExclusive(arg_0, arg_1));
        });
        DeathWrapperEventsImpl.init();
    }

    private static class DeathWrapperEventsImpl
    implements OnDeathCallback,
    OnDropCallback {
        public static final DeathWrapperEventsImpl INSTANCE = new DeathWrapperEventsImpl();
        @Nullable
        private DropRulesEvent latestDropRules = null;

        private DeathWrapperEventsImpl() {
        }

        public static void init() {
            OnDeathCallback.EVENT.register((Object)INSTANCE);
            OnDropCallback.EVENT.register((Object)INSTANCE);
        }

        public net.fabricmc.fabric.api.util.TriState shouldDrop(net.fabricmc.fabric.api.util.TriState currentState, class_1309 entity, AccessoriesCapability capability, class_1282 damageSource, List<class_1799> droppedStacks) {
            CurioInventoryCapability handler = new CurioInventoryCapability(entity);
            List itemEntities = droppedStacks.stream().map(stack -> {
                class_1542 itemEntity = (class_1542)class_1299.field_6052.method_5883(entity.method_37908());
                if (itemEntity == null) {
                    return null;
                }
                itemEntity.method_6979(stack);
                return itemEntity;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            droppedStacks.clear();
            CurioDropsEvent dropEventTest = (CurioDropsEvent)NeoForge.EVENT_BUS.post((Event)new CurioDropsEvent(entity, (ICuriosItemHandler)handler, damageSource, itemEntities, 0, false));
            droppedStacks.addAll(itemEntities.stream().map(class_1542::method_6983).toList());
            if (dropEventTest.isCanceled()) {
                return net.fabricmc.fabric.api.util.TriState.FALSE;
            }
            this.latestDropRules = (DropRulesEvent)NeoForge.EVENT_BUS.post((Event)new DropRulesEvent(entity, (ICuriosItemHandler)handler, damageSource, 0, false));
            return net.fabricmc.fabric.api.util.TriState.DEFAULT;
        }

        @Nullable
        public DropRule onDrop(DropRule dropRule, class_1799 stack, SlotReference reference, class_1282 damageSource) {
            if (this.latestDropRules != null) {
                for (class_3545 override : this.latestDropRules.getOverrides()) {
                    if (!((Predicate)override.method_15442()).test(stack)) continue;
                    return CuriosConversionUtils.dropRuleConvertToA((ICurio.DropRule)override.method_15441());
                }
            }
            return null;
        }
    }
}

