/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.curios;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories_compat.AccessoriesCompatInit;
import io.wispforest.accessories_compat.api.EntityBindingModifier;
import io.wispforest.accessories_compat.api.ModCompatibilityModule;
import io.wispforest.accessories_compat.api.ReloadListenerRegisterCallback;
import io.wispforest.accessories_compat.api.tags.CollectionAddition;
import io.wispforest.accessories_compat.api.tags.SlotTypesModifier;
import io.wispforest.accessories_compat.curios.mixin.accessor.ItemizedCurioCapabilityAccessor;
import io.wispforest.accessories_compat.curios.mixin.accessor.SlotTypeBuilderAccessor;
import io.wispforest.accessories_compat.curios.wrapper.AccessoryFromCurio;
import io.wispforest.accessories_compat.curios.wrapper.CuriosConversionUtils;
import io.wispforest.accessories_compat.utils.LoaderPlatformUtils;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.SequencedSet;
import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3302;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CurioAttributeModifiers;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.common.CuriosRegistry;
import top.theillusivec4.curios.common.data.CuriosEntityManager;
import top.theillusivec4.curios.common.data.CuriosSlotManager;

public class CuriosCompat
extends ModCompatibilityModule {
    public static final CuriosCompat INSTANCE = CuriosCompat.create();
    private final class_2960 EMPTY_TEXTURE = class_2960.method_60655((String)"curios", (String)"slot/empty_curio_slot");

    protected CuriosCompat() {
        super("curios");
    }

    @Nullable
    private static CuriosCompat create() {
        if (!LoaderPlatformUtils.INSTANCE.isModLoaded("curios")) {
            AccessoriesCompatInit.LOGGER.error("Attempted to load the CuriosCompat while Curios the mod is not loaded!");
            return null;
        }
        return new CuriosCompat();
    }

    @Override
    public void registerDataLoaders(ReloadListenerRegisterCallback callback) {
        callback.registerSlotLoader((class_3302)CuriosSlotManager.SERVER, class_2960.method_60655((String)"accessories_compat_layer", (String)"curios_slot_manager"));
        callback.registerEntitySlotLoader((class_3302)CuriosEntityManager.SERVER, class_2960.method_60655((String)"accessories_compat_layer", (String)"curios_entity_manager"));
    }

    @Override
    public void addEntityBindings(EntityBindingModifier modifier) {
        for (Map.Entry<class_1299<?>, ImmutableMap.Builder<String, ISlotType>> entry : CuriosConversionUtils.CURRENT_ENTITY_BINDINGS.entrySet()) {
            CollectionAddition<String> addition = modifier.addTo(entry.getKey());
            for (String curiosId : entry.getValue().buildKeepingLast().keySet()) {
                String accessoriesId = CuriosConversionUtils.slotConvertToA(curiosId);
                addition.add(accessoriesId);
            }
        }
    }

    @Override
    public void addSlotTypes(SlotTypesModifier modifier) {
        CuriosConversionUtils.CURRENT_SLOT_BUILDERS.forEach((curiosId, curiosBuilder) -> {
            SlotTypeBuilderAccessor accessor = (SlotTypeBuilderAccessor)curiosBuilder;
            String accessoriesId = CuriosConversionUtils.slotConvertToA(curiosId);
            SlotTypeLoader.SlotBuilder builder = modifier.getBuilder(accessoriesId);
            Integer slotsCurrentSize = null;
            if (builder != null) {
                slotsCurrentSize = builder.baseAmount;
            } else {
                builder = modifier.addBuilder(accessoriesId);
                class_2960 icon = accessor.getIcon();
                if (icon != null && !icon.equals((Object)this.EMPTY_TEXTURE)) {
                    builder.icon(icon);
                }
                if (accessor.getOrder() != null) {
                    builder.order(accessor.getOrder());
                }
                if (accessor.getDropRule() != null) {
                    builder.dropRule(CuriosConversionUtils.dropRuleConvertToA(accessor.getDropRule()));
                }
                builder.alternativeTranslation("curios.identifier." + curiosId);
            }
            if (accessor.getSize() != null && slotsCurrentSize != null && accessor.getSize() > slotsCurrentSize) {
                builder.amount(accessor.getSize().intValue());
            }
            if (accessor.getSizeMod() != 0) {
                builder.addAmount(accessor.getSizeMod());
            }
            if (accessor.getValidators() != null) {
                for (class_2960 validatorPredicate : accessor.getValidators()) {
                    builder.validator(CuriosConversionUtils.convertToA(validatorPredicate));
                }
            }
        });
        CuriosConversionUtils.CURRENT_SLOT_BUILDERS.clear();
    }

    @Override
    public SequencedSet<class_2960> toAccessoriesTag(class_2960 moduleSlotTag) {
        return new LinkedHashSet<class_2960>(Set.of(class_2960.method_60655((String)"accessories", (String)CuriosConversionUtils.slotConvertToA(moduleSlotTag.method_12832()))));
    }

    @Override
    public SequencedSet<class_2960> fromAccessoriesTag(class_2960 accessoriesSlotTag) {
        return new LinkedHashSet<class_2960>(Set.of(class_2960.method_60655((String)"curios", (String)CuriosConversionUtils.slotConvertToC(accessoriesSlotTag.method_12832()))));
    }

    @Override
    public void getAttributes(class_1799 stack, @Nullable class_1309 entity, String accessoriesSlotName, int slot, AccessoryAttributeBuilder builder) {
        LinkedHashMultimap multimap = LinkedHashMultimap.create();
        if (!stack.method_57826((class_9331)CuriosRegistry.CURIO_ATTRIBUTE_MODIFIERS.get())) {
            return;
        }
        for (CurioAttributeModifiers.Entry entry : ((CurioAttributeModifiers)stack.method_57825((class_9331)CuriosRegistry.CURIO_ATTRIBUTE_MODIFIERS.get(), (Object)CurioAttributeModifiers.EMPTY)).modifiers()) {
            class_2960 rl;
            String targetSlot = entry.slot();
            if (!targetSlot.equals(CuriosConversionUtils.slotConvertToC(accessoriesSlotName)) && !targetSlot.isBlank() || (rl = entry.attribute()) == null) continue;
            class_1322 attributeModifier = entry.modifier();
            class_1322.class_1323 operation = attributeModifier.comp_2450();
            double amount = attributeModifier.comp_2449();
            class_2960 id = attributeModifier.comp_2447();
            if (rl.method_12836().equals("curios")) {
                boolean clientSide;
                String attributeSlotName = rl.method_12832();
                if (!CuriosApi.getSlot((String)attributeSlotName, (boolean)(clientSide = entity == null || entity.method_37908().method_8608())).isPresent()) continue;
                CuriosApi.addSlotModifier((Multimap)multimap, (String)attributeSlotName, (class_2960)id, (double)amount, (class_1322.class_1323)operation);
                continue;
            }
            class_7923.field_41190.method_55841(rl).ifPresent(arg_0 -> CuriosCompat.lambda$getAttributes$1((Multimap)multimap, id, amount, operation, arg_0));
        }
        multimap.forEach((arg_0, arg_1) -> ((AccessoryAttributeBuilder)builder).addExclusive(arg_0, arg_1));
    }

    @Override
    public boolean skipOnEquipCheck(class_1799 stack, Accessory accessory) {
        return accessory instanceof AccessoryFromCurio;
    }

    @Override
    public boolean skipDefaultRenderer(class_1792 item) {
        ItemizedCurioCapabilityAccessor accessor;
        ICurio iCurioItem = CuriosApi.getCurio((class_1799)item.method_7854()).orElse(null);
        return !(iCurioItem instanceof ItemizedCurioCapabilityAccessor && (accessor = (ItemizedCurioCapabilityAccessor)iCurioItem).getCurioItem() instanceof AccessoryFromCurio);
    }

    private static /* synthetic */ void lambda$getAttributes$1(Multimap multimap, class_2960 id, double amount, class_1322.class_1323 operation, class_6880.class_6883 attribute) {
        multimap.put((Object)attribute, (Object)new class_1322(id, amount, operation));
    }
}

