/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.curios.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.impl.AccessoriesCapabilityImpl;
import io.wispforest.accessories.impl.AccessoriesContainerImpl;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.accessories_compat.curios.pond.CurioInventoryCapabilityExtension;
import io.wispforest.accessories_compat.curios.pond.CurioInventoryExtension;
import io.wispforest.accessories_compat.curios.wrapper.AccessoriesBasedStackHandler;
import io.wispforest.accessories_compat.curios.wrapper.CuriosConversionUtils;
import io.wispforest.accessories_compat.utils.ImmutableDelegatingMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.common.capability.CurioInventory;

@Mixin(value={CurioInventory.class})
public abstract class CurioInventoryMixin
implements CurioInventoryExtension {
    @Shadow
    boolean markDeserialized;
    @Shadow
    class_2487 deserialized;
    @Unique
    private static final Logger LOGGER = LogUtils.getLogger();
    @Unique
    @Nullable
    private AccessoriesCapabilityImpl capability = null;
    @Unique
    @Nullable
    private AccessoriesHolderImpl holder = null;

    @Override
    public List<class_1799> getInvalidStacks() {
        AccessoriesHolderImpl holder;
        if (this.capability != null && (holder = this.holder()) != null) {
            return holder.invalidStacks;
        }
        return List.of();
    }

    @Nullable
    private AccessoriesHolderImpl holder() {
        if (this.capability != null) {
            if (this.holder == null) {
                this.holder = (AccessoriesHolderImpl)this.capability.getHolder();
            }
            return this.holder;
        }
        return null;
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void runInitWithAccessoriesInMind(ICuriosItemHandler curiosItemHandler, CallbackInfo ci) {
        ci.cancel();
        if (!(curiosItemHandler instanceof CurioInventoryCapabilityExtension)) {
            LOGGER.error("Unable to init a given CurioInventory due to given ICuriosItemHandler not being instance of CurioInventoryCapability!");
            return;
        }
        CurioInventoryCapabilityExtension ext = (CurioInventoryCapabilityExtension)curiosItemHandler;
        this.capability = ext.capability();
        this.holder = null;
        if (this.markDeserialized) {
            this.markDeserialized = false;
            if (this.deserialized.method_10577("AccessoriesEncoded") || this.deserialized.method_33133()) {
                return;
            }
            CurioInventoryMixin.readData(this.capability.entity(), (AccessoriesCapability)this.capability, this.holder(), this.deserialized.method_10554("Curios", 10));
            this.deserialized = new class_2487();
        }
    }

    @Unique
    private static void readData(class_1309 livingEntity, AccessoriesCapability capability, AccessoriesHolderImpl holder, class_2499 data) {
        for (int i = 0; i < data.size(); ++i) {
            class_2487 tag = data.method_10602(i);
            String curiosId = tag.method_10558("Identifier");
            SlotType slotType = SlotTypeLoader.getSlotType((class_1937)livingEntity.method_37908(), (String)CuriosConversionUtils.slotConvertToA(curiosId));
            AccessoriesContainer container = slotType != null ? capability.getContainer(slotType) : null;
            holder.invalidStacks.addAll(CurioInventoryMixin.deserializeNBT_StackHandler(livingEntity, container, tag.method_10562("StacksHandler")));
        }
        List invalidStacks = holder.invalidStacks;
        for (SlotEntryReference entryRef : capability.getAllEquipped()) {
            SlotReference reference = entryRef.reference();
            SlotType slotType = reference.type();
            if (AccessoriesAPI.getPredicateResults((Set)slotType.validators(), (class_1937)reference.entity().method_37908(), (class_1309)livingEntity, (SlotType)slotType, (int)0, (class_1799)entryRef.stack())) continue;
            invalidStacks.add(entryRef.stack().method_7972());
            entryRef.reference().setStack(class_1799.field_8037);
        }
    }

    @Unique
    private static List<class_1799> deserializeNBT_StackHandler(class_1309 livingEntity, @Nullable AccessoriesContainer container, class_2487 nbt) {
        ArrayList<class_1799> dropped = new ArrayList<class_1799>();
        if (nbt.method_10545("Stacks")) {
            dropped.addAll(CurioInventoryMixin.deserializeNBT_Stacks(livingEntity, container, AccessoriesContainer::getAccessories, nbt.method_10562("Stacks")));
        }
        if (nbt.method_10545("Cosmetics")) {
            dropped.addAll(CurioInventoryMixin.deserializeNBT_Stacks(livingEntity, container, AccessoriesContainer::getCosmeticAccessories, nbt.method_10562("Cosmetics")));
        }
        return dropped;
    }

    @Unique
    private static List<class_1799> deserializeNBT_Stacks(class_1309 livingEntity, @Nullable AccessoriesContainer container, Function<AccessoriesContainer, class_1263> containerFunc, class_2487 nbt) {
        List<class_1799> list = nbt.method_10554("Items", 10).stream().map(tagEntry -> {
            class_2487 compoundTag;
            return class_1799.method_57359((class_7225.class_7874)livingEntity.method_56673(), (class_2487)(tagEntry instanceof class_2487 ? (compoundTag = (class_2487)tagEntry) : new class_2487()));
        }).toList();
        ArrayList<class_1799> dropped = new ArrayList<class_1799>();
        if (container != null) {
            class_1263 accessories = containerFunc.apply(container);
            for (class_1799 stack : list) {
                boolean consumedStack = false;
                for (int i = 0; i < accessories.method_5439() && !consumedStack; ++i) {
                    class_1799 currentStack = accessories.method_5438(i);
                    if (!currentStack.method_7960()) continue;
                    accessories.method_5447(i, stack.method_7972());
                    consumedStack = true;
                }
                if (consumedStack) continue;
                dropped.add(stack.method_7972());
            }
        } else {
            dropped.addAll(list);
        }
        return dropped;
    }

    @Inject(method={"asMap"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void getMapFromAccessoriesHolder(CallbackInfoReturnable<Map<String, ICurioStacksHandler>> cir) {
        if (this.capability == null) {
            cir.setReturnValue(Map.of());
        } else {
            AccessoriesHolderImpl holder = this.holder();
            if (holder != null) {
                cir.setReturnValue(new ImmutableDelegatingMap<String, ICurioStacksHandler, AccessoriesContainer>("containers", String.class, ICurioStacksHandler.class, holder.getSlotContainers(), CuriosConversionUtils::slotConvertToC, CuriosConversionUtils::slotConvertToA, AccessoriesBasedStackHandler::new, handler -> {
                    AccessoriesContainerImpl accessoriesContainerImpl;
                    if (!(handler instanceof AccessoriesBasedStackHandler)) return null;
                    AccessoriesBasedStackHandler $b$0 = (AccessoriesBasedStackHandler)handler;
                    try {
                        AccessoriesContainerImpl patt1$temp;
                        AccessoriesContainerImpl container;
                        accessoriesContainerImpl = container = (patt1$temp = $b$0.container());
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    return accessoriesContainerImpl;
                }));
            }
        }
    }

    @Inject(method={"replace"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void replaceWithNoop(Map<String, ICurioStacksHandler> curios, CallbackInfo ci) {
        ci.cancel();
    }

    @WrapOperation(method={"serializeNBT(Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/nbt/CompoundTag;"}, at={@At(value="FIELD", target="Ltop/theillusivec4/curios/common/capability/CurioInventory;curios:Ljava/util/Map;")})
    private Map<String, ICurioStacksHandler> useMethodInsteadOfField(CurioInventory instance, Operation<Map<String, ICurioStacksHandler>> original) {
        return instance.asMap();
    }

    @ModifyReturnValue(method={"serializeNBT(Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/nbt/CompoundTag;"}, at={@At(value="RETURN")})
    private class_2487 addFlagForEncodedByCompat(class_2487 original) {
        original.method_10556("AccessoriesEncoded", true);
        return original;
    }
}

