/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.curios.wrapper;

import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.DropRule;
import io.wispforest.accessories.api.SoundEventData;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.events.extra.AllowWalkingOnSnow;
import io.wispforest.accessories.api.events.extra.EndermanMasked;
import io.wispforest.accessories.api.events.extra.FortuneAdjustment;
import io.wispforest.accessories.api.events.extra.PiglinNeutralInducer;
import io.wispforest.accessories.api.events.extra.v2.LootingAdjustment;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories_compat.curios.wrapper.CuriosConversionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1560;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class AccessoryFromCurio
implements Accessory,
LootingAdjustment,
FortuneAdjustment,
AllowWalkingOnSnow,
EndermanMasked,
PiglinNeutralInducer {
    private final Function<class_1799, @Nullable ICurio> getter;

    public AccessoryFromCurio(Function<class_1799, ICurio> getter) {
        this.getter = getter;
    }

    public Optional<ICurio> iCurio(class_1799 stack) {
        return Optional.ofNullable(this.getter.apply(stack));
    }

    public TriState allowWalkingOnSnow(class_1799 itemStack, SlotReference slotReference) {
        return this.convertBoolean(this.iCurio(itemStack).map(iCurio -> iCurio.canWalkOnPowderedSnow(CuriosConversionUtils.objectsConvertToC(slotReference))).orElse(false));
    }

    public TriState isEndermanMasked(class_1560 enderMan, class_1799 itemStack, SlotReference slotReference) {
        return this.convertBoolean(this.iCurio(itemStack).map(iCurio -> iCurio.isEnderMask(CuriosConversionUtils.objectsConvertToC(slotReference), enderMan)).orElse(false));
    }

    public TriState makePiglinsNeutral(class_1799 itemStack, SlotReference slotReference) {
        return this.convertBoolean(this.iCurio(itemStack).map(iCurio -> iCurio.makesPiglinsNeutral(CuriosConversionUtils.objectsConvertToC(slotReference))).orElse(false));
    }

    public int getFortuneAdjustment(class_1799 itemStack, SlotReference slotReference, class_47 lootContext, int i) {
        return this.iCurio(itemStack).map(iCurio -> iCurio.getFortuneLevel(CuriosConversionUtils.objectsConvertToC(slotReference), lootContext)).orElse(0);
    }

    public int getLootingAdjustment(class_1799 itemStack, SlotReference slotReference, class_1309 livingEntity, class_47 lootContext, class_1282 damageSource, int i) {
        return this.iCurio(itemStack).map(iCurio -> iCurio.getLootingLevel(CuriosConversionUtils.objectsConvertToC(slotReference), lootContext)).orElse(0);
    }

    private TriState convertBoolean(boolean value) {
        return value ? TriState.TRUE : TriState.DEFAULT;
    }

    public void tick(class_1799 stack, SlotReference reference) {
        this.iCurio(stack).ifPresent(iCurio -> iCurio.curioTick(CuriosConversionUtils.objectsConvertToC(reference)));
    }

    public void onEquip(class_1799 stack, SlotReference reference) {
        this.iCurio(stack).ifPresent(iCurio -> iCurio.onEquip(CuriosConversionUtils.objectsConvertToC(reference), class_1799.field_8037));
    }

    public void onUnequip(class_1799 stack, SlotReference reference) {
        this.iCurio(stack).ifPresent(iCurio -> iCurio.onUnequip(CuriosConversionUtils.objectsConvertToC(reference), class_1799.field_8037));
    }

    public boolean canEquip(class_1799 stack, SlotReference reference) {
        return this.iCurio(stack).map(iCurio -> iCurio.canEquip(CuriosConversionUtils.objectsConvertToC(reference))).orElse(false);
    }

    public boolean canUnequip(class_1799 stack, SlotReference reference) {
        return this.iCurio(stack).map(iCurio -> iCurio.canUnequip(CuriosConversionUtils.objectsConvertToC(reference))).orElse(true);
    }

    public void getDynamicModifiers(class_1799 stack, SlotReference reference, AccessoryAttributeBuilder builder) {
        SlotContext ctx = CuriosConversionUtils.objectsConvertToC(reference);
        super.getDynamicModifiers(stack, reference, builder);
        class_2960 id = class_2960.method_60655((String)"curios", (String)reference.createSlotPath());
        this.iCurio(stack).ifPresent(iCurio -> iCurio.getAttributeModifiers(ctx, id).forEach((arg_0, arg_1) -> ((AccessoryAttributeBuilder)builder).addExclusive(arg_0, arg_1)));
    }

    public DropRule getDropRule(class_1799 stack, SlotReference reference, class_1282 source) {
        return CuriosConversionUtils.dropRuleConvertToA(this.iCurio(stack).map(iCurio -> iCurio.getDropRule(CuriosConversionUtils.objectsConvertToC(reference), source, true)).orElse(ICurio.DropRule.DEFAULT));
    }

    public void onEquipFromUse(class_1799 stack, SlotReference reference) {
        this.iCurio(stack).ifPresent(iCurio -> iCurio.onEquipFromUse(CuriosConversionUtils.objectsConvertToC(reference)));
    }

    public boolean canEquipFromUse(class_1799 stack) {
        try {
            return this.iCurio(stack).map(iCurio -> iCurio.canEquipFromUse(null)).orElse(false);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @Nullable
    public SoundEventData getEquipSound(class_1799 stack, SlotReference reference) {
        SlotContext ctx = CuriosConversionUtils.objectsConvertToC(reference);
        return this.iCurio(stack).map(iCurio -> iCurio.getEquipSound(ctx)).map(info -> new SoundEventData(class_6880.method_40223((Object)info.soundEvent()), info.volume(), info.pitch())).orElse(super.getEquipSound(stack, reference));
    }

    public void onBreak(class_1799 stack, SlotReference reference) {
        this.iCurio(stack).ifPresent(iCurio -> iCurio.curioBreak(CuriosConversionUtils.objectsConvertToC(reference)));
    }

    public void getAttributesTooltip(class_1799 stack, SlotType type, List<class_2561> tooltips, class_1792.class_9635 tooltipContext, class_1836 tooltipType) {
        this.iCurio(stack).ifPresent(iCurio -> {
            List curioList = iCurio.getAttributesTooltip(new ArrayList(tooltips), tooltipContext);
            tooltips.clear();
            tooltips.addAll(curioList);
        });
    }

    public void getExtraTooltip(class_1799 stack, List<class_2561> tooltips, class_1792.class_9635 tooltipContext, class_1836 tooltipType) {
        this.iCurio(stack).ifPresent(iCurio -> tooltips.addAll(iCurio.getSlotsTooltip(new ArrayList(), tooltipContext)));
    }
}

