/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.trinkets.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import dev.emi.trinkets.api.client.TrinketRenderer;
import dev.emi.trinkets.api.client.TrinketRendererRegistry;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.client.DefaultAccessoryRenderer;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories_compat.trinkets.wrapper.TrinketsWrappingUtils;
import io.wispforest.accessories_compat.trinkets.wrapper.WrappedTrinketInventory;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_583;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TrinketRendererRegistry.class})
public abstract class TrinketRendererRegistryMixin {
    @Inject(method={"registerRenderer"}, at={@At(value="TAIL")})
    private static void registerTrinketsRendererAsAccessories(class_1792 item, final TrinketRenderer trinketRenderer, CallbackInfo ci) {
        AccessoriesRendererRegistry.registerRenderer((class_1792)item, () -> new AccessoryRenderer(){

            public <M extends class_1309> void render(class_1799 stack, SlotReference ref, class_4587 matrices, class_583<M> model, class_4597 multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                matrices.method_22903();
                Optional<dev.emi.trinkets.api.SlotReference> reference = TrinketsWrappingUtils.createTrinketsReference(ref, true);
                if (reference.isEmpty()) {
                    return;
                }
                trinketRenderer.render(stack, reference.get(), model, matrices, multiBufferSource, light, ref.entity(), limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                matrices.method_22909();
            }
        });
    }

    @ModifyReturnValue(method={"getRenderer"}, at={@At(value="RETURN")})
    private static Optional<TrinketRenderer> getAccessoryRendererIfEmpty(Optional<TrinketRenderer> original, @Local(argsOnly=true) class_1792 item) {
        return original.or(() -> Optional.ofNullable(AccessoriesRendererRegistry.getRenderer((class_1792)item)).flatMap(accessoryRenderer -> {
            if (accessoryRenderer == DefaultAccessoryRenderer.INSTANCE && !Accessories.config().clientOptions.forceNullRenderReplacement()) {
                return Optional.empty();
            }
            return Optional.of((stack, ref, contextModel, matrices, vertexConsumers, light, entity, limbAngle, limbDistance, tickDelta, animationProgress, headYaw, headPitch) -> {
                String slotName = ((WrappedTrinketInventory)ref.inventory()).container.getSlotName();
                SlotReference reference = SlotReference.of((class_1309)entity, (String)slotName, (int)ref.index());
                accessoryRenderer.render(stack, reference, matrices, contextModel, vertexConsumers, light, limbAngle, limbDistance, tickDelta, animationProgress, headYaw, headPitch);
            });
        }));
    }
}

