/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.trinkets.wrapper;

import dev.emi.trinkets.api.SlotAttributes;
import dev.emi.trinkets.api.Trinket;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.DropRule;
import io.wispforest.accessories.api.SoundEventData;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories_compat.trinkets.wrapper.TrinketsWrappingUtils;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_6880;

public record AccessoryFromTrinket(Trinket trinket) implements Accessory
{
    public void tick(class_1799 stack, SlotReference reference) {
        Optional<dev.emi.trinkets.api.SlotReference> ref = TrinketsWrappingUtils.createTrinketsReference(reference);
        if (ref.isEmpty()) {
            super.tick(stack, reference);
            return;
        }
        this.trinket.tick(stack, ref.get(), reference.entity());
    }

    public void onEquip(class_1799 stack, SlotReference reference) {
        Optional<dev.emi.trinkets.api.SlotReference> ref = TrinketsWrappingUtils.createTrinketsReference(reference);
        if (ref.isEmpty()) {
            super.onEquip(stack, reference);
            return;
        }
        this.trinket.onEquip(stack, ref.get(), reference.entity());
    }

    public void onUnequip(class_1799 stack, SlotReference reference) {
        Optional<dev.emi.trinkets.api.SlotReference> ref = TrinketsWrappingUtils.createTrinketsReference(reference);
        if (ref.isEmpty()) {
            super.onUnequip(stack, reference);
            return;
        }
        this.trinket.onUnequip(stack, ref.get(), reference.entity());
    }

    public boolean canEquip(class_1799 stack, SlotReference reference) {
        Optional<dev.emi.trinkets.api.SlotReference> ref = TrinketsWrappingUtils.createTrinketsReference(reference);
        if (ref.isEmpty()) {
            return super.canEquip(stack, reference);
        }
        return this.trinket.canEquip(stack, ref.get(), reference.entity());
    }

    public boolean canUnequip(class_1799 stack, SlotReference reference) {
        Optional<dev.emi.trinkets.api.SlotReference> ref = TrinketsWrappingUtils.createTrinketsReference(reference);
        if (ref.isEmpty()) {
            return super.canUnequip(stack, reference);
        }
        return this.trinket.canUnequip(stack, ref.get(), reference.entity());
    }

    public void getDynamicModifiers(class_1799 stack, SlotReference reference, AccessoryAttributeBuilder builder) {
        Optional<dev.emi.trinkets.api.SlotReference> ref = TrinketsWrappingUtils.createTrinketsReference(reference);
        if (ref.isEmpty()) {
            super.getDynamicModifiers(stack, reference, builder);
        } else {
            class_2960 id = SlotAttributes.getIdentifier((dev.emi.trinkets.api.SlotReference)ref.get());
            this.trinket.getModifiers(stack, ref.get(), reference.entity(), id).asMap().forEach((attribute, modifiers) -> {
                for (class_1322 modifier : modifiers) {
                    if (modifier.comp_2447().equals((Object)id)) {
                        builder.addStackable(attribute, Accessories.of((String)"trinket_converted_attribute"), modifier.comp_2449(), modifier.comp_2450());
                        continue;
                    }
                    builder.addExclusive(attribute, modifier);
                }
            });
        }
    }

    public DropRule getDropRule(class_1799 stack, SlotReference reference, class_1282 source) {
        Optional<dev.emi.trinkets.api.SlotReference> ref = TrinketsWrappingUtils.createTrinketsReference(reference);
        if (ref.isEmpty()) {
            return super.getDropRule(stack, reference, source);
        }
        return TrinketsWrappingUtils.convertDropRule(this.trinket.getDropRule(stack, ref.get(), reference.entity()));
    }

    public void onBreak(class_1799 stack, SlotReference reference) {
        Optional<dev.emi.trinkets.api.SlotReference> ref = TrinketsWrappingUtils.createTrinketsReference(reference);
        if (ref.isEmpty()) {
            super.onBreak(stack, reference);
        } else {
            this.trinket.onBreak(stack, ref.get(), reference.entity());
        }
    }

    public boolean canEquipFromUse(class_1799 stack) {
        try {
            return this.trinket.canEquipFromUse(stack, null);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public SoundEventData getEquipSound(class_1799 stack, SlotReference reference) {
        Optional<dev.emi.trinkets.api.SlotReference> ref = TrinketsWrappingUtils.createTrinketsReference(reference);
        if (ref.isEmpty()) {
            return super.getEquipSound(stack, reference);
        }
        class_6880 holder = this.trinket.getEquipSound(stack, ref.get(), reference.entity());
        if (holder == null) {
            return null;
        }
        return new SoundEventData(holder, 1.0f, 1.0f);
    }
}

