/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.trinkets.wrapper;

import com.mojang.datafixers.util.Function3;
import com.mojang.logging.LogUtils;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketInventory;
import io.wispforest.accessories.api.slot.EntityBasedPredicate;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories_compat.trinkets.wrapper.EmptyTrinketInventory;
import io.wispforest.accessories_compat.utils.LoaderPlatformUtils;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class SafeSlotBasedPredicate
implements EntityBasedPredicate {
    private static final Logger LOGGER = LogUtils.getLogger();
    private boolean hasErrored = false;
    private final class_2960 location;
    private final Function3<class_1799, SlotReference, class_1309, TriState> trinketPredicate;

    public SafeSlotBasedPredicate(class_2960 location, Function3<class_1799, SlotReference, class_1309, TriState> trinketPredicate) {
        this.location = location;
        this.trinketPredicate = trinketPredicate;
    }

    public TriState isValid(class_1937 level, @Nullable class_1309 entity, SlotType slotType, int slot, class_1799 stack) {
        if (this.hasErrored) {
            return TriState.DEFAULT;
        }
        boolean isClient = level != null ? level.method_8608() : LoaderPlatformUtils.INSTANCE.isClientOnlyEnv();
        try {
            return (TriState)this.trinketPredicate.apply((Object)stack, (Object)new SlotReference((TrinketInventory)new EmptyTrinketInventory(entity, slotType, isClient), slot), (Object)entity);
        }
        catch (Exception e) {
            this.hasErrored = true;
            LOGGER.warn("Unable to handle Trinket Slot Predicate converted to Accessories Slot Predicate due to fundamental incompatibility, issues may be present with it! [Slot: {}, Predicate ID: {}]", new Object[]{slotType.name(), this.location, e});
            return TriState.DEFAULT;
        }
    }
}

