/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.utils;

import java.util.ServiceLoader;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface LoaderPlatformUtils {
    @ApiStatus.Internal
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"LoaderPlatformUtils");
    public static final LoaderPlatformUtils INSTANCE = LoaderPlatformUtils.load(LoaderPlatformUtils.class);

    public Platform getPlatform();

    public boolean isDevelopmentEnvironment();

    public boolean isModLoaded(String var1);

    public boolean isClientOnlyEnv();

    private static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        LOGGER.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }

    public static enum Platform {
        FABRIC,
        NEOFORGE;

    }
}

