/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import dev.upcraft.sparkweave.api.command.CommandHelper;
import dev.upcraft.sparkweave.api.command.argument.RegistryArgumentType;
import dev.upcraft.sparkweave.api.platform.Services;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6885;

public class DumpTagsCommand {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void register(LiteralArgumentBuilder<class_2168> $) {
        $.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"dump_tags").requires(src -> src.method_9259(4))).executes(DumpTagsCommand::dumpAllTags)).then(class_2170.method_9244((String)"type", (ArgumentType)RegistryArgumentType.registry()).executes(ctx -> DumpTagsCommand.dumpTags((CommandContext<class_2168>)ctx, RegistryArgumentType.getRegistry((CommandContext<class_2168>)ctx, "type"))))).then(class_2170.method_9247((String)"all").executes(DumpTagsCommand::dumpAllTags)));
    }

    private static int dumpAllTags(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        class_5455.class_6890 registryAccess = ((class_2168)ctx.getSource()).method_9211().method_46221().method_45926();
        List registries = registryAccess.method_55282().toList();
        Path dir = Services.PLATFORM.getGameDir().resolve("sparkweave").resolve("tag_export");
        for (class_5321 registryKey : registries) {
            class_2378 registry = (class_2378)registryAccess.method_33310(registryKey).orElseThrow();
            DumpTagsCommand.saveTags(registry, dir);
        }
        if (((class_2168)ctx.getSource()).method_9211().method_19466(player.method_7334())) {
            class_5250 path = class_2561.method_43470((String)dir.toString()).method_27694(style -> style.method_27705(new class_124[]{class_124.field_1078, class_124.field_1073}).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"chat.sparkweave.open_folder"))).method_10958(new class_2558(class_2558.class_2559.field_11746, dir.toString())));
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.sparkweave.debug.dump_tags.multi_success_path", (Object[])new Object[]{registries.size(), path}), true);
        } else {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.sparkweave.debug.dump_tags.multi_success", (Object[])new Object[]{registries.size()}), true);
        }
        return registries.size();
    }

    private static int dumpTags(CommandContext<class_2168> ctx, class_2378<?> registry) throws CommandSyntaxException {
        Path dir = Services.PLATFORM.getGameDir().resolve("sparkweave").resolve("tag_export");
        DumpTagsCommand.saveTags(registry, dir);
        CommandHelper.sendPathResult(ctx, dir.resolve(registry.method_30517().method_29177().method_12836()).resolve(registry.method_30517().method_29177().method_12832()), () -> class_2561.method_43469((String)"commands.sparkweave.debug.dump_tags.success", (Object[])new Object[]{registry.method_30517().method_29177()}), path -> class_2561.method_43469((String)"commands.sparkweave.debug.dump_tags.success_path", (Object[])new Object[]{registry.method_30517().method_29177(), path}));
        return 1;
    }

    private static void saveTags(class_2378<?> registry, Path dir) throws CommandSyntaxException {
        Path rootDir = dir.resolve(registry.method_30517().method_29177().method_12836()).resolve(registry.method_30517().method_29177().method_12832());
        List tags = registry.method_40272().toList();
        for (Pair tagPair : tags) {
            class_2960 name = ((class_6862)tagPair.getFirst()).comp_327();
            Path outputFile = rootDir.resolve(name.method_12836()).resolve(name.method_12832() + ".json");
            JsonObject json = new JsonObject();
            JsonArray array = new JsonArray();
            ((class_6885.class_6888)tagPair.getSecond()).method_40239().map(holder -> (String)holder.method_40229().map(k -> k.method_29177().toString(), Object::toString)).forEach(arg_0 -> ((JsonArray)array).add(arg_0));
            json.add("values", (JsonElement)array);
            try {
                Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
                BufferedWriter writer = Files.newBufferedWriter(outputFile, new OpenOption[0]);
                try {
                    GSON.toJson((JsonElement)json, (Appendable)writer);
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
            catch (IOException e) {
                throw CommandHelper.IO_EXCEPTION.create((Object)e);
            }
        }
    }
}

