/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.scheduler;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Either;
import dev.upcraft.sparkweave.scheduler.AbstractTask;
import java.util.concurrent.Callable;
import java.util.function.LongSupplier;

public class RepeatingTask<T>
extends AbstractTask<T> {
    private final long period;
    private Either<T, ? extends Exception> lastResult = Either.right((Object)new IllegalStateException("Task has not been run yet."));

    public RepeatingTask(long nextExecutionTime, long period, Callable<T> task) {
        super(nextExecutionTime, task);
        Preconditions.checkArgument((period > 0L ? 1 : 0) != 0, (Object)"Period must be greater than 0!");
        this.period = period;
    }

    public long period() {
        return this.period;
    }

    @Override
    public synchronized boolean run(LongSupplier timeSupplier) {
        long startTime = timeSupplier.getAsLong();
        this.nextExecutionTime = startTime + this.period();
        try {
            this.lastResult = Either.left(this.task.call());
            return true;
        }
        catch (Exception e) {
            this.lastResult = Either.right((Object)e);
            return false;
        }
    }

    @Override
    public Either<T, ? extends Exception> getLastResult() {
        return this.lastResult;
    }
}

