/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.validation;

import dev.upcraft.sparkweave.api.logging.SparkweaveLoggerFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2966;
import org.apache.logging.log4j.Logger;

public class TranslationChecker {
    private static final Logger LOGGER = SparkweaveLoggerFactory.getLogger();
    private static final Set<String> MISSING_KEYS = new HashSet<String>();
    private static final Set<String> MISSING_KEYS_VIEW = Collections.unmodifiableSet(MISSING_KEYS);

    private static void notifyMissingTranslation(String translationKey) {
        if (!MISSING_KEYS.contains(translationKey)) {
            LOGGER.warn("Missing translation for key '{}'", (Object)translationKey);
            MISSING_KEYS.add(translationKey);
        }
    }

    public static void validate() {
        LOGGER.info("Validating translations...");
        class_2966.method_17597().forEach(TranslationChecker::notifyMissingTranslation);
    }

    public static Set<String> getMissingKeys() {
        return MISSING_KEYS_VIEW;
    }
}

