/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.activation_range;

import java.util.function.Predicate;
import me.wesley1808.servercore.common.ServerCore;
import me.wesley1808.servercore.common.config.Config;
import me.wesley1808.servercore.common.config.MainConfig;
import me.wesley1808.servercore.common.config.data.activation_range.ActivationRangeConfig;
import me.wesley1808.servercore.common.config.data.activation_range.ActivationType;
import me.wesley1808.servercore.common.config.data.activation_range.CustomActivationType;
import me.wesley1808.servercore.common.config.impl.activation_range.ActivationTypeImpl;
import me.wesley1808.servercore.common.utils.Util;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1307;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1420;
import net.minecraft.class_1429;
import net.minecraft.class_1472;
import net.minecraft.class_1501;
import net.minecraft.class_1508;
import net.minecraft.class_1510;
import net.minecraft.class_1511;
import net.minecraft.class_1528;
import net.minecraft.class_1538;
import net.minecraft.class_1541;
import net.minecraft.class_1542;
import net.minecraft.class_1548;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1671;
import net.minecraft.class_1672;
import net.minecraft.class_1685;
import net.minecraft.class_1690;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3855;
import net.minecraft.class_3857;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4168;
import net.minecraft.class_4466;
import net.minecraft.class_5575;
import net.minecraft.class_9817;

public class ActivationRange {
    private static final double MINIMUM_MOVEMENT = 0.001;
    private static final ActivationType DUMMY_ACTIVATION_TYPE = new ActivationTypeImpl(0, 0, 0, false, false);
    private static final Predicate<class_1352> BEE_GOAL_IMMUNITIES = goal -> goal instanceof class_4466.class_4473 || goal instanceof class_4466.class_4472;
    private static final class_4168[] VILLAGER_PANIC_IMMUNITIES = new class_4168[]{class_4168.field_19043, class_4168.field_19042, class_4168.field_19041, class_4168.field_18599};

    public static ActivationType initializeEntityActivationType(class_1297 entity) {
        MainConfig mainConfig = Config.getSafe();
        if (mainConfig == null) {
            ServerCore.LOGGER.warn("[ServerCore] Entity {} was initialized before modloading! Defaulting to dummy activation type.", (Object)entity);
            return DUMMY_ACTIVATION_TYPE;
        }
        ActivationRangeConfig config = mainConfig.activationRange();
        for (CustomActivationType type : config.activationTypes()) {
            for (class_5575<? super class_1297, ?> class_55752 : type.matchers()) {
                if (class_55752.method_31796((Object)entity) == null) continue;
                return type;
            }
        }
        return config.defaultActivationType();
    }

    public static boolean isExcluded(class_1297 entity) {
        ActivationType type = entity.servercore$getActivationType();
        int tickInterval = type.tickInterval();
        return tickInterval == 0 || tickInterval == 1 || type.activationRange() <= 0 || entity instanceof class_1657 || entity instanceof class_3857 || entity instanceof class_1510 || entity instanceof class_1508 || entity instanceof class_1528 || entity instanceof class_3855 || entity instanceof class_1538 || entity instanceof class_1541 || entity instanceof class_1511 || entity instanceof class_1671 || entity instanceof class_1672 || entity instanceof class_1685 || Config.get().activationRange().excludedEntityTypes().contains(entity.method_5864());
    }

    public static void activateEntities(class_3218 level, int currentTick) {
        ActivationRangeConfig config = Config.get().activationRange();
        if (!config.enabled()) {
            return;
        }
        int maxRange = Integer.MIN_VALUE;
        for (CustomActivationType type : config.activationTypes()) {
            maxRange = Math.max(type.activationRange(), maxRange);
        }
        maxRange = Math.min((level.method_8503().method_3760().method_14568() << 4) - 8, maxRange);
        for (class_3222 player : level.method_18456()) {
            if (player.method_7325()) continue;
            class_238 maxBB = player.method_5829().method_1009((double)maxRange, 256.0, (double)maxRange);
            for (class_1297 entity : level.method_8335((class_1297)player, maxBB)) {
                ActivationRange.activateEntity(player, entity, currentTick, config);
            }
        }
    }

    private static void activateEntity(class_3222 player, class_1297 entity, int currentTick, ActivationRangeConfig config) {
        if (currentTick > entity.servercore$getActivatedTick() && (entity.servercore$isExcluded() || ActivationRange.isWithinRange(player, entity, config))) {
            entity.servercore$setActivatedTick(currentTick + 19);
        }
    }

    private static boolean isWithinRange(class_3222 player, class_1297 entity, ActivationRangeConfig config) {
        ActivationType type = entity.servercore$getActivationType();
        int range = type.activationRange();
        int chessboardDistance = Math.max(Math.abs(player.method_31477() - entity.method_31477()), Math.abs(player.method_31479() - entity.method_31479()));
        if (chessboardDistance > range) {
            return false;
        }
        if (config.useVerticalRange()) {
            int deltaY = entity.method_31478() - player.method_31478();
            return deltaY <= range && deltaY >= -range || deltaY > 0 && type.extraHeightUp() || deltaY < 0 && type.extraHeightDown();
        }
        return true;
    }

    public static int checkEntityImmunities(class_1297 entity, int currentTick, ActivationRangeConfig config) {
        int inactiveWakeUpImmunity = ActivationRange.checkInactiveWakeup(entity, currentTick);
        if (inactiveWakeUpImmunity > -1) {
            return inactiveWakeUpImmunity;
        }
        if (entity.method_20802() > 0) {
            return 2;
        }
        if (entity.servercore$getActivatedImmunityTick() >= currentTick) {
            return 1;
        }
        if (!entity.method_5805()) {
            return 40;
        }
        if (entity.method_5799() && entity.method_5675() && !(entity instanceof class_1296) && !(entity instanceof class_1646) && !(entity instanceof class_1690)) {
            return 100;
        }
        if (entity instanceof class_1542 || entity instanceof class_1303) {
            class_243 movement = entity.method_18798();
            if (Math.abs(movement.field_1352) > 0.001 || Math.abs(movement.field_1350) > 0.001 || movement.field_1351 > 0.001) {
                return 20;
            }
        }
        if (!(entity instanceof class_1665)) {
            if (!(entity.method_24828() || entity.method_5799() || entity instanceof class_1307 || entity instanceof class_1420)) {
                return 10;
            }
        } else {
            class_1665 projectile = (class_1665)entity;
            if (!projectile.field_7588) {
                return 1;
            }
        }
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            if (living.field_6282 || !living.method_6026().isEmpty() || living.method_6101()) {
                return 1;
            }
            if (living instanceof class_1308) {
                class_1548 creeper;
                class_1501 llama;
                class_1308 mob = (class_1308)living;
                if (mob.method_5968() != null || mob.method_18868().method_18896(class_4140.field_22355)) {
                    return 20;
                }
                if (mob instanceof class_4466) {
                    class_4466 bee = (class_4466)mob;
                    if (bee.field_21079.method_23346() || bee.method_29511() || Util.hasTasks(bee.field_6201, BEE_GOAL_IMMUNITIES)) {
                        return 20;
                    }
                }
                if (mob instanceof class_1646) {
                    int immunityAfter;
                    class_1646 villager = (class_1646)mob;
                    class_4095 brain = villager.method_18868();
                    if (config.villagerTickPanic()) {
                        for (class_4168 activity : VILLAGER_PANIC_IMMUNITIES) {
                            if (!brain.method_18906(activity)) continue;
                            return 100;
                        }
                    }
                    if ((immunityAfter = config.villagerWorkImmunityAfter()) > 0 && currentTick - mob.servercore$getActivatedTick() >= immunityAfter && brain.method_18906(class_4168.field_18596)) {
                        return config.villagerWorkImmunityFor();
                    }
                }
                if (mob instanceof class_1501 && (llama = (class_1501)mob).method_6805()) {
                    return 1;
                }
                if (mob instanceof class_1429) {
                    class_1472 sheep;
                    class_1429 animal = (class_1429)mob;
                    if (animal.method_6109() || animal.method_6479()) {
                        return 5;
                    }
                    if (mob instanceof class_1472 && (sheep = (class_1472)mob).method_6629()) {
                        return 1;
                    }
                }
                if (mob instanceof class_1548 && (creeper = (class_1548)mob).method_7000()) {
                    return 20;
                }
                if (Util.hasTasks(mob.field_6185)) {
                    return 0;
                }
            }
        }
        return -1;
    }

    public static boolean checkIfActive(class_1297 entity, int currentTick) {
        boolean active;
        ActivationRangeConfig config = Config.get().activationRange();
        if (ActivationRange.shouldTick(entity, config)) {
            entity.servercore$setActivatedTick(currentTick);
            return true;
        }
        boolean bl = active = entity.servercore$getActivatedTick() >= currentTick;
        if (!active) {
            int immunity;
            int inactiveTicks = currentTick - entity.servercore$getActivatedTick() - 1;
            if (inactiveTicks % 20 == 0 && (immunity = ActivationRange.checkEntityImmunities(entity, currentTick, config)) >= 0) {
                entity.servercore$setActivatedTick(currentTick + immunity);
                return true;
            }
            int tickInterval = entity.servercore$getActivationType().tickInterval();
            if (tickInterval > 0 && inactiveTicks % tickInterval == 0) {
                return true;
            }
        } else if (config.skipNonImmune() && entity.servercore$getFullTickCount() % 4 == 0 && ActivationRange.checkEntityImmunities(entity, currentTick, config) < 0) {
            return false;
        }
        return active;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean shouldTick(class_1297 entity, ActivationRangeConfig config) {
        class_9817 leashable;
        if (!config.enabled()) return true;
        if (entity.servercore$isExcluded()) return true;
        if (entity.method_30230()) return true;
        if (entity.field_51994 != null) {
            if (entity.field_51994.method_60709()) return true;
        }
        if (entity.field_6012 < 200) {
            if (entity.servercore$getActivationType() == config.defaultActivationType()) return true;
            if (config.tickNewEntities()) return true;
        }
        if (entity instanceof class_9817 && (leashable = (class_9817)entity).method_60955() != null) {
            if (leashable.method_60955().field_52217 instanceof class_1657) return true;
        }
        if (!(entity instanceof class_1309)) return false;
        class_1309 living = (class_1309)entity;
        if (living.field_6235 <= 0) return false;
        return true;
    }

    private static int checkInactiveWakeup(class_1297 entity, int currentTick) {
        int wakeupInterval = entity.servercore$getActivationType().wakeupInterval();
        if (wakeupInterval > 0 && (long)(currentTick - entity.servercore$getActivatedTick()) >= (long)wakeupInterval * 20L) {
            return 100;
        }
        return -1;
    }
}

