/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.codecs.lucene95;

import guideme.internal.shaded.lucene.codecs.hnsw.FlatVectorsScorer;
import guideme.internal.shaded.lucene.codecs.lucene90.IndexedDISI;
import guideme.internal.shaded.lucene.codecs.lucene95.HasIndexSlice;
import guideme.internal.shaded.lucene.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import guideme.internal.shaded.lucene.index.FloatVectorValues;
import guideme.internal.shaded.lucene.index.KnnVectorValues;
import guideme.internal.shaded.lucene.index.VectorEncoding;
import guideme.internal.shaded.lucene.index.VectorSimilarityFunction;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.VectorScorer;
import guideme.internal.shaded.lucene.store.IndexInput;
import guideme.internal.shaded.lucene.store.RandomAccessInput;
import guideme.internal.shaded.lucene.util.Bits;
import guideme.internal.shaded.lucene.util.hnsw.RandomVectorScorer;
import guideme.internal.shaded.lucene.util.packed.DirectMonotonicReader;
import java.io.IOException;

public abstract class OffHeapFloatVectorValues
extends FloatVectorValues
implements HasIndexSlice {
    protected final int dimension;
    protected final int size;
    protected final IndexInput slice;
    protected final int byteSize;
    protected int lastOrd = -1;
    protected final float[] value;
    protected final VectorSimilarityFunction similarityFunction;
    protected final FlatVectorsScorer flatVectorsScorer;

    OffHeapFloatVectorValues(int dimension, int size, IndexInput slice, int byteSize, FlatVectorsScorer flatVectorsScorer, VectorSimilarityFunction similarityFunction) {
        this.dimension = dimension;
        this.size = size;
        this.slice = slice;
        this.byteSize = byteSize;
        this.similarityFunction = similarityFunction;
        this.flatVectorsScorer = flatVectorsScorer;
        this.value = new float[dimension];
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public IndexInput getSlice() {
        return this.slice;
    }

    @Override
    public float[] vectorValue(int targetOrd) throws IOException {
        if (this.lastOrd == targetOrd) {
            return this.value;
        }
        this.slice.seek((long)targetOrd * (long)this.byteSize);
        this.slice.readFloats(this.value, 0, this.value.length);
        this.lastOrd = targetOrd;
        return this.value;
    }

    public static OffHeapFloatVectorValues load(VectorSimilarityFunction vectorSimilarityFunction, FlatVectorsScorer flatVectorsScorer, OrdToDocDISIReaderConfiguration configuration, VectorEncoding vectorEncoding, int dimension, long vectorDataOffset, long vectorDataLength, IndexInput vectorData) throws IOException {
        if (configuration.docsWithFieldOffset == -2L || vectorEncoding != VectorEncoding.FLOAT32) {
            return new EmptyOffHeapVectorValues(dimension, flatVectorsScorer, vectorSimilarityFunction);
        }
        IndexInput bytesSlice = vectorData.slice("vector-data", vectorDataOffset, vectorDataLength);
        int byteSize = dimension * 4;
        if (configuration.docsWithFieldOffset == -1L) {
            return new DenseOffHeapVectorValues(dimension, configuration.size, bytesSlice, byteSize, flatVectorsScorer, vectorSimilarityFunction);
        }
        return new SparseOffHeapVectorValues(configuration, vectorData, bytesSlice, dimension, byteSize, flatVectorsScorer, vectorSimilarityFunction);
    }

    private static class EmptyOffHeapVectorValues
    extends OffHeapFloatVectorValues {
        public EmptyOffHeapVectorValues(int dimension, FlatVectorsScorer flatVectorsScorer, VectorSimilarityFunction similarityFunction) {
            super(dimension, 0, null, 0, flatVectorsScorer, similarityFunction);
        }

        @Override
        public int dimension() {
            return super.dimension();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public EmptyOffHeapVectorValues copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public float[] vectorValue(int targetOrd) {
            throw new UnsupportedOperationException();
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createDenseIterator();
        }

        @Override
        public Bits getAcceptOrds(Bits acceptDocs) {
            return null;
        }

        @Override
        public VectorScorer scorer(float[] query) {
            return null;
        }
    }

    public static class DenseOffHeapVectorValues
    extends OffHeapFloatVectorValues {
        public DenseOffHeapVectorValues(int dimension, int size, IndexInput slice, int byteSize, FlatVectorsScorer flatVectorsScorer, VectorSimilarityFunction similarityFunction) {
            super(dimension, size, slice, byteSize, flatVectorsScorer, similarityFunction);
        }

        @Override
        public DenseOffHeapVectorValues copy() throws IOException {
            return new DenseOffHeapVectorValues(this.dimension, this.size, this.slice.clone(), this.byteSize, this.flatVectorsScorer, this.similarityFunction);
        }

        @Override
        public int ordToDoc(int ord) {
            return ord;
        }

        @Override
        public Bits getAcceptOrds(Bits acceptDocs) {
            return acceptDocs;
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createDenseIterator();
        }

        @Override
        public VectorScorer scorer(float[] query) throws IOException {
            DenseOffHeapVectorValues copy = this.copy();
            final KnnVectorValues.DocIndexIterator iterator = copy.iterator();
            final RandomVectorScorer randomVectorScorer = this.flatVectorsScorer.getRandomVectorScorer(this.similarityFunction, (KnnVectorValues)copy, query);
            return new VectorScorer(){

                @Override
                public float score() throws IOException {
                    return randomVectorScorer.score(iterator.docID());
                }

                @Override
                public DocIdSetIterator iterator() {
                    return iterator;
                }
            };
        }
    }

    private static class SparseOffHeapVectorValues
    extends OffHeapFloatVectorValues {
        private final DirectMonotonicReader ordToDoc;
        private final IndexedDISI disi;
        private final IndexInput dataIn;
        private final OrdToDocDISIReaderConfiguration configuration;

        public SparseOffHeapVectorValues(OrdToDocDISIReaderConfiguration configuration, IndexInput dataIn, IndexInput slice, int dimension, int byteSize, FlatVectorsScorer flatVectorsScorer, VectorSimilarityFunction similarityFunction) throws IOException {
            super(dimension, configuration.size, slice, byteSize, flatVectorsScorer, similarityFunction);
            this.configuration = configuration;
            RandomAccessInput addressesData = dataIn.randomAccessSlice(configuration.addressesOffset, configuration.addressesLength);
            this.dataIn = dataIn;
            this.ordToDoc = DirectMonotonicReader.getInstance(configuration.meta, addressesData);
            this.disi = new IndexedDISI(dataIn, configuration.docsWithFieldOffset, configuration.docsWithFieldLength, configuration.jumpTableEntryCount, configuration.denseRankPower, configuration.size);
        }

        @Override
        public SparseOffHeapVectorValues copy() throws IOException {
            return new SparseOffHeapVectorValues(this.configuration, this.dataIn, this.slice.clone(), this.dimension, this.byteSize, this.flatVectorsScorer, this.similarityFunction);
        }

        @Override
        public int ordToDoc(int ord) {
            return (int)this.ordToDoc.get(ord);
        }

        @Override
        public Bits getAcceptOrds(final Bits acceptDocs) {
            if (acceptDocs == null) {
                return null;
            }
            return new Bits(){

                @Override
                public boolean get(int index) {
                    return acceptDocs.get(this.ordToDoc(index));
                }

                @Override
                public int length() {
                    return size;
                }
            };
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return IndexedDISI.asDocIndexIterator(this.disi);
        }

        @Override
        public VectorScorer scorer(float[] query) throws IOException {
            SparseOffHeapVectorValues copy = this.copy();
            final KnnVectorValues.DocIndexIterator iterator = copy.iterator();
            final RandomVectorScorer randomVectorScorer = this.flatVectorsScorer.getRandomVectorScorer(this.similarityFunction, (KnnVectorValues)copy, query);
            return new VectorScorer(){

                @Override
                public float score() throws IOException {
                    return randomVectorScorer.score(iterator.index());
                }

                @Override
                public DocIdSetIterator iterator() {
                    return iterator;
                }
            };
        }
    }
}

