/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.mdx;

import guideme.libs.mdx.EcmaScriptIdentifiers;
import guideme.libs.mdx.FactoryMdxExpression;
import guideme.libs.micromark.Assert;
import guideme.libs.micromark.CharUtil;
import guideme.libs.micromark.Construct;
import guideme.libs.micromark.ParseException;
import guideme.libs.micromark.Point;
import guideme.libs.micromark.State;
import guideme.libs.micromark.TokenizeContext;
import guideme.libs.micromark.Tokenizer;
import guideme.libs.micromark.factory.FactorySpace;
import java.util.Locale;

public final class FactoryTag {
    private static final Construct lazyLineEnd = new Construct();

    private FactoryTag() {
    }

    public static State create(final TokenizeContext context, final Tokenizer.Effects effects, final State ok, final State nok, final boolean allowLazy, final String tagType, final String tagMarkerType, final String tagClosingMarkerType, final String tagSelfClosingMarker, final String tagNameType, final String tagNamePrimaryType, final String tagNameMemberMarkerType, final String tagNameMemberType, final String tagNamePrefixMarkerType, final String tagNameLocalType, final String tagExpressionAttributeType, final String tagExpressionAttributeMarkerType, final String tagExpressionAttributeValueType, final String tagAttributeType, final String tagAttributeNameType, final String tagAttributeNamePrimaryType, final String tagAttributeNamePrefixMarkerType, final String tagAttributeNameLocalType, final String tagAttributeInitializerMarkerType, final String tagAttributeValueLiteralType, final String tagAttributeValueLiteralMarkerType, final String tagAttributeValueLiteralValueType, final String tagAttributeValueExpressionType, final String tagAttributeValueExpressionMarkerType, final String tagAttributeValueExpressionValueType) {
        class StateMachine {
            State returnState;
            Integer marker;
            Point startPoint;

            StateMachine() {
            }

            State start(int code) {
                Assert.check(code == 60, "expected `<`");
                this.startPoint = context.now();
                effects.enter(tagType);
                effects.enter(tagMarkerType);
                effects.consume(code);
                effects.exit(tagMarkerType);
                return this::afterStart;
            }

            State afterStart(int code) {
                if (CharUtil.markdownLineEnding(code) || CharUtil.markdownSpace(code)) {
                    return nok.step(code);
                }
                this.returnState = this::beforeName;
                return this.optionalEsWhitespace(code);
            }

            State beforeName(int code) {
                if (code == 47) {
                    effects.enter(tagClosingMarkerType);
                    effects.consume(code);
                    effects.exit(tagClosingMarkerType);
                    this.returnState = this::beforeClosingTagName;
                    return this::optionalEsWhitespace;
                }
                if (code == 62) {
                    return this.tagEnd(code);
                }
                if (code != Integer.MIN_VALUE && EcmaScriptIdentifiers.isStart(code)) {
                    effects.enter(tagNameType);
                    effects.enter(tagNamePrimaryType);
                    effects.consume(code);
                    return this::primaryName;
                }
                return (State)this.crash(code, "before name", "a character that can start a name, such as a letter, `$`, or `_`" + (code == 33 ? " (note: to create a comment in MDX, use `{/* text */}`)" : ""));
            }

            State beforeClosingTagName(int code) {
                if (code == 62) {
                    return this.tagEnd(code);
                }
                if (code != Integer.MIN_VALUE && EcmaScriptIdentifiers.isStart(code)) {
                    effects.enter(tagNameType);
                    effects.enter(tagNamePrimaryType);
                    effects.consume(code);
                    return this::primaryName;
                }
                return (State)this.crash(code, "before name", "a character that can start a name, such as a letter, `$`, or `_`" + (code == 42 || code == 47 ? " (note: JS comments in JSX tags are not supported in MDX)" : ""));
            }

            State primaryName(int code) {
                if (code == 45 || code != Integer.MIN_VALUE && EcmaScriptIdentifiers.isCont(code)) {
                    effects.consume(code);
                    return this::primaryName;
                }
                if (code == 46 || code == 47 || code == 58 || code == 62 || code == 123 || CharUtil.markdownLineEndingOrSpace(code) || CharUtil.unicodeWhitespace(code)) {
                    effects.exit(tagNamePrimaryType);
                    this.returnState = this::afterPrimaryName;
                    return this.optionalEsWhitespace(code);
                }
                return (State)this.crash(code, "in name", "a name character such as letters, digits, `$`, or `_`; whitespace before attributes; or the end of the tag" + (code == 64 ? " (note: to create a link in MDX, use `[text](url)`)" : ""));
            }

            State afterPrimaryName(int code) {
                if (code == 46) {
                    effects.enter(tagNameMemberMarkerType);
                    effects.consume(code);
                    effects.exit(tagNameMemberMarkerType);
                    this.returnState = this::beforeMemberName;
                    return this::optionalEsWhitespace;
                }
                if (code == 58) {
                    effects.enter(tagNamePrefixMarkerType);
                    effects.consume(code);
                    effects.exit(tagNamePrefixMarkerType);
                    this.returnState = this::beforeLocalName;
                    return this::optionalEsWhitespace;
                }
                if (code == 47 || code == 62 || code == 123 || code != Integer.MIN_VALUE && EcmaScriptIdentifiers.isStart(code)) {
                    effects.exit(tagNameType);
                    return this.beforeAttribute(code);
                }
                return (State)this.crash(code, "after name", "a character that can start an attribute name, such as a letter, `$`, or `_`; whitespace before attributes; or the end of the tag");
            }

            State beforeMemberName(int code) {
                if (code != Integer.MIN_VALUE && EcmaScriptIdentifiers.isStart(code)) {
                    effects.enter(tagNameMemberType);
                    effects.consume(code);
                    return this::memberName;
                }
                return (State)this.crash(code, "before member name", "a character that can start an attribute name, such as a letter, `$`, or `_`; whitespace before attributes; or the end of the tag");
            }

            State memberName(int code) {
                if (code == 45 || code != Integer.MIN_VALUE && EcmaScriptIdentifiers.isCont(code)) {
                    effects.consume(code);
                    return this::memberName;
                }
                if (code == 46 || code == 47 || code == 62 || code == 123 || CharUtil.markdownLineEndingOrSpace(code) || CharUtil.unicodeWhitespace(code)) {
                    effects.exit(tagNameMemberType);
                    this.returnState = this::afterMemberName;
                    return this.optionalEsWhitespace(code);
                }
                return (State)this.crash(code, "in member name", "a name character such as letters, digits, `$`, or `_`; whitespace before attributes; or the end of the tag" + (code == 64 ? " (note: to create a link in MDX, use `[text](url)`)" : ""));
            }

            State afterMemberName(int code) {
                if (code == 46) {
                    effects.enter(tagNameMemberMarkerType);
                    effects.consume(code);
                    effects.exit(tagNameMemberMarkerType);
                    this.returnState = this::beforeMemberName;
                    return this::optionalEsWhitespace;
                }
                if (code == 47 || code == 62 || code == 123 || code != Integer.MIN_VALUE && EcmaScriptIdentifiers.isStart(code)) {
                    effects.exit(tagNameType);
                    return this.beforeAttribute(code);
                }
                return (State)this.crash(code, "after member name", "a character that can start an attribute name, such as a letter, `$`, or `_`; whitespace before attributes; or the end of the tag");
            }

            State beforeLocalName(int code) {
                if (code != Integer.MIN_VALUE && EcmaScriptIdentifiers.isStart(code)) {
                    effects.enter(tagNameLocalType);
                    effects.consume(code);
                    return this::localName;
                }
                return (State)this.crash(code, "before local name", "a character that can start a name, such as a letter, `$`, or `_`" + (code == 43 || code > 46 && code < 58 ? " (note: to create a link in MDX, use `[text](url)`)" : ""));
            }

            State localName(int code) {
                if (code == 45 || code != Integer.MIN_VALUE && EcmaScriptIdentifiers.isCont(code)) {
                    effects.consume(code);
                    return this::localName;
                }
                if (code == 47 || code == 62 || code == 123 || CharUtil.markdownLineEndingOrSpace(code) || CharUtil.unicodeWhitespace(code)) {
                    effects.exit(tagNameLocalType);
                    this.returnState = this::afterLocalName;
                    return this.optionalEsWhitespace(code);
                }
                return (State)this.crash(code, "in local name", "a name character such as letters, digits, `$`, or `_`; whitespace before attributes; or the end of the tag");
            }

            State afterLocalName(int code) {
                if (code == 47 || code == 62 || code == 123 || code != Integer.MIN_VALUE && EcmaScriptIdentifiers.isStart(code)) {
                    effects.exit(tagNameType);
                    return this.beforeAttribute(code);
                }
                return (State)this.crash(code, "after local name", "a character that can start an attribute name, such as a letter, `$`, or `_`; whitespace before attributes; or the end of the tag");
            }

            State beforeAttribute(int code) {
                if (code == 47) {
                    effects.enter(tagSelfClosingMarker);
                    effects.consume(code);
                    effects.exit(tagSelfClosingMarker);
                    this.returnState = this::selfClosing;
                    return this::optionalEsWhitespace;
                }
                if (code == 62) {
                    return this.tagEnd(code);
                }
                if (code == 123) {
                    Assert.check(this.startPoint != null, "expected `startPoint` to be defined");
                    return FactoryMdxExpression.create(context, effects, this::afterAttributeExpression, tagExpressionAttributeType, tagExpressionAttributeMarkerType, tagExpressionAttributeValueType, allowLazy, this.startPoint.column()).step(code);
                }
                if (code != Integer.MIN_VALUE && EcmaScriptIdentifiers.isStart(code)) {
                    effects.enter(tagAttributeType);
                    effects.enter(tagAttributeNameType);
                    effects.enter(tagAttributeNamePrimaryType);
                    effects.consume(code);
                    return this::attributePrimaryName;
                }
                return (State)this.crash(code, "before attribute name", "a character that can start an attribute name, such as a letter, `$`, or `_`; whitespace before attributes; or the end of the tag");
            }

            State afterAttributeExpression(int code) {
                this.returnState = this::beforeAttribute;
                return this.optionalEsWhitespace(code);
            }

            State attributePrimaryName(int code) {
                if (code == 45 || code != Integer.MIN_VALUE && EcmaScriptIdentifiers.isCont(code)) {
                    effects.consume(code);
                    return this::attributePrimaryName;
                }
                if (code == 47 || code == 58 || code == 61 || code == 62 || code == 123 || CharUtil.markdownLineEndingOrSpace(code) || CharUtil.unicodeWhitespace(code)) {
                    effects.exit(tagAttributeNamePrimaryType);
                    this.returnState = this::afterAttributePrimaryName;
                    return this.optionalEsWhitespace(code);
                }
                return (State)this.crash(code, "in attribute name", "an attribute name character such as letters, digits, `$`, or `_`; `=` to initialize a value; whitespace before attributes; or the end of the tag");
            }

            State afterAttributePrimaryName(int code) {
                if (code == 58) {
                    effects.enter(tagAttributeNamePrefixMarkerType);
                    effects.consume(code);
                    effects.exit(tagAttributeNamePrefixMarkerType);
                    this.returnState = this::beforeAttributeLocalName;
                    return this::optionalEsWhitespace;
                }
                if (code == 61) {
                    effects.exit(tagAttributeNameType);
                    effects.enter(tagAttributeInitializerMarkerType);
                    effects.consume(code);
                    effects.exit(tagAttributeInitializerMarkerType);
                    this.returnState = this::beforeAttributeValue;
                    return this::optionalEsWhitespace;
                }
                if (code == 47 || code == 62 || code == 123 || CharUtil.markdownLineEndingOrSpace(code) || CharUtil.unicodeWhitespace(code) || code != Integer.MIN_VALUE && EcmaScriptIdentifiers.isStart(code)) {
                    effects.exit(tagAttributeNameType);
                    effects.exit(tagAttributeType);
                    this.returnState = this::beforeAttribute;
                    return this.optionalEsWhitespace(code);
                }
                return (State)this.crash(code, "after attribute name", "a character that can start an attribute name, such as a letter, `$`, or `_`; `=` to initialize a value; or the end of the tag");
            }

            State beforeAttributeLocalName(int code) {
                if (code != Integer.MIN_VALUE && EcmaScriptIdentifiers.isStart(code)) {
                    effects.enter(tagAttributeNameLocalType);
                    effects.consume(code);
                    return this::attributeLocalName;
                }
                return (State)this.crash(code, "before local attribute name", "a character that can start an attribute name, such as a letter, `$`, or `_`; `=` to initialize a value; or the end of the tag");
            }

            State attributeLocalName(int code) {
                if (code == 45 || code != Integer.MIN_VALUE && EcmaScriptIdentifiers.isCont(code)) {
                    effects.consume(code);
                    return this::attributeLocalName;
                }
                if (code == 47 || code == 61 || code == 62 || code == 123 || CharUtil.markdownLineEndingOrSpace(code) || CharUtil.unicodeWhitespace(code)) {
                    effects.exit(tagAttributeNameLocalType);
                    effects.exit(tagAttributeNameType);
                    this.returnState = this::afterAttributeLocalName;
                    return this.optionalEsWhitespace(code);
                }
                return (State)this.crash(code, "in local attribute name", "an attribute name character such as letters, digits, `$`, or `_`; `=` to initialize a value; whitespace before attributes; or the end of the tag");
            }

            State afterAttributeLocalName(int code) {
                if (code == 61) {
                    effects.enter(tagAttributeInitializerMarkerType);
                    effects.consume(code);
                    effects.exit(tagAttributeInitializerMarkerType);
                    this.returnState = this::beforeAttributeValue;
                    return this::optionalEsWhitespace;
                }
                if (code == 47 || code == 62 || code == 123 || code != Integer.MIN_VALUE && EcmaScriptIdentifiers.isStart(code)) {
                    effects.exit(tagAttributeType);
                    return this.beforeAttribute(code);
                }
                return (State)this.crash(code, "after local attribute name", "a character that can start an attribute name, such as a letter, `$`, or `_`; `=` to initialize a value; or the end of the tag");
            }

            State beforeAttributeValue(int code) {
                if (code == 34 || code == 39) {
                    effects.enter(tagAttributeValueLiteralType);
                    effects.enter(tagAttributeValueLiteralMarkerType);
                    effects.consume(code);
                    effects.exit(tagAttributeValueLiteralMarkerType);
                    this.marker = code;
                    return this::attributeValueQuotedStart;
                }
                if (code == 123) {
                    Assert.check(this.startPoint != null, "expected `startPoint` to be defined");
                    return FactoryMdxExpression.create(context, effects, this::afterAttributeValueExpression, tagAttributeValueExpressionType, tagAttributeValueExpressionMarkerType, tagAttributeValueExpressionValueType, allowLazy, this.startPoint.column()).step(code);
                }
                return (State)this.crash(code, "before attribute value", "a character that can start an attribute value, such as `\"`, `'`, or `{`" + (code == 60 ? " (note: to use an element or fragment as a prop value in MDX, use `{<element />}`)" : ""));
            }

            State afterAttributeValueExpression(int code) {
                effects.exit(tagAttributeType);
                this.returnState = this::beforeAttribute;
                return this.optionalEsWhitespace(code);
            }

            State attributeValueQuotedStart(int code) {
                Assert.check(this.marker != null, "expected `marker` to be defined");
                if (code == Integer.MIN_VALUE) {
                    this.crash(code, "in attribute value", "a corresponding closing quote `" + (char)this.marker.intValue() + "`");
                }
                if (code == this.marker) {
                    effects.enter(tagAttributeValueLiteralMarkerType);
                    effects.consume(code);
                    effects.exit(tagAttributeValueLiteralMarkerType);
                    effects.exit(tagAttributeValueLiteralType);
                    effects.exit(tagAttributeType);
                    this.marker = null;
                    this.returnState = this::beforeAttribute;
                    return this::optionalEsWhitespace;
                }
                if (CharUtil.markdownLineEnding(code)) {
                    this.returnState = this::attributeValueQuotedStart;
                    return this.optionalEsWhitespace(code);
                }
                effects.enter(tagAttributeValueLiteralValueType);
                return this.attributeValueQuoted(code);
            }

            State attributeValueQuoted(int code) {
                if (code == Integer.MIN_VALUE || code == this.marker || CharUtil.markdownLineEnding(code)) {
                    effects.exit(tagAttributeValueLiteralValueType);
                    return this.attributeValueQuotedStart(code);
                }
                effects.consume(code);
                return this::attributeValueQuoted;
            }

            private State selfClosing(int code) {
                if (code == 62) {
                    return this.tagEnd(code);
                }
                return (State)this.crash(code, "after self-closing slash", "`>` to end the tag" + (code == 42 || code == 47 ? " (note: JS comments in JSX tags are not supported in MDX)" : ""));
            }

            State tagEnd(int code) {
                Assert.check(code == 62, "expected `>`");
                effects.enter(tagMarkerType);
                effects.consume(code);
                effects.exit(tagMarkerType);
                effects.exit(tagType);
                return ok;
            }

            State optionalEsWhitespace(int code) {
                if (CharUtil.markdownLineEnding(code)) {
                    if (allowLazy) {
                        effects.enter("lineEnding");
                        effects.consume(code);
                        effects.exit("lineEnding");
                        return FactorySpace.create(effects, this::optionalEsWhitespace, "linePrefix", 4);
                    }
                    return effects.attempt.hook(lazyLineEnd, FactorySpace.create(effects, this::optionalEsWhitespace, "linePrefix", 4), this::crashEol).step(code);
                }
                if (CharUtil.markdownSpace(code) || CharUtil.unicodeWhitespace(code)) {
                    effects.enter("esWhitespace");
                    return this.optionalEsWhitespaceContinue(code);
                }
                return this.returnState.step(code);
            }

            State optionalEsWhitespaceContinue(int code) {
                if (CharUtil.markdownLineEnding(code) || !CharUtil.markdownSpace(code) && !CharUtil.unicodeWhitespace(code)) {
                    effects.exit("esWhitespace");
                    return this.optionalEsWhitespace(code);
                }
                effects.consume(code);
                return this::optionalEsWhitespaceContinue;
            }

            private State crashEol(int code) {
                throw new ParseException("Unexpected lazy line in container, expected line to be prefixed with `>` when in a block quote, whitespace when in a list, etc", context.now(), "micromark-extension-mdx-jsx:unexpected-eof");
            }

            private <T> T crash(int code, String at, String expect) {
                throw new ParseException("Unexpected " + (String)(code == Integer.MIN_VALUE ? "end of file" : "character `" + (code == 96 ? "` ` `" : String.valueOf((char)code)) + "` (" + FactoryTag.serializeCharCode(code) + ")") + " " + at + ", expected " + expect, context.now(), "micromark-extension-mdx-jsx:unexpected-" + (code == Integer.MIN_VALUE ? "eof" : "character"));
            }
        }
        return new StateMachine()::start;
    }

    private static State tokenizeLazyLineEnd(final TokenizeContext context, final Tokenizer.Effects effects, final State ok, final State nok) {
        class StateMachine {
            StateMachine() {
            }

            State start(int code) {
                Assert.check(CharUtil.markdownLineEnding(code), "expected eol");
                effects.enter("lineEnding");
                effects.consume(code);
                effects.exit("lineEnding");
                return this::lineStart;
            }

            private State lineStart(int code) {
                return context.isOnLazyLine() ? nok.step(code) : ok.step(code);
            }
        }
        return new StateMachine()::start;
    }

    private static String serializeCharCode(int code) {
        return String.format(Locale.ROOT, "U+%04X", code);
    }

    static {
        FactoryTag.lazyLineEnd.tokenize = FactoryTag::tokenizeLazyLineEnd;
        FactoryTag.lazyLineEnd.partial = true;
    }
}

