/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.browser;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.element.elements.browser.BrowserEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.browser.BrowserElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrowserElementBuilder
extends ElementBuilder<BrowserElement, BrowserEditorElement> {
    private static final Logger LOGGER = LogManager.getLogger();

    public BrowserElementBuilder() {
        super("browser");
    }

    @Override
    @NotNull
    public BrowserElement buildDefaultInstance() {
        BrowserElement i = new BrowserElement(this);
        i.baseWidth = 250;
        i.baseHeight = 250;
        return i;
    }

    @Override
    public BrowserElement deserializeElement(@NotNull SerializedElement serialized) {
        BrowserElement element = this.buildDefaultInstance();
        element.url = Objects.requireNonNullElse(serialized.getValue("url"), element.url);
        element.interactable = this.deserializeBoolean(element.interactable, serialized.getValue("interactable"));
        element.hideVideoControls = this.deserializeBoolean(element.hideVideoControls, serialized.getValue("hide_video_controls"));
        element.loopVideos = this.deserializeBoolean(element.loopVideos, serialized.getValue("loop_videos"));
        element.muteMedia = this.deserializeBoolean(element.muteMedia, serialized.getValue("mute_media"));
        element.mediaVolume = this.deserializeNumber(Float.class, Float.valueOf(element.mediaVolume), serialized.getValue("media_volume")).floatValue();
        return element;
    }

    @Override
    protected SerializedElement serializeElement(@NotNull BrowserElement element, @NotNull SerializedElement serializeTo) {
        serializeTo.putProperty("url", element.url);
        serializeTo.putProperty("interactable", "" + element.interactable);
        serializeTo.putProperty("hide_video_controls", "" + element.hideVideoControls);
        serializeTo.putProperty("loop_videos", "" + element.loopVideos);
        serializeTo.putProperty("mute_media", "" + element.muteMedia);
        serializeTo.putProperty("media_volume", "" + element.mediaVolume);
        return serializeTo;
    }

    @Override
    @NotNull
    public BrowserEditorElement wrapIntoEditorElement(@NotNull BrowserElement element, @NotNull LayoutEditorScreen editor) {
        return new BrowserEditorElement(element, editor);
    }

    @Override
    @NotNull
    public Component getDisplayName(@Nullable AbstractElement element) {
        return Component.translatable((String)"fancymenu.elements.browser");
    }

    @Override
    @Nullable
    public Component[] getDescription(@Nullable AbstractElement element) {
        return LocalizationUtils.splitLocalizedLines("fancymenu.elements.browser.desc", new String[0]);
    }
}

