/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout;

import com.google.common.io.Files;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.action.blocks.AbstractExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.ExecutableBlockDeserializer;
import de.keksuccino.fancymenu.customization.action.blocks.GenericExecutableBlock;
import de.keksuccino.fancymenu.customization.background.MenuBackground;
import de.keksuccino.fancymenu.customization.background.MenuBackgroundBuilder;
import de.keksuccino.fancymenu.customization.background.MenuBackgroundRegistry;
import de.keksuccino.fancymenu.customization.background.SerializedMenuBackground;
import de.keksuccino.fancymenu.customization.background.backgrounds.image.ImageMenuBackground;
import de.keksuccino.fancymenu.customization.background.backgrounds.panorama.PanoramaMenuBackground;
import de.keksuccino.fancymenu.customization.background.backgrounds.slideshow.SlideshowMenuBackground;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.ElementRegistry;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.element.anchor.ElementAnchorPoints;
import de.keksuccino.fancymenu.customization.element.elements.Elements;
import de.keksuccino.fancymenu.customization.element.elements.button.custombutton.ButtonElement;
import de.keksuccino.fancymenu.customization.element.elements.button.vanillawidget.VanillaWidgetElement;
import de.keksuccino.fancymenu.customization.element.elements.button.vanillawidget.VanillaWidgetElementBuilder;
import de.keksuccino.fancymenu.customization.element.elements.image.ImageElement;
import de.keksuccino.fancymenu.customization.element.elements.shape.ShapeElement;
import de.keksuccino.fancymenu.customization.element.elements.slideshow.SlideshowElement;
import de.keksuccino.fancymenu.customization.element.elements.splash.SplashTextElement;
import de.keksuccino.fancymenu.customization.layout.LayoutBase;
import de.keksuccino.fancymenu.customization.layout.LayoutHandler;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.customization.panorama.PanoramaHandler;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.customization.slideshow.SlideshowHandler;
import de.keksuccino.fancymenu.util.ListUtils;
import de.keksuccino.fancymenu.util.SerializationUtils;
import de.keksuccino.fancymenu.util.enums.LocalizedCycleEnum;
import de.keksuccino.fancymenu.util.file.GameDirectoryUtils;
import de.keksuccino.fancymenu.util.properties.PropertyContainer;
import de.keksuccino.fancymenu.util.properties.PropertyContainerSet;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.konkrete.math.MathUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Style;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Layout
extends LayoutBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String UNIVERSAL_LAYOUT_IDENTIFIER = "%fancymenu:universal_layout%";
    @Nullable
    public String screenIdentifier;
    public File layoutFile;
    public long lastEditedTime = -1L;
    protected boolean enabled = true;
    public int layoutIndex = 0;
    public boolean renderElementsBehindVanilla = false;
    public boolean randomMode = false;
    public String randomGroup = "1";
    public boolean randomOnlyFirstTime = false;
    public List<String> universalLayoutMenuWhitelist = new ArrayList<String>();
    public List<String> universalLayoutMenuBlacklist = new ArrayList<String>();
    public LoadingRequirementContainer layoutWideLoadingRequirementContainer = new LoadingRequirementContainer();
    public List<SerializedElement> serializedElements = new ArrayList<SerializedElement>();
    public List<SerializedElement> serializedVanillaButtonElements = new ArrayList<SerializedElement>();
    public List<SerializedElement> serializedDeepElements = new ArrayList<SerializedElement>();
    public boolean legacyLayout = false;

    @NotNull
    public static Layout buildUniversal() {
        return new Layout();
    }

    @NotNull
    public static Layout buildForScreen(@NotNull Screen screen) {
        return new Layout(screen);
    }

    @NotNull
    public static Layout buildForScreen(@NotNull String screenIdentifier) {
        return new Layout(screenIdentifier);
    }

    public Layout() {
        this.setToUniversalLayout();
    }

    public Layout(@NotNull Screen screen) {
        this.screenIdentifier = ScreenIdentifierHandler.getIdentifierOfScreen(screen);
    }

    public Layout(@NotNull String screenIdentifier) {
        this.setScreenIdentifier(screenIdentifier);
    }

    @NotNull
    public PropertyContainerSet serialize() {
        SerializedMenuBackground serializedMenuBackground;
        PropertyContainer ps;
        Objects.requireNonNull(this.screenIdentifier);
        PropertyContainerSet set = new PropertyContainerSet("fancymenu_layout");
        PropertyContainer meta = new PropertyContainer("layout-meta");
        set.putContainer(meta);
        meta.putProperty("identifier", this.screenIdentifier);
        meta.putProperty("render_custom_elements_behind_vanilla", "" + this.renderElementsBehindVanilla);
        meta.putProperty("last_edited_time", "" + this.lastEditedTime);
        meta.putProperty("is_enabled", "" + this.enabled);
        meta.putProperty("randommode", "" + this.randomMode);
        meta.putProperty("randomgroup", this.randomGroup);
        meta.putProperty("randomonlyfirsttime", "" + this.randomOnlyFirstTime);
        meta.putProperty("layout_index", "" + this.layoutIndex);
        if (!this.universalLayoutMenuWhitelist.isEmpty()) {
            Object wl = "";
            for (String s : this.universalLayoutMenuWhitelist) {
                wl = (String)wl + s + ";";
            }
            meta.putProperty("universal_layout_whitelist", (String)wl);
        }
        if (!this.universalLayoutMenuBlacklist.isEmpty()) {
            Object bl = "";
            for (String s : this.universalLayoutMenuBlacklist) {
                bl = (String)bl + s + ";";
            }
            meta.putProperty("universal_layout_blacklist", (String)bl);
        }
        if (this.customMenuTitle != null) {
            meta.putProperty("custom_menu_title", this.customMenuTitle);
        }
        if (this.forcedScale != 0.0f) {
            ps = new PropertyContainer("customization");
            ps.putProperty("action", "setscale");
            ps.putProperty("scale", "" + this.forcedScale);
            set.putContainer(ps);
        }
        if (this.autoScalingWidth != 0 && this.autoScalingHeight != 0) {
            ps = new PropertyContainer("customization");
            ps.putProperty("action", "autoscale");
            ps.putProperty("basewidth", "" + this.autoScalingWidth);
            ps.putProperty("baseheight", "" + this.autoScalingHeight);
            set.putContainer(ps);
        }
        if (!this.menuBackgrounds.isEmpty() && (serializedMenuBackground = ((MenuBackground)this.menuBackgrounds.getFirst()).builder.serializedBackgroundInternal((MenuBackground)this.menuBackgrounds.getFirst())) != null) {
            set.putContainer(serializedMenuBackground);
        }
        if (this.openAudio != null) {
            ps = new PropertyContainer("customization");
            ps.putProperty("action", "setopenaudio");
            ps.putProperty("path", this.openAudio.getSourceWithPrefix());
            set.putContainer(ps);
        }
        if (this.closeAudio != null) {
            ps = new PropertyContainer("customization");
            ps.putProperty("action", "setcloseaudio");
            ps.putProperty("path", this.closeAudio.getSourceWithPrefix());
            set.putContainer(ps);
        }
        PropertyContainer s = new PropertyContainer("customization");
        s.putProperty("action", "backgroundoptions");
        s.putProperty("keepaspectratio", "" + this.preserveBackgroundAspectRatio);
        set.putContainer(s);
        PropertyContainer scrollListContainer = new PropertyContainer("scroll_list_customization");
        scrollListContainer.putProperty("preserve_scroll_list_header_footer_aspect_ratio", "" + this.preserveScrollListHeaderFooterAspectRatio);
        if (this.scrollListHeaderTexture != null) {
            scrollListContainer.putProperty("scroll_list_header_texture", this.scrollListHeaderTexture.getSourceWithPrefix());
        }
        if (this.scrollListFooterTexture != null) {
            scrollListContainer.putProperty("scroll_list_footer_texture", this.scrollListFooterTexture.getSourceWithPrefix());
        }
        scrollListContainer.putProperty("render_scroll_list_header_shadow", "" + this.renderScrollListHeaderShadow);
        scrollListContainer.putProperty("render_scroll_list_footer_shadow", "" + this.renderScrollListFooterShadow);
        scrollListContainer.putProperty("show_scroll_list_header_footer_preview_in_editor", "" + this.showScrollListHeaderFooterPreviewInEditor);
        scrollListContainer.putProperty("repeat_scroll_list_header_texture", "" + this.repeatScrollListHeaderTexture);
        scrollListContainer.putProperty("repeat_scroll_list_footer_texture", "" + this.repeatScrollListFooterTexture);
        scrollListContainer.putProperty("show_screen_background_overlay_on_custom_background", "" + this.showScreenBackgroundOverlayOnCustomBackground);
        scrollListContainer.putProperty("apply_vanilla_background_blur", "" + this.applyVanillaBackgroundBlur);
        set.putContainer(scrollListContainer);
        PropertyContainer executableBlocks = new PropertyContainer("layout_action_executable_blocks");
        if (!this.openScreenExecutableBlocks.isEmpty()) {
            executableBlocks.putProperty("open_screen_executable_block_identifier", ((GenericExecutableBlock)this.openScreenExecutableBlocks.getFirst()).identifier);
            ((GenericExecutableBlock)this.openScreenExecutableBlocks.getFirst()).serializeToExistingPropertyContainer(executableBlocks);
        }
        if (!this.closeScreenExecutableBlocks.isEmpty()) {
            executableBlocks.putProperty("close_screen_executable_block_identifier", ((GenericExecutableBlock)this.closeScreenExecutableBlocks.getFirst()).identifier);
            ((GenericExecutableBlock)this.closeScreenExecutableBlocks.getFirst()).serializeToExistingPropertyContainer(executableBlocks);
        }
        set.putContainer(executableBlocks);
        this.layoutWideLoadingRequirementContainer.serializeToExistingPropertyContainer(meta);
        this.serializedElements.forEach(set::putContainer);
        if (!this.isUniversalLayout()) {
            this.serializedVanillaButtonElements.forEach(set::putContainer);
            this.serializedDeepElements.forEach(set::putContainer);
        }
        return set;
    }

    @Nullable
    public static Layout deserialize(@NotNull PropertyContainerSet serialized, @Nullable File layoutFile) {
        if (serialized.getType().equalsIgnoreCase("menu") || serialized.getType().equalsIgnoreCase("fancymenu_layout")) {
            PropertyContainer executableBlocks;
            PropertyContainer scrollListCustomizations;
            MenuBackground legacyBackground;
            Object back;
            MenuBackgroundBuilder<?> builder;
            PropertyContainer menuBack;
            String backgroundIdentifier;
            List<PropertyContainer> menuBackgroundSections;
            String elementType;
            Layout layout = new Layout();
            layout.layoutFile = layoutFile;
            layout.legacyLayout = serialized.getType().equalsIgnoreCase("menu");
            PropertyContainer meta = serialized.getFirstContainerOfType("layout-meta");
            if (meta == null) {
                meta = serialized.getFirstContainerOfType("customization-meta");
            }
            if (meta != null) {
                String legacyRenderingOrder;
                String isEnabled;
                String lastEdited;
                layout.setScreenIdentifier(meta.getValue("identifier"));
                layout.layoutIndex = SerializationUtils.deserializeNumber(Integer.class, layout.layoutIndex, meta.getValue("layout_index"));
                Iterator<PropertyContainer> defaultRandomLayoutGroup = "-100397";
                String randomMode = meta.getValue("randommode");
                if (randomMode != null && randomMode.equalsIgnoreCase("true")) {
                    String randomOnlyFirstTime;
                    layout.randomMode = true;
                    layout.randomGroup = meta.getValue("randomgroup");
                    if (layout.randomGroup == null) {
                        layout.randomGroup = defaultRandomLayoutGroup;
                    }
                    if ((randomOnlyFirstTime = meta.getValue("randomonlyfirsttime")) != null && randomOnlyFirstTime.equalsIgnoreCase("true")) {
                        layout.randomOnlyFirstTime = true;
                    }
                }
                if ((lastEdited = meta.getValue("last_edited_time")) != null && MathUtils.isLong((String)lastEdited)) {
                    layout.lastEditedTime = Long.parseLong(lastEdited);
                }
                if (lastEdited == null && layout.legacyLayout) {
                    layout.lastEditedTime = System.currentTimeMillis();
                }
                if ((isEnabled = meta.getValue("is_enabled")) != null && isEnabled.equals("false")) {
                    layout.enabled = false;
                }
                layout.customMenuTitle = meta.getValue("custom_menu_title");
                layout.layoutWideLoadingRequirementContainer = LoadingRequirementContainer.deserializeToSingleContainer(meta);
                String renderBehindVanilla = meta.getValue("render_custom_elements_behind_vanilla");
                if (renderBehindVanilla == null && (legacyRenderingOrder = meta.getValue("renderorder")) != null && legacyRenderingOrder.equals("background")) {
                    renderBehindVanilla = "true";
                }
                if (renderBehindVanilla != null && renderBehindVanilla.equals("true")) {
                    layout.renderElementsBehindVanilla = true;
                }
                if (layout.isUniversalLayout()) {
                    Iterator whitelistRaw = meta.getValue("universal_layout_whitelist");
                    String blacklistRaw = meta.getValue("universal_layout_blacklist");
                    if (whitelistRaw != null && ((String)((Object)whitelistRaw)).contains(";")) {
                        for (String string : ((String)((Object)whitelistRaw)).split(";")) {
                            if (string.length() <= 0) continue;
                            layout.universalLayoutMenuWhitelist.add(ScreenIdentifierHandler.getBestIdentifier(string));
                        }
                    }
                    if (blacklistRaw != null && blacklistRaw.contains(";")) {
                        for (String string : blacklistRaw.split(";")) {
                            if (string.length() <= 0) continue;
                            layout.universalLayoutMenuBlacklist.add(ScreenIdentifierHandler.getBestIdentifier(string));
                        }
                    }
                }
            }
            for (PropertyContainer c : serialized.getContainersOfType("deep_element")) {
                elementType = c.getValue("element_type");
                boolean hidden = SerializationUtils.deserializeBoolean(false, c.getValue("is_hidden"));
                if (!hidden) continue;
                PropertyContainer dummy = new PropertyContainer("vanilla_button");
                dummy.putProperty("element_type", "vanilla_button");
                dummy.putProperty("is_hidden", "true");
                if ("title_screen_logo".equals(elementType)) {
                    dummy.putProperty("instance_identifier", "minecraft_logo_widget");
                }
                if ("title_screen_branding".equals(elementType)) {
                    dummy.putProperty("instance_identifier", "minecraft_branding_widget");
                }
                if ("title_screen_splash".equals(elementType)) {
                    dummy.putProperty("instance_identifier", "minecraft_splash_widget");
                }
                if ("title_screen_realms_notification".equals(elementType)) {
                    dummy.putProperty("instance_identifier", "minecraft_realms_notification_icons_widget");
                }
                serialized.putContainer(dummy);
            }
            for (PropertyContainer sec : serialized.getContainersOfType("vanilla_button")) {
                SerializedElement serializedVanilla = Layout.convertContainerToSerializedElement(sec);
                serializedVanilla.setType("vanilla_button");
                layout.serializedVanillaButtonElements.add(serializedVanilla);
            }
            if (layout.legacyLayout) {
                layout.serializedVanillaButtonElements.addAll(Layout.convertLegacyVanillaButtonCustomizations(serialized));
            }
            for (PropertyContainer sec : ListUtils.mergeLists(serialized.getContainersOfType("element"), serialized.getContainersOfType("customization"))) {
                elementType = sec.getValue("element_type");
                if (elementType == null) {
                    elementType = sec.getValue("action");
                }
                if (elementType == null || !ElementRegistry.hasBuilder(elementType = elementType.replace("custom_layout_element:", ""))) continue;
                SerializedElement e = Layout.convertContainerToSerializedElement(sec);
                e.putProperty("element_type", elementType);
                layout.serializedElements.add(e);
            }
            if (layout.legacyLayout) {
                List<List<?>> elementsAndOrder = Layout.convertLegacyElements(serialized);
                ArrayList<SerializedElement> normalElements = new ArrayList<SerializedElement>(layout.serializedElements);
                List<?> legacyElements = elementsAndOrder.get(0);
                ArrayList<SerializedElement> combined = new ArrayList<SerializedElement>();
                List<?> elementOrder = elementsAndOrder.get(1);
                for (String identifier : elementOrder) {
                    for (SerializedElement s : normalElements) {
                        String actionId = s.getValue("actionid");
                        if (actionId == null) {
                            actionId = s.getValue("instance_identifier");
                        }
                        if (actionId == null || !actionId.equals(identifier)) continue;
                        combined.add(s);
                    }
                    for (SerializedElement e : legacyElements) {
                        String actionId = e.getValue("actionid");
                        if (actionId == null) {
                            actionId = e.getValue("instance_identifier");
                        }
                        if (actionId == null || !actionId.equals(identifier)) continue;
                        combined.add(e);
                    }
                }
                for (SerializedElement e : normalElements) {
                    if (combined.contains(e)) continue;
                    combined.add(e);
                }
                layout.serializedElements.clear();
                layout.serializedElements.addAll(combined);
            }
            if (!(menuBackgroundSections = serialized.getContainersOfType("menu_background")).isEmpty() && (backgroundIdentifier = (menuBack = menuBackgroundSections.getFirst()).getValue("background_type")) != null && (builder = MenuBackgroundRegistry.getBuilder(backgroundIdentifier)) != null && (back = builder.deserializeBackgroundInternal(Layout.convertSectionToBackground(menuBack))) != null && layout.menuBackgrounds.isEmpty()) {
                layout.menuBackgrounds.add(back);
            }
            if (layout.legacyLayout && (legacyBackground = Layout.convertLegacyMenuBackground(serialized)) != null && layout.menuBackgrounds.isEmpty()) {
                layout.menuBackgrounds.add(legacyBackground);
            }
            if ((scrollListCustomizations = serialized.getFirstContainerOfType("scroll_list_customization")) != null) {
                String showListHeaderFooter;
                String renderScrollFooterShadow;
                String preserveScrollHeaderFooterAspect = scrollListCustomizations.getValue("preserve_scroll_list_header_footer_aspect_ratio");
                if (preserveScrollHeaderFooterAspect != null) {
                    if (preserveScrollHeaderFooterAspect.equals("true")) {
                        layout.preserveScrollListHeaderFooterAspectRatio = true;
                    }
                    if (preserveScrollHeaderFooterAspect.equals("false")) {
                        layout.preserveScrollListHeaderFooterAspectRatio = false;
                    }
                }
                layout.scrollListHeaderTexture = SerializationUtils.deserializeImageResourceSupplier(scrollListCustomizations.getValue("scroll_list_header_texture"));
                layout.scrollListFooterTexture = SerializationUtils.deserializeImageResourceSupplier(scrollListCustomizations.getValue("scroll_list_footer_texture"));
                String renderScrollHeaderShadow = scrollListCustomizations.getValue("render_scroll_list_header_shadow");
                if (renderScrollHeaderShadow != null) {
                    if (renderScrollHeaderShadow.equals("true")) {
                        layout.renderScrollListHeaderShadow = true;
                    }
                    if (renderScrollHeaderShadow.equals("false")) {
                        layout.renderScrollListHeaderShadow = false;
                    }
                }
                if ((renderScrollFooterShadow = scrollListCustomizations.getValue("render_scroll_list_footer_shadow")) != null) {
                    if (renderScrollFooterShadow.equals("true")) {
                        layout.renderScrollListFooterShadow = true;
                    }
                    if (renderScrollFooterShadow.equals("false")) {
                        layout.renderScrollListFooterShadow = false;
                    }
                }
                if ((showListHeaderFooter = scrollListCustomizations.getValue("show_scroll_list_header_footer_preview_in_editor")) != null) {
                    if (showListHeaderFooter.equals("true")) {
                        layout.showScrollListHeaderFooterPreviewInEditor = true;
                    }
                    if (showListHeaderFooter.equals("false")) {
                        layout.showScrollListHeaderFooterPreviewInEditor = false;
                    }
                }
                layout.showScreenBackgroundOverlayOnCustomBackground = SerializationUtils.deserializeBoolean(layout.showScreenBackgroundOverlayOnCustomBackground, scrollListCustomizations.getValue("show_screen_background_overlay_on_custom_background"));
                layout.repeatScrollListHeaderTexture = SerializationUtils.deserializeBoolean(layout.repeatScrollListHeaderTexture, scrollListCustomizations.getValue("repeat_scroll_list_header_texture"));
                layout.repeatScrollListFooterTexture = SerializationUtils.deserializeBoolean(layout.repeatScrollListFooterTexture, scrollListCustomizations.getValue("repeat_scroll_list_footer_texture"));
                layout.applyVanillaBackgroundBlur = SerializationUtils.deserializeBoolean(layout.applyVanillaBackgroundBlur, scrollListCustomizations.getValue("apply_vanilla_background_blur"));
            }
            if ((executableBlocks = serialized.getFirstContainerOfType("layout_action_executable_blocks")) != null) {
                AbstractExecutableBlock b;
                String closeScreenExecutableBlockId;
                AbstractExecutableBlock b2;
                String openScreenExecutableBlockId = executableBlocks.getValue("open_screen_executable_block_identifier");
                if (openScreenExecutableBlockId != null && (b2 = ExecutableBlockDeserializer.deserializeWithIdentifier(executableBlocks, openScreenExecutableBlockId)) instanceof GenericExecutableBlock) {
                    GenericExecutableBlock g = (GenericExecutableBlock)b2;
                    layout.openScreenExecutableBlocks.clear();
                    layout.openScreenExecutableBlocks.add(g);
                }
                if ((closeScreenExecutableBlockId = executableBlocks.getValue("close_screen_executable_block_identifier")) != null && (b = ExecutableBlockDeserializer.deserializeWithIdentifier(executableBlocks, closeScreenExecutableBlockId)) instanceof GenericExecutableBlock) {
                    GenericExecutableBlock g = (GenericExecutableBlock)b;
                    layout.closeScreenExecutableBlocks.clear();
                    layout.closeScreenExecutableBlocks.add(g);
                }
            }
            for (PropertyContainer sec : serialized.getContainersOfType("customization")) {
                String keepAspect;
                String scale;
                String action = sec.getValue("action");
                if (action != null && action.equals("setscale") && (scale = sec.getValue("scale")) != null && (MathUtils.isInteger((String)scale.replace(" ", "")) || MathUtils.isDouble((String)scale.replace(" ", "")))) {
                    int newscale = (int)Double.parseDouble(scale.replace(" ", ""));
                    if (newscale <= 0) {
                        newscale = 1;
                    }
                    layout.forcedScale = newscale;
                }
                if (action != null && action.equals("autoscale")) {
                    String baseHeight;
                    String baseWidth = sec.getValue("basewidth");
                    if (MathUtils.isInteger((String)baseWidth)) {
                        layout.autoScalingWidth = Integer.parseInt(Objects.requireNonNull(baseWidth));
                    }
                    if (MathUtils.isInteger((String)(baseHeight = sec.getValue("baseheight")))) {
                        layout.autoScalingHeight = Integer.parseInt(Objects.requireNonNull(baseHeight));
                    }
                }
                if (action != null && action.equalsIgnoreCase("backgroundoptions") && (keepAspect = sec.getValue("keepaspectratio")) != null && keepAspect.equalsIgnoreCase("true")) {
                    layout.preserveBackgroundAspectRatio = true;
                }
                if (action != null && action.equalsIgnoreCase("setcloseaudio")) {
                    layout.closeAudio = SerializationUtils.deserializeAudioResourceSupplier(sec.getValue("path"));
                }
                if (action == null || !action.equalsIgnoreCase("setopenaudio")) continue;
                layout.openAudio = SerializationUtils.deserializeAudioResourceSupplier(sec.getValue("path"));
            }
            return layout;
        }
        return null;
    }

    public boolean saveToFileIfPossible() {
        if (this.layoutFile != null) {
            return LayoutHandler.saveLayoutToFile(this, GameDirectoryUtils.getAbsoluteGameDirectoryPath(this.layoutFile.getAbsolutePath()));
        }
        return false;
    }

    public Layout updateLastEditedTime() {
        this.lastEditedTime = System.currentTimeMillis();
        return this;
    }

    public Layout setScreenIdentifier(String screenIdentifier) {
        if (screenIdentifier != null) {
            if (screenIdentifier.equals(UNIVERSAL_LAYOUT_IDENTIFIER)) {
                return this.setToUniversalLayout();
            }
            this.screenIdentifier = ScreenIdentifierHandler.getBestIdentifier(screenIdentifier);
        }
        return this;
    }

    public boolean isUniversalLayout() {
        return this.screenIdentifier != null && this.screenIdentifier.equals(UNIVERSAL_LAYOUT_IDENTIFIER);
    }

    public Layout setToUniversalLayout() {
        this.screenIdentifier = UNIVERSAL_LAYOUT_IDENTIFIER;
        return this;
    }

    @NotNull
    public String getLayoutName() {
        if (this.layoutFile != null) {
            return Files.getNameWithoutExtension((String)this.layoutFile.getPath());
        }
        return "Nameless Layout";
    }

    public LayoutStatus getStatus() {
        return this.isEnabled() ? LayoutStatus.ENABLED : LayoutStatus.DISABLED;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Layout setEnabled(boolean enabled, boolean reInitCurrentScreen) {
        this.enabled = enabled;
        this.saveToFileIfPossible();
        if (reInitCurrentScreen) {
            ScreenCustomization.reInitCurrentScreen();
        }
        return this;
    }

    public void delete(boolean reInitCurrentScreen) {
        LayoutHandler.deleteLayout(this, reInitCurrentScreen);
    }

    public boolean layoutWideLoadingRequirementsMet() {
        if (this.layoutWideLoadingRequirementContainer != null) {
            return this.layoutWideLoadingRequirementContainer.requirementsMet();
        }
        return true;
    }

    @NotNull
    public OrderedElementCollection buildElementInstances() {
        OrderedElementCollection collection = new OrderedElementCollection();
        for (SerializedElement serialized : this.serializedElements) {
            Object element;
            ElementBuilder<?, ?> builder;
            String elementType = serialized.getValue("element_type");
            if (elementType == null || (builder = ElementRegistry.getBuilder(elementType)) == null || (element = builder.deserializeElementInternal(serialized)) == null) continue;
            ((AbstractElement)element).setParentLayout(this);
            if (this.renderElementsBehindVanilla) {
                collection.backgroundElements.add((AbstractElement)element);
                continue;
            }
            collection.foregroundElements.add((AbstractElement)element);
        }
        return collection;
    }

    @NotNull
    public List<VanillaWidgetElement> buildVanillaButtonElementInstances() {
        ArrayList<VanillaWidgetElement> elements = new ArrayList<VanillaWidgetElement>();
        for (SerializedElement serialized : this.serializedVanillaButtonElements) {
            VanillaWidgetElement element = VanillaWidgetElementBuilder.INSTANCE.deserializeElementInternal(serialized);
            if (element == null) continue;
            element.setParentLayout(this);
            elements.add(element);
        }
        return elements;
    }

    @NotNull
    public Layout copy() {
        return Objects.requireNonNull(Layout.deserialize(this.serialize(), this.layoutFile));
    }

    @NotNull
    protected static List<List<?>> convertLegacyElements(PropertyContainerSet layout) {
        ArrayList<SerializedElement> elements = new ArrayList<SerializedElement>();
        ArrayList<String> elementOrder = new ArrayList<String>();
        for (PropertyContainer sec : layout.getContainersOfType("customization")) {
            String baseColor;
            String vanillaLikeString;
            String path;
            AbstractElement e;
            String identifier;
            String action = sec.getValue("action");
            if (action == null) continue;
            if (action.startsWith("custom_layout_element:") && (identifier = sec.getValue("actionid")) != null) {
                elementOrder.add(identifier);
            }
            if (action.equalsIgnoreCase("addtexture") && (e = (ImageElement)Elements.IMAGE.deserializeElementInternal(Layout.convertContainerToSerializedElement(sec))) != null) {
                ((ImageElement)e).stayOnScreen = false;
                ((ImageElement)e).textureSupplier = SerializationUtils.deserializeImageResourceSupplier(sec.getValue("path"));
                elements.add(Elements.IMAGE.serializeElementInternal(e));
                elementOrder.add(e.getInstanceIdentifier());
            }
            if (action.equalsIgnoreCase("addwebtexture") && (e = (ImageElement)Elements.IMAGE.deserializeElementInternal(Layout.convertContainerToSerializedElement(sec))) != null) {
                ((ImageElement)e).stayOnScreen = false;
                ((ImageElement)e).textureSupplier = SerializationUtils.deserializeImageResourceSupplier(sec.getValue("url"));
                elements.add(Elements.IMAGE.serializeElementInternal(e));
                elementOrder.add(e.getInstanceIdentifier());
            }
            if (action.equalsIgnoreCase("addshape") && (e = (ShapeElement)Elements.SHAPE.deserializeElementInternal(Layout.convertContainerToSerializedElement(sec))) != null) {
                ((ShapeElement)e).stayOnScreen = false;
                String c = sec.getValue("color");
                if (c != null) {
                    ((ShapeElement)e).color = DrawableColor.of(c);
                }
                elements.add(Elements.SHAPE.serializeElementInternal(e));
                elementOrder.add(e.getInstanceIdentifier());
            }
            if (action.equalsIgnoreCase("addslideshow") && (e = (SlideshowElement)Elements.SLIDESHOW.deserializeElementInternal(Layout.convertContainerToSerializedElement(sec))) != null) {
                ((SlideshowElement)e).stayOnScreen = false;
                ((SlideshowElement)e).slideshowName = sec.getValue("name");
                elements.add(Elements.SLIDESHOW.serializeElementInternal(e));
                elementOrder.add(e.getInstanceIdentifier());
            }
            if (action.equalsIgnoreCase("addbutton") && (e = (ButtonElement)Elements.BUTTON.deserializeElementInternal(Layout.convertContainerToSerializedElement(sec))) != null) {
                ((ButtonElement)e).stayOnScreen = false;
                elements.add(Elements.BUTTON.serializeElementInternal(e));
                elementOrder.add(e.getInstanceIdentifier());
            }
            if (!action.equalsIgnoreCase("addsplash") || (e = (SplashTextElement)Elements.SPLASH_TEXT.deserializeElementInternal(Layout.convertContainerToSerializedElement(sec))) == null) continue;
            String text = sec.getValue("text");
            if (text != null) {
                ((SplashTextElement)e).source = text;
                ((SplashTextElement)e).sourceMode = SplashTextElement.SourceMode.DIRECT_TEXT;
            }
            if ((path = sec.getValue("splashfilepath")) != null) {
                ((SplashTextElement)e).source = path;
                ((SplashTextElement)e).sourceMode = SplashTextElement.SourceMode.TEXT_FILE;
            }
            if ((vanillaLikeString = sec.getValue("vanilla-like")) != null && vanillaLikeString.equals("true")) {
                ((SplashTextElement)e).source = null;
                ((SplashTextElement)e).sourceMode = SplashTextElement.SourceMode.VANILLA;
            }
            if ((baseColor = sec.getValue("basecolor")) != null) {
                ((SplashTextElement)e).baseColor = DrawableColor.of(baseColor);
            }
            ((SplashTextElement)e).stayOnScreen = false;
            elements.add(Elements.SPLASH_TEXT.serializeElementInternal(e));
            elementOrder.add(e.getInstanceIdentifier());
        }
        return List.of(elements, elementOrder);
    }

    @Nullable
    protected static MenuBackground convertLegacyMenuBackground(PropertyContainerSet layout) {
        for (PropertyContainer sec : layout.getContainersOfType("customization")) {
            MenuBackgroundBuilder<ImageMenuBackground> builder;
            MenuBackground b;
            MenuBackgroundBuilder<SlideshowMenuBackground> builder2;
            String name;
            String action = sec.getValue("action");
            if (action == null) continue;
            if (action.equalsIgnoreCase("setbackgroundslideshow") && (name = sec.getValue("name")) != null && SlideshowHandler.slideshowExists(name) && (builder2 = MenuBackgroundRegistry.getBuilder("slideshow")) != null) {
                b = new SlideshowMenuBackground(builder2);
                b.slideshowName = name;
                return b;
            }
            if (action.equalsIgnoreCase("setbackgroundpanorama") && (name = sec.getValue("name")) != null && PanoramaHandler.panoramaExists(name) && (builder2 = MenuBackgroundRegistry.getBuilder("panorama")) != null) {
                b = new PanoramaMenuBackground((MenuBackgroundBuilder<PanoramaMenuBackground>)builder2);
                ((PanoramaMenuBackground)b).panoramaName = name;
                return b;
            }
            if (!action.equalsIgnoreCase("texturizebackground")) continue;
            String value = AbstractElement.fixBackslashPath(sec.getValue("path"));
            String pano = sec.getValue("wideformat");
            if (value == null || (builder = MenuBackgroundRegistry.getBuilder("image")) == null) continue;
            ImageMenuBackground b2 = new ImageMenuBackground(builder);
            b2.textureSupplier = SerializationUtils.deserializeImageResourceSupplier(value);
            b2.slideLeftRight = pano != null && pano.equalsIgnoreCase("true");
            return b2;
        }
        return null;
    }

    @NotNull
    protected static List<SerializedElement> convertLegacyVanillaButtonCustomizations(PropertyContainerSet layout) {
        HashMap<String, VanillaWidgetElement> elements = new HashMap<String, VanillaWidgetElement>();
        for (PropertyContainer sec : layout.getContainersOfType("customization")) {
            String clicks;
            VanillaWidgetElement element = VanillaWidgetElementBuilder.INSTANCE.buildDefaultInstance();
            String action = sec.getValue("action");
            String identifier = sec.getValue("identifier");
            identifier = identifier != null && identifier.startsWith("%id=") ? identifier.replace("%id=", "").replace("button_compatibility_id:", "").replace("%", "").replace("vanillabtn:", "") : null;
            if (action == null || identifier == null) continue;
            if (elements.containsKey(identifier)) {
                element = (VanillaWidgetElement)elements.get(identifier);
            }
            element.setInstanceIdentifier(identifier);
            boolean addElement = false;
            if (action.equalsIgnoreCase("addhoversound")) {
                element.hoverSound = SerializationUtils.deserializeAudioResourceSupplier(sec.getValue("path"));
                if (element.hoverSound != null) {
                    addElement = true;
                }
            }
            if (action.equalsIgnoreCase("sethoverlabel")) {
                element.hoverLabel = sec.getValue("label");
                if (element.hoverLabel != null) {
                    addElement = true;
                }
            }
            if (action.equalsIgnoreCase("renamebutton") || action.equalsIgnoreCase("setbuttonlabel")) {
                element.label = sec.getValue("value");
                if (element.label != null) {
                    addElement = true;
                }
            }
            if (action.equalsIgnoreCase("resizebutton")) {
                element.baseWidth = SerializationUtils.deserializeNumber(Integer.class, 5, sec.getValue("width"));
                element.baseHeight = SerializationUtils.deserializeNumber(Integer.class, 5, sec.getValue("height"));
                element.advancedWidth = sec.getValue("advanced_width");
                element.advancedHeight = sec.getValue("advanced_height");
                addElement = true;
            }
            if (action.equalsIgnoreCase("movebutton")) {
                String anchor;
                String x = sec.getValue("x");
                String y = sec.getValue("y");
                if (x != null && MathUtils.isInteger((String)(x = PlaceholderParser.replacePlaceholders(x)))) {
                    element.posOffsetX = Integer.parseInt(x);
                }
                if (y != null && MathUtils.isInteger((String)(y = PlaceholderParser.replacePlaceholders(y)))) {
                    element.posOffsetY = Integer.parseInt(y);
                }
                if ((anchor = sec.getValue("orientation")) != null) {
                    element.anchorPoint = ElementAnchorPoints.getAnchorPointByName(anchor);
                    if (element.anchorPoint == null) {
                        element.anchorPoint = ElementAnchorPoints.VANILLA;
                    }
                    if (element.anchorPoint != ElementAnchorPoints.VANILLA) {
                        addElement = true;
                    }
                }
                element.setAnchorPointElementIdentifier(sec.getValue("orientation_element"));
            }
            if (action.equalsIgnoreCase("setbuttondescription")) {
                element.tooltip = sec.getValue("description");
                if (element.tooltip != null) {
                    addElement = true;
                }
            }
            if (action.equalsIgnoreCase("hidebuttonfor")) {
                String seconds = sec.getValue("seconds");
                String onlyFirstTime = sec.getValue("onlyfirsttime");
                String fadeIn = sec.getValue("fadein");
                String fadeInSpeed = sec.getValue("fadeinspeed");
                element.appearanceDelay = onlyFirstTime != null && onlyFirstTime.equalsIgnoreCase("true") ? AbstractElement.AppearanceDelay.FIRST_TIME : AbstractElement.AppearanceDelay.EVERY_TIME;
                if (seconds != null && MathUtils.isFloat((String)seconds)) {
                    element.appearanceDelayInSeconds = Float.parseFloat(seconds);
                }
                if (fadeIn != null && fadeIn.equalsIgnoreCase("true") && fadeInSpeed != null && MathUtils.isFloat((String)fadeInSpeed)) {
                    if (element.appearanceDelay == AbstractElement.AppearanceDelay.FIRST_TIME) {
                        element.fadeIn = AbstractElement.Fading.FIRST_TIME;
                    } else if (element.appearanceDelay == AbstractElement.AppearanceDelay.EVERY_TIME) {
                        element.fadeIn = AbstractElement.Fading.EVERY_TIME;
                    }
                    element.fadeInSpeed = Float.parseFloat(fadeInSpeed);
                }
                addElement = true;
            }
            if (action.equalsIgnoreCase("hidebutton")) {
                element.vanillaButtonHidden = true;
                addElement = true;
            }
            if (action.equalsIgnoreCase("setbuttontexture")) {
                String restartBackAnimationsOnHover = sec.getValue("restartbackgroundanimations");
                if (restartBackAnimationsOnHover != null && restartBackAnimationsOnHover.equalsIgnoreCase("false")) {
                    element.restartBackgroundAnimationsOnHover = false;
                }
                element.backgroundTextureNormal = SerializationUtils.deserializeImageResourceSupplier(sec.getValue("backgroundnormal"));
                element.backgroundTextureHover = SerializationUtils.deserializeImageResourceSupplier(sec.getValue("backgroundhovered"));
                addElement = true;
            }
            if (action.equalsIgnoreCase("setbuttonclicksound")) {
                element.clickSound = SerializationUtils.deserializeAudioResourceSupplier(sec.getValue("path"));
                if (element.clickSound != null) {
                    addElement = true;
                }
            }
            if (action.equalsIgnoreCase("vanilla_button_visibility_requirements")) {
                element.loadingRequirementContainer = LoadingRequirementContainer.deserializeToSingleContainer(sec);
                addElement = true;
            }
            if (action.equalsIgnoreCase("clickbutton") && (clicks = sec.getValue("clicks")) != null && MathUtils.isInteger((String)clicks)) {
                element.automatedButtonClicks = Integer.parseInt(clicks);
                addElement = true;
            }
            if (!addElement || elements.containsKey(identifier)) continue;
            elements.put(identifier, element);
        }
        ArrayList<SerializedElement> l = new ArrayList<SerializedElement>();
        for (VanillaWidgetElement e : elements.values()) {
            e.stayOnScreen = false;
            SerializedElement serialized = VanillaWidgetElementBuilder.INSTANCE.serializeElementInternal(e);
            if (serialized == null) continue;
            l.add(serialized);
        }
        return l;
    }

    public static enum LayoutStatus implements LocalizedCycleEnum<LayoutStatus>
    {
        ENABLED("enabled", SUCCESS_TEXT_STYLE),
        DISABLED("disabled", ERROR_TEXT_STYLE);

        final String name;
        final Supplier<Style> style;

        private LayoutStatus(String name, Supplier<Style> style) {
            this.name = name;
            this.style = style;
        }

        @Override
        @NotNull
        public String getLocalizationKeyBase() {
            return "fancymenu.layout.status";
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public LayoutStatus[] getValues() {
            return LayoutStatus.values();
        }

        @Override
        @Nullable
        public LayoutStatus getByNameInternal(@NotNull String name) {
            return LayoutStatus.getByName(name);
        }

        @Nullable
        public static LayoutStatus getByName(@NotNull String name) {
            for (LayoutStatus e : LayoutStatus.values()) {
                if (!e.getName().equals(name)) continue;
                return e;
            }
            return null;
        }

        @Override
        @NotNull
        public Style getValueComponentStyle() {
            return this.style.get();
        }
    }

    public static class OrderedElementCollection {
        public List<AbstractElement> foregroundElements = new ArrayList<AbstractElement>();
        public List<AbstractElement> backgroundElements = new ArrayList<AbstractElement>();
    }
}

