/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor.widget.widgets.layer;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.element.editor.AbstractEditorElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.customization.layout.editor.widget.AbstractLayoutEditorWidget;
import de.keksuccino.fancymenu.customization.layout.editor.widget.AbstractLayoutEditorWidgetBuilder;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinAbstractWidget;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayerLayoutEditorWidget
extends AbstractLayoutEditorWidget {
    private static final Logger LOGGER = LogManager.getLogger();
    protected ScrollArea scrollArea;
    protected ScrollAreaEntry draggedEntry = null;
    private int dragTargetIndex = -1;
    private boolean isDragging = false;
    private static final int DROP_INDICATOR_THICKNESS = 3;

    public LayerLayoutEditorWidget(LayoutEditorScreen editor, AbstractLayoutEditorWidgetBuilder<?> builder) {
        super(editor, builder);
        this.displayLabel = Component.translatable((String)"fancymenu.editor.widgets.layers");
        this.scrollArea = new ScrollArea(this, 0.0f, 0.0f, 0.0f, 0.0f){

            @Override
            public void updateScrollArea() {
                int grabberOffset = 5;
                this.verticalScrollBar.scrollAreaStartX = this.getInnerX() + (float)grabberOffset;
                this.verticalScrollBar.scrollAreaStartY = this.getInnerY() + (float)grabberOffset;
                this.verticalScrollBar.scrollAreaEndX = this.getInnerX() + this.getInnerWidth() - (float)grabberOffset;
                this.verticalScrollBar.scrollAreaEndY = this.getInnerY() + this.getInnerHeight() - this.horizontalScrollBar.grabberHeight - (float)grabberOffset - 1.0f;
                this.horizontalScrollBar.scrollAreaStartX = this.getInnerX() + (float)grabberOffset;
                this.horizontalScrollBar.scrollAreaStartY = this.getInnerY() + (float)grabberOffset;
                this.horizontalScrollBar.scrollAreaEndX = this.getInnerX() + this.getInnerWidth() - this.verticalScrollBar.grabberWidth - (float)grabberOffset - 1.0f;
                this.horizontalScrollBar.scrollAreaEndY = this.getInnerY() + this.getInnerHeight() - (float)grabberOffset;
            }
        };
        this.scrollArea.borderColor = () -> UIBase.getUIColorTheme().area_background_color;
        this.updateList(false);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.updateList(false);
    }

    public void updateList(boolean keepScroll) {
        float scroll = this.scrollArea.verticalScrollBar.getScroll();
        for (Object e : this.scrollArea.getEntries()) {
            if (!(e instanceof LayerElementEntry)) continue;
            LayerElementEntry l = (LayerElementEntry)e;
            this.children.remove(l.editLayerNameBox);
        }
        this.scrollArea.clearEntries();
        if (this.editor.layout.renderElementsBehindVanilla) {
            this.scrollArea.addEntry(new VanillaLayerElementEntry(this.scrollArea, this));
            this.scrollArea.addEntry(new SeparatorEntry(this.scrollArea));
        }
        for (Object e : Lists.reverse(new ArrayList<AbstractEditorElement>(this.editor.normalEditorElements))) {
            LayerElementEntry layer = new LayerElementEntry(this.scrollArea, this, (AbstractEditorElement)e);
            this.children.add(layer.editLayerNameBox);
            this.scrollArea.addEntry(layer);
            this.scrollArea.addEntry(new SeparatorEntry(this.scrollArea));
        }
        if (!this.editor.layout.renderElementsBehindVanilla) {
            this.scrollArea.addEntry(new VanillaLayerElementEntry(this.scrollArea, this));
            this.scrollArea.addEntry(new SeparatorEntry(this.scrollArea));
        }
        if (keepScroll) {
            this.scrollArea.verticalScrollBar.setScroll(scroll);
        }
        this.draggedEntry = null;
        this.dragTargetIndex = -1;
        this.isDragging = false;
    }

    @Override
    protected void renderBody(@NotNull GuiGraphics graphics, double mouseX, double mouseY, float partial) {
        LayerLayoutEditorWidget.fillF(graphics, this.getRealBodyX(), this.getRealBodyY(), this.getRealBodyX() + this.getBodyWidth(), this.getRealBodyY() + this.getBodyHeight(), UIBase.getUIColorTheme().area_background_color.getColorInt());
        this.scrollArea.setX(this.getRealBodyX());
        this.scrollArea.setY(this.getRealBodyY());
        this.scrollArea.setWidth(this.getBodyWidth());
        this.scrollArea.setHeight(this.getBodyHeight());
        this.scrollArea.setApplyScissor(false);
        this.scrollArea.horizontalScrollBar.active = false;
        this.scrollArea.makeEntriesWidthOfArea = true;
        this.scrollArea.makeAllEntriesWidthOfWidestEntry = false;
        RenderingUtils.enableScissor(graphics, (int)this.getRealBodyX(), (int)this.getRealBodyY(), (int)(this.getRealBodyX() + this.getBodyWidth()), (int)(this.getRealBodyY() + this.getBodyHeight()));
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 400.0f);
        this.scrollArea.render(graphics, (int)mouseX, (int)mouseY, partial);
        if (this.isDragging && this.dragTargetIndex >= 0 && this.dragTargetIndex <= this.scrollArea.getEntries().size()) {
            float indicatorY;
            if (this.dragTargetIndex == this.scrollArea.getEntries().size()) {
                if (!this.scrollArea.getEntries().isEmpty()) {
                    ScrollAreaEntry lastEntry = this.scrollArea.getEntries().get(this.scrollArea.getEntries().size() - 1);
                    indicatorY = lastEntry.getY() + lastEntry.getHeight();
                } else {
                    indicatorY = this.scrollArea.getInnerY();
                }
            } else {
                ScrollAreaEntry targetEntry = this.scrollArea.getEntries().get(this.dragTargetIndex);
                indicatorY = targetEntry.getY();
            }
            LayerLayoutEditorWidget.fillF(graphics, this.scrollArea.getInnerX(), indicatorY - 1.5f, this.scrollArea.getInnerX() + this.scrollArea.getInnerWidth(), indicatorY + 1.5f, UIBase.getUIColorTheme().element_border_color_hover.getColorInt());
        }
        graphics.pose().popPose();
        graphics.disableScissor();
    }

    @Override
    @Nullable
    protected AbstractLayoutEditorWidget.ResizingEdge updateHoveredResizingEdge() {
        if (this.scrollArea.isMouseInteractingWithGrabbers()) {
            return null;
        }
        return super.updateHoveredResizingEdge();
    }

    @Override
    protected boolean mouseClickedComponent(double realMouseX, double realMouseY, double translatedMouseX, double translatedMouseY, int button) {
        for (ScrollAreaEntry e : this.scrollArea.getEntries()) {
            LayerElementEntry l;
            if (!(e instanceof LayerElementEntry) || (l = (LayerElementEntry)e).isLayerNameHovered()) continue;
            l.stopEditingLayerName();
        }
        if (this.isVisible()) {
            if (super.mouseClickedComponent(realMouseX, realMouseY, translatedMouseX, translatedMouseY, button)) {
                return true;
            }
            if (this.isExpanded()) {
                if (this.scrollArea.verticalScrollBar.mouseClicked(translatedMouseX, translatedMouseY, button)) {
                    return true;
                }
                if (this.scrollArea.horizontalScrollBar.mouseClicked(translatedMouseX, translatedMouseY, button)) {
                    return true;
                }
                for (ScrollAreaEntry entry : this.scrollArea.getEntries()) {
                    if (!entry.mouseClicked(realMouseX, realMouseY, button)) continue;
                    return true;
                }
            }
        }
        return this.isVisible() && this.isMouseOver();
    }

    @Override
    protected boolean mouseReleasedComponent(double realMouseX, double realMouseY, double translatedMouseX, double translatedMouseY, int button) {
        if (button == 0 && this.isDragging && this.draggedEntry instanceof LayerElementEntry && this.dragTargetIndex >= 0) {
            this.finishDragOperation();
        }
        this.isDragging = false;
        this.draggedEntry = null;
        this.dragTargetIndex = -1;
        for (ScrollAreaEntry e : this.scrollArea.getEntries()) {
            LayerElementEntry l;
            if (!(e instanceof LayerElementEntry) || !(l = (LayerElementEntry)e).layerMouseReleased(realMouseX, realMouseY, button)) continue;
            return true;
        }
        return super.mouseReleasedComponent(realMouseX, realMouseY, translatedMouseX, translatedMouseY, button);
    }

    @Override
    protected boolean mouseDraggedComponent(double translatedMouseX, double translatedMouseY, int button, double d1, double d2) {
        if (this.isDragging && button == 0) {
            this.updateDragTarget(translatedMouseX, translatedMouseY, this.getRealMouseX(), this.getRealMouseY());
        }
        for (ScrollAreaEntry e : this.scrollArea.getEntries()) {
            LayerElementEntry l;
            if (!(e instanceof LayerElementEntry) || !(l = (LayerElementEntry)e).layerMouseDragged(translatedMouseX, translatedMouseY, button, d1, d2)) continue;
            return true;
        }
        return super.mouseDraggedComponent(translatedMouseX, translatedMouseY, button, d1, d2);
    }

    private void updateDragTarget(double translatedMouseX, double translatedMouseY, double realMouseX, double realMouseY) {
        ScrollAreaEntry nextEntry;
        boolean isBelowWidget;
        if (!this.isDragging || this.draggedEntry == null) {
            return;
        }
        int draggedIndex = this.scrollArea.getEntries().indexOf(this.draggedEntry);
        if (draggedIndex < 0) {
            return;
        }
        boolean isAboveWidget = translatedMouseY < (double)this.scrollArea.getInnerY();
        boolean bl = isBelowWidget = translatedMouseY > (double)(this.scrollArea.getInnerY() + this.scrollArea.getInnerHeight());
        if (isAboveWidget) {
            this.dragTargetIndex = this.editor.layout.renderElementsBehindVanilla && !this.scrollArea.getEntries().isEmpty() && this.scrollArea.getEntries().get(0) instanceof VanillaLayerElementEntry ? 2 : 0;
            return;
        }
        if (isBelowWidget) {
            if (!this.editor.layout.renderElementsBehindVanilla) {
                int vanillaIndex = -1;
                for (int i = 0; i < this.scrollArea.getEntries().size(); ++i) {
                    if (!(this.scrollArea.getEntries().get(i) instanceof VanillaLayerElementEntry)) continue;
                    vanillaIndex = i;
                    break;
                }
                if (vanillaIndex >= 0) {
                    this.dragTargetIndex = vanillaIndex;
                    return;
                }
            }
            this.dragTargetIndex = this.scrollArea.getEntries().size();
            return;
        }
        int mouseOverIndex = -1;
        for (int i = 0; i < this.scrollArea.getEntries().size(); ++i) {
            ScrollAreaEntry entry = this.scrollArea.getEntries().get(i);
            if (!entry.isMouseOver(realMouseX, realMouseY)) continue;
            mouseOverIndex = i;
            break;
        }
        if (this.editor.layout.renderElementsBehindVanilla && mouseOverIndex == 0 && this.scrollArea.getEntries().get(0) instanceof VanillaLayerElementEntry) {
            VanillaLayerElementEntry vanillaEntry = (VanillaLayerElementEntry)this.scrollArea.getEntries().get(0);
            float entryMidpoint = vanillaEntry.getY() + vanillaEntry.getHeight() / 2.0f;
            this.dragTargetIndex = translatedMouseY < (double)entryMidpoint ? 0 : 2;
            return;
        }
        if (!this.editor.layout.renderElementsBehindVanilla && mouseOverIndex >= 0 && this.scrollArea.getEntries().get(mouseOverIndex) instanceof VanillaLayerElementEntry) {
            this.dragTargetIndex = mouseOverIndex;
            return;
        }
        if (mouseOverIndex == -1 && !this.scrollArea.getEntries().isEmpty() && translatedMouseY < (double)this.scrollArea.getEntries().get(0).getY() && translatedMouseY >= (double)this.scrollArea.getInnerY()) {
            this.dragTargetIndex = this.editor.layout.renderElementsBehindVanilla && this.scrollArea.getEntries().get(0) instanceof VanillaLayerElementEntry ? 2 : 0;
            return;
        }
        if (mouseOverIndex == -1 && !this.scrollArea.getEntries().isEmpty() && translatedMouseY > (double)(this.scrollArea.getEntries().get(this.scrollArea.getEntries().size() - 1).getY() + this.scrollArea.getEntries().get(this.scrollArea.getEntries().size() - 1).getHeight()) && translatedMouseY <= (double)(this.scrollArea.getInnerY() + this.scrollArea.getInnerHeight())) {
            if (!this.editor.layout.renderElementsBehindVanilla) {
                int vanillaIndex = -1;
                for (int i = 0; i < this.scrollArea.getEntries().size(); ++i) {
                    if (!(this.scrollArea.getEntries().get(i) instanceof VanillaLayerElementEntry)) continue;
                    vanillaIndex = i;
                    break;
                }
                if (vanillaIndex >= 0) {
                    this.dragTargetIndex = vanillaIndex;
                    return;
                }
            }
            this.dragTargetIndex = this.scrollArea.getEntries().size();
            return;
        }
        if (mouseOverIndex == -1) {
            return;
        }
        if (mouseOverIndex % 2 == 1) {
            ScrollAreaEntry separator = this.scrollArea.getEntries().get(mouseOverIndex);
            float separatorMidpoint = separator.getY() + separator.getHeight() / 2.0f;
            mouseOverIndex = translatedMouseY < (double)separatorMidpoint ? Math.max(0, mouseOverIndex - 1) : Math.min(this.scrollArea.getEntries().size() - 1, mouseOverIndex + 1);
        }
        if (mouseOverIndex == draggedIndex) {
            return;
        }
        ScrollAreaEntry targetEntry = this.scrollArea.getEntries().get(mouseOverIndex);
        float entryMidpoint = targetEntry.getY() + targetEntry.getHeight() / 2.0f;
        this.dragTargetIndex = translatedMouseY < (double)entryMidpoint ? mouseOverIndex : mouseOverIndex + 1;
        if (!this.editor.layout.renderElementsBehindVanilla) {
            int vanillaIndex = -1;
            for (int i = 0; i < this.scrollArea.getEntries().size(); ++i) {
                if (!(this.scrollArea.getEntries().get(i) instanceof VanillaLayerElementEntry)) continue;
                vanillaIndex = i;
                break;
            }
            if (vanillaIndex >= 0 && this.dragTargetIndex > vanillaIndex) {
                this.dragTargetIndex = vanillaIndex;
            }
        }
        if (this.dragTargetIndex == draggedIndex) {
            this.dragTargetIndex = translatedMouseY > (double)(this.scrollArea.getEntries().get(draggedIndex).getY() + this.scrollArea.getEntries().get(draggedIndex).getHeight() / 2.0f) ? draggedIndex + 1 : Math.max(0, draggedIndex - 1);
        } else if (this.dragTargetIndex == draggedIndex + 1 && draggedIndex < this.scrollArea.getEntries().size() - 1 && !(translatedMouseY < (double)((nextEntry = this.scrollArea.getEntries().get(draggedIndex + 1)).getY() + nextEntry.getHeight() / 2.0f))) {
            this.dragTargetIndex = draggedIndex + 2;
        }
    }

    private int getElementIndexFromUIIndex(int uiIndex, boolean forDropIndicator) {
        int elementCount = this.editor.normalEditorElements.size();
        if (elementCount == 0) {
            return -1;
        }
        if (uiIndex < 0) {
            return -1;
        }
        if (uiIndex > this.scrollArea.getEntries().size()) {
            return 0;
        }
        if (this.editor.layout.renderElementsBehindVanilla) {
            if (uiIndex <= 1) {
                return elementCount - 1;
            }
            int entryIndex = (uiIndex - 2) / 2;
            int elementIndex = elementCount - 1 - entryIndex;
            if (forDropIndicator && uiIndex % 2 == 0) {
                return elementIndex + 1;
            }
            return elementIndex;
        }
        int entryIndex = uiIndex / 2;
        int elementIndex = elementCount - 1 - entryIndex;
        if (forDropIndicator && uiIndex % 2 == 0) {
            return elementIndex + 1;
        }
        return elementIndex;
    }

    private void finishDragOperation() {
        boolean movingDown;
        int currentDraggedIndex;
        ScrollAreaEntry scrollAreaEntry = this.draggedEntry;
        if (!(scrollAreaEntry instanceof LayerElementEntry)) {
            return;
        }
        LayerElementEntry layerEntry = (LayerElementEntry)scrollAreaEntry;
        ArrayList<LayerElementEntry> selectedEntries = new ArrayList<LayerElementEntry>();
        for (ScrollAreaEntry entry2 : this.scrollArea.getEntries()) {
            if (!(entry2 instanceof LayerElementEntry)) continue;
            LayerElementEntry layerElement = (LayerElementEntry)entry2;
            if (!layerElement.element.isSelected()) continue;
            selectedEntries.add(layerElement);
        }
        if (selectedEntries.isEmpty()) {
            selectedEntries.add(layerEntry);
        }
        if ((currentDraggedIndex = this.scrollArea.getEntries().indexOf(this.draggedEntry)) < 0) {
            return;
        }
        if (this.dragTargetIndex == currentDraggedIndex) {
            return;
        }
        selectedEntries.sort(Comparator.comparingInt(entry -> this.scrollArea.getEntries().indexOf(entry)));
        ArrayList<Integer> sourceElementIndices = new ArrayList<Integer>();
        for (LayerElementEntry entry3 : selectedEntries) {
            int entryIndex = this.scrollArea.getEntries().indexOf(entry3);
            int elementIndex = this.getElementIndexFromUIIndex(entryIndex, false);
            sourceElementIndices.add(elementIndex);
        }
        boolean isIndicatorAtTop = this.dragTargetIndex < this.scrollArea.getEntries().size() && this.dragTargetIndex % 2 == 0;
        int targetElementIndex = this.getElementIndexFromUIIndex(this.dragTargetIndex, true);
        if (sourceElementIndices.isEmpty() || targetElementIndex < 0 || targetElementIndex > this.editor.normalEditorElements.size()) {
            return;
        }
        this.editor.history.saveSnapshot();
        boolean bl = movingDown = targetElementIndex < (Integer)Collections.min(sourceElementIndices);
        if (!movingDown) {
            Collections.reverse(selectedEntries);
            Collections.reverse(sourceElementIndices);
        }
        for (int i = 0; i < selectedEntries.size(); ++i) {
            LayerElementEntry entry4 = (LayerElementEntry)selectedEntries.get(i);
            int sourceIndex = (Integer)sourceElementIndices.get(i);
            int adjustedTargetIndex = targetElementIndex;
            if (movingDown && i > 0) {
                adjustedTargetIndex = targetElementIndex + i;
            }
            AbstractEditorElement elementToMove = entry4.element;
            this.editor.moveLayerToPosition(elementToMove, adjustedTargetIndex);
        }
        MainThreadTaskExecutor.executeInMainThread(() -> this.updateList(true), MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
    }

    @Override
    protected boolean mouseScrolledComponent(double realMouseX, double realMouseY, double translatedMouseX, double translatedMouseY, double scrollDeltaX, double scrollDeltaY) {
        if (super.mouseScrolledComponent(realMouseX, realMouseY, translatedMouseX, translatedMouseY, scrollDeltaX, scrollDeltaY)) {
            return true;
        }
        return this.scrollArea.mouseScrolled(realMouseX, realMouseY, scrollDeltaX, scrollDeltaY);
    }

    @Override
    public void editorElementAdded(@NotNull AbstractEditorElement element) {
        this.updateList(false);
    }

    @Override
    public void editorElementRemovedOrHidden(@NotNull AbstractEditorElement element) {
        this.updateList(false);
    }

    @Override
    public void editorElementOrderChanged(@NotNull AbstractEditorElement element, boolean movedUp) {
        this.updateList(false);
    }

    public static class LayerElementEntry
    extends ScrollAreaEntry {
        protected static final ResourceLocation MOVE_UP_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"fancymenu", (String)"textures/layout_editor/widgets/layers/move_up.png");
        protected static final ResourceLocation MOVE_DOWN_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"fancymenu", (String)"textures/layout_editor/widgets/layers/move_down.png");
        protected static final ResourceLocation EYE_ICON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"fancymenu", (String)"textures/layout_editor/widgets/layers/eye_icon.png");
        protected AbstractEditorElement element;
        protected LayerLayoutEditorWidget layerWidget;
        protected boolean moveUpButtonHovered = false;
        protected boolean moveDownButtonHovered = false;
        protected boolean eyeButtonHovered = false;
        protected Font font;
        protected ExtendedEditBox editLayerNameBox;
        protected boolean displayEditLayerNameBox;
        protected boolean layerNameHovered;
        protected long lastLeftClick;
        protected boolean dragStarted;
        protected double dragStartX;
        protected double dragStartY;
        private static final int DRAG_THRESHOLD = 3;

        public LayerElementEntry(ScrollArea parent, LayerLayoutEditorWidget layerWidget, @NotNull AbstractEditorElement element) {
            super(parent, 50.0f, 28.0f);
            this.font = Minecraft.getInstance().font;
            this.displayEditLayerNameBox = false;
            this.layerNameHovered = false;
            this.lastLeftClick = -1L;
            this.dragStarted = false;
            this.element = element;
            this.layerWidget = layerWidget;
            this.playClickSound = false;
            this.selectable = false;
            this.selectOnClick = false;
            this.editLayerNameBox = new ExtendedEditBox(this.font, 0, 0, 0, 0, (Component)Component.empty()){

                @Override
                public boolean keyPressed(int keycode, int scancode, int modifiers) {
                    if (this.isVisible() && displayEditLayerNameBox && keycode == 257) {
                        this.stopEditingLayerName();
                        return true;
                    }
                    return super.keyPressed(keycode, scancode, modifiers);
                }
            };
            this.editLayerNameBox.setVisible(false);
            this.editLayerNameBox.setMaxLength(10000);
        }

        @Override
        public void renderEntry(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            this.moveUpButtonHovered = this.isMoveUpButtonMouseOver(mouseX, mouseY);
            this.moveDownButtonHovered = this.isMoveDownButtonMouseOver(mouseX, mouseY);
            this.eyeButtonHovered = this.isEyeButtonMouseOver(mouseX, mouseY);
            this.layerNameHovered = this.isLayerNameMouseOver(mouseX, mouseY);
            RenderSystem.enableBlend();
            if (this.element.isSelected() || this.element.isMultiSelected()) {
                LayerElementEntry.fillF(graphics, this.x, this.y, this.x + this.getWidth(), this.y + this.getHeight(), UIBase.getUIColorTheme().element_background_color_hover.getColorInt());
            }
            LayerElementEntry.blitF(graphics, MOVE_UP_TEXTURE, this.x, this.y, 0.0f, 0.0f, this.getButtonWidth(), this.getButtonHeight(), this.getButtonWidth(), this.getButtonHeight(), UIBase.getUIColorTheme().ui_texture_color.getColorIntWithAlpha(this.layerWidget.editor.canMoveLayerUp(this.element) ? 1.0f : 0.3f));
            LayerElementEntry.blitF(graphics, MOVE_DOWN_TEXTURE, this.x, this.y + this.getButtonHeight(), 0.0f, 0.0f, this.getButtonWidth(), this.getButtonHeight(), this.getButtonWidth(), this.getButtonHeight(), UIBase.getUIColorTheme().ui_texture_color.getColorIntWithAlpha(this.layerWidget.editor.canMoveLayerDown(this.element) ? 1.0f : 0.3f));
            LayerElementEntry.blitF(graphics, EYE_ICON_TEXTURE, this.getEyeButtonX(), this.getEyeButtonY(), 0.0f, 0.0f, this.getEyeButtonWidth(), this.getEyeButtonHeight(), this.getEyeButtonWidth(), this.getEyeButtonHeight(), UIBase.getUIColorTheme().ui_texture_color.getColorIntWithAlpha(!this.element.element.layerHiddenInEditor ? 1.0f : 0.3f));
            if (!this.displayEditLayerNameBox) {
                UIBase.drawElementLabel(graphics, this.font, (Component)Component.literal((String)this.getLayerName()), (int)this.getLayerNameX(), (int)this.getLayerNameY());
            } else {
                UIBase.applyDefaultWidgetSkinTo(this.editLayerNameBox);
                this.editLayerNameBox.setX((int)this.getLayerNameX());
                this.editLayerNameBox.setY((int)this.getLayerNameY() - 1);
                this.editLayerNameBox.setWidth((int)Math.min(this.getMaxLayerNameWidth(), (float)this.font.width(this.editLayerNameBox.getValue() + "13")));
                if ((float)this.editLayerNameBox.getWidth() < this.getMaxLayerNameWidth()) {
                    this.editLayerNameBox.setDisplayPosition(0);
                }
                IMixinAbstractWidget iMixinAbstractWidget = (IMixinAbstractWidget)((Object)this.editLayerNameBox);
                Objects.requireNonNull(this.font);
                iMixinAbstractWidget.setHeightFancyMenu(9 + 2);
                this.editLayerNameBox.render(graphics, mouseX, mouseY, partial);
            }
        }

        protected void startEditingLayerName() {
            this.editLayerNameBox.setVisible(true);
            this.editLayerNameBox.setFocused(true);
            this.editLayerNameBox.setValue(this.getLayerName());
            this.editLayerNameBox.moveCursorToEnd(false);
            this.displayEditLayerNameBox = true;
        }

        protected void stopEditingLayerName() {
            if (this.displayEditLayerNameBox) {
                String oldLayerName = this.getLayerName();
                this.element.element.customElementLayerName = this.editLayerNameBox.getValue();
                if (Objects.equals(oldLayerName, this.element.element.customElementLayerName)) {
                    this.element.element.customElementLayerName = null;
                }
                if (this.element.element.customElementLayerName != null && this.element.element.customElementLayerName.replace(" ", "").isEmpty()) {
                    this.element.element.customElementLayerName = null;
                }
            }
            this.editLayerNameBox.setFocused(false);
            this.editLayerNameBox.setVisible(false);
            this.displayEditLayerNameBox = false;
        }

        public String getLayerName() {
            if (this.element.element.customElementLayerName != null) {
                return this.element.element.customElementLayerName;
            }
            return this.element.element.builder.getDisplayName(this.element.element).getString();
        }

        public float getLayerNameX() {
            return this.getEyeButtonX() + this.getEyeButtonWidth() + 4.0f;
        }

        public float getLayerNameY() {
            float f = this.getY() + this.getHeight() / 2.0f;
            Objects.requireNonNull(this.font);
            return f - 9.0f / 2.0f;
        }

        public float getMaxLayerNameWidth() {
            return this.getX() + this.getWidth() - 3.0f - this.getLayerNameX();
        }

        public boolean isMoveUpButtonHovered() {
            return this.moveUpButtonHovered;
        }

        public boolean isMoveDownButtonHovered() {
            return this.moveDownButtonHovered;
        }

        public boolean isEyeButtonHovered() {
            return this.eyeButtonHovered;
        }

        public boolean isLayerNameHovered() {
            return this.layerNameHovered;
        }

        public boolean isMoveUpButtonMouseOver(double mouseX, double mouseY) {
            if (this.parent.isMouseInteractingWithGrabbers()) {
                return false;
            }
            if (!this.parent.isInnerAreaHovered()) {
                return false;
            }
            return LayerElementEntry.isXYInArea(mouseX, mouseY, this.x, this.y, this.getButtonWidth(), this.getButtonHeight());
        }

        public boolean isMoveDownButtonMouseOver(double mouseX, double mouseY) {
            if (this.parent.isMouseInteractingWithGrabbers()) {
                return false;
            }
            if (!this.parent.isInnerAreaHovered()) {
                return false;
            }
            return LayerElementEntry.isXYInArea(mouseX, mouseY, this.x, this.y + this.getButtonHeight(), this.getButtonWidth(), this.getButtonHeight());
        }

        public boolean isEyeButtonMouseOver(double mouseX, double mouseY) {
            if (this.parent.isMouseInteractingWithGrabbers()) {
                return false;
            }
            if (!this.parent.isInnerAreaHovered()) {
                return false;
            }
            return LayerElementEntry.isXYInArea(mouseX, mouseY, this.getEyeButtonX(), this.getEyeButtonY(), this.getEyeButtonWidth(), this.getEyeButtonHeight());
        }

        public boolean isLayerNameMouseOver(double mouseX, double mouseY) {
            if (this.parent.isMouseInteractingWithGrabbers()) {
                return false;
            }
            if (!this.parent.isInnerAreaHovered()) {
                return false;
            }
            double d = this.getLayerNameX();
            double d2 = this.getLayerNameY();
            double d3 = this.getMaxLayerNameWidth();
            Objects.requireNonNull(this.font);
            return LayerElementEntry.isXYInArea(mouseX, mouseY, d, d2, d3, 9.0);
        }

        public float getEyeButtonWidth() {
            return 30.0f;
        }

        public float getEyeButtonHeight() {
            return 26.0f;
        }

        public float getEyeButtonX() {
            return this.x + this.getButtonWidth();
        }

        public float getEyeButtonY() {
            return this.y + 1.0f;
        }

        public float getButtonHeight() {
            return 14.0f;
        }

        public float getButtonWidth() {
            return 30.0f;
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (button == 0 && this.isMouseOver(mouseX, mouseY) && !this.moveUpButtonHovered && !this.moveDownButtonHovered && !this.eyeButtonHovered) {
                this.dragStartX = mouseX;
                this.dragStartY = mouseY;
                this.dragStarted = true;
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }

        public boolean layerMouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            if (button == 0 && this.dragStarted) {
                double deltaX = mouseX - this.dragStartX;
                double deltaY = mouseY - this.dragStartY;
                double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
                if (distance > 3.0 && !this.layerWidget.isDragging && this.element.isSelected()) {
                    int currentIndex;
                    this.layerWidget.draggedEntry = this;
                    this.layerWidget.isDragging = true;
                    this.layerWidget.dragTargetIndex = currentIndex = this.parent.getEntries().indexOf(this);
                    return true;
                }
                return true;
            }
            return false;
        }

        public boolean layerMouseReleased(double mouseX, double mouseY, int button) {
            if (button == 0) {
                if (this.dragStarted && !this.layerWidget.isDragging) {
                    this.onClick(this, mouseX, mouseY, button);
                }
                this.dragStarted = false;
            }
            return false;
        }

        @Override
        public void onClick(ScrollAreaEntry entry, double mouseX, double mouseY, int button) {
            if (button == 0) {
                if (this.isMoveUpButtonHovered()) {
                    if (this.layerWidget.editor.canMoveLayerUp(this.element)) {
                        if (FancyMenu.getOptions().playUiClickSounds.getValue().booleanValue()) {
                            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                        }
                        ((LayerLayoutEditorWidget)this.layerWidget).editor.history.saveSnapshot();
                        if (!this.element.isSelected()) {
                            this.layerWidget.editor.deselectAllElements();
                        }
                        this.element.setSelected(true);
                        this.layerWidget.editor.moveLayerUp(this.element);
                        this.layerWidget.getAllWidgetsExceptThis().forEach(widget -> widget.editorElementOrderChanged(this.element, true));
                        MainThreadTaskExecutor.executeInMainThread(() -> this.layerWidget.updateList(true), MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
                    }
                } else if (this.isMoveDownButtonHovered()) {
                    if (this.layerWidget.editor.canMoveLayerDown(this.element)) {
                        if (FancyMenu.getOptions().playUiClickSounds.getValue().booleanValue()) {
                            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                        }
                        ((LayerLayoutEditorWidget)this.layerWidget).editor.history.saveSnapshot();
                        if (!this.element.isSelected()) {
                            this.layerWidget.editor.deselectAllElements();
                        }
                        this.element.setSelected(true);
                        this.layerWidget.editor.moveLayerDown(this.element);
                        this.layerWidget.getAllWidgetsExceptThis().forEach(widget -> widget.editorElementOrderChanged(this.element, false));
                        MainThreadTaskExecutor.executeInMainThread(() -> this.layerWidget.updateList(true), MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
                    }
                } else if (this.isEyeButtonHovered()) {
                    if (FancyMenu.getOptions().playUiClickSounds.getValue().booleanValue()) {
                        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                    }
                    ((LayerLayoutEditorWidget)this.layerWidget).editor.history.saveSnapshot();
                    if (!this.element.isSelected()) {
                        this.layerWidget.editor.deselectAllElements();
                    }
                    this.element.setSelected(true);
                    this.element.element.layerHiddenInEditor = !this.element.element.layerHiddenInEditor;
                } else {
                    boolean ctrlDown;
                    if (FancyMenu.getOptions().playUiClickSounds.getValue().booleanValue()) {
                        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                    }
                    if (!(ctrlDown = Screen.hasControlDown())) {
                        this.layerWidget.editor.deselectAllElements();
                    } else if (this.element.isSelected()) {
                        this.element.setSelected(false);
                        return;
                    }
                    if (!this.element.isSelected()) {
                        this.element.setSelected(true);
                    }
                    if (this.isLayerNameHovered()) {
                        long now = System.currentTimeMillis();
                        if (this.lastLeftClick + 400L > now) {
                            this.startEditingLayerName();
                        }
                        this.lastLeftClick = now;
                    }
                }
            }
            if (button == 1) {
                if (!this.element.isSelected()) {
                    this.layerWidget.editor.deselectAllElements();
                }
                this.element.setSelected(true);
                MainThreadTaskExecutor.executeInMainThread(() -> this.layerWidget.editor.openElementContextMenuAtMouseIfPossible(), MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
            }
        }
    }

    public static class VanillaLayerElementEntry
    extends ScrollAreaEntry {
        protected static final ResourceLocation MOVE_TO_TOP_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"fancymenu", (String)"textures/layout_editor/widgets/layers/move_top.png");
        protected static final ResourceLocation MOVE_BEHIND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"fancymenu", (String)"textures/layout_editor/widgets/layers/move_bottom.png");
        protected LayerLayoutEditorWidget layerWidget;
        protected boolean moveTopBottomButtonHovered = false;
        protected Font font;

        public VanillaLayerElementEntry(ScrollArea parent, LayerLayoutEditorWidget layerWidget) {
            super(parent, 50.0f, 28.0f);
            this.font = Minecraft.getInstance().font;
            this.layerWidget = layerWidget;
            this.playClickSound = false;
            this.selectable = false;
            this.selectOnClick = false;
        }

        @Override
        public void renderEntry(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            this.moveTopBottomButtonHovered = this.isMoveTopBottomButtonHovered(mouseX, mouseY);
            RenderSystem.enableBlend();
            ResourceLocation loc = ((LayerLayoutEditorWidget)this.layerWidget).editor.layout.renderElementsBehindVanilla ? MOVE_BEHIND_TEXTURE : MOVE_TO_TOP_TEXTURE;
            VanillaLayerElementEntry.blitF(graphics, loc, this.x, this.y, 0.0f, 0.0f, this.getButtonWidth(), this.getButtonHeight(), this.getButtonWidth(), this.getButtonHeight(), UIBase.getUIColorTheme().ui_texture_color.getColorInt());
            MutableComponent mutableComponent = Component.translatable((String)"fancymenu.editor.widgets.layers.vanilla_elements").setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().warning_text_color.getColorInt()));
            int n = (int)(this.getX() + this.getButtonWidth() + 3.0f);
            float f = this.getY() + this.getHeight() / 2.0f;
            Objects.requireNonNull(this.font);
            UIBase.drawElementLabel(graphics, this.font, (Component)mutableComponent, n, (int)(f - 9.0f / 2.0f));
        }

        public boolean isMoveTopBottomButtonHovered() {
            return this.moveTopBottomButtonHovered;
        }

        public boolean isMoveTopBottomButtonHovered(double mouseX, double mouseY) {
            if (this.parent.isMouseInteractingWithGrabbers()) {
                return false;
            }
            if (!this.parent.isInnerAreaHovered()) {
                return false;
            }
            return VanillaLayerElementEntry.isXYInArea(mouseX, mouseY, this.x, this.y, this.getButtonWidth(), this.getButtonHeight());
        }

        public float getButtonHeight() {
            return 28.0f;
        }

        public float getButtonWidth() {
            return 30.0f;
        }

        @Override
        public void onClick(ScrollAreaEntry entry, double mouseX, double mouseY, int button) {
            if (button == 0 && this.isMoveTopBottomButtonHovered()) {
                if (FancyMenu.getOptions().playUiClickSounds.getValue().booleanValue()) {
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                }
                ((LayerLayoutEditorWidget)this.layerWidget).editor.history.saveSnapshot();
                ((LayerLayoutEditorWidget)this.layerWidget).editor.layout.renderElementsBehindVanilla = !((LayerLayoutEditorWidget)this.layerWidget).editor.layout.renderElementsBehindVanilla;
                this.layerWidget.editor.deselectAllElements();
                MainThreadTaskExecutor.executeInMainThread(() -> this.layerWidget.updateList(true), MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
            }
        }
    }

    public static class SeparatorEntry
    extends ScrollAreaEntry {
        public SeparatorEntry(ScrollArea parent) {
            super(parent, 50.0f, 1.0f);
            this.selectable = false;
            this.selectOnClick = false;
        }

        @Override
        public void renderEntry(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            RenderSystem.enableBlend();
            SeparatorEntry.fillF(graphics, this.x, this.y, this.x + this.getWidth(), this.y + this.getHeight(), UIBase.getUIColorTheme().element_border_color_normal.getColorInt());
        }

        @Override
        public boolean isMouseOver(double mouseX, double mouseY) {
            return false;
        }

        @Override
        public void onClick(ScrollAreaEntry entry, double mouseX, double mouseY, int button) {
        }
    }
}

