/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.advanced;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwitchCasePlaceholder
extends Placeholder {
    private static final Logger LOGGER = LogManager.getLogger();

    public SwitchCasePlaceholder() {
        super("switch_case");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        String value = dps.values.get("value");
        String cases = dps.values.get("cases");
        String defaultCase = dps.values.get("default");
        if (value != null && cases != null) {
            try {
                String[] casesPairs;
                for (String pair : casesPairs = cases.split(",")) {
                    String[] keyValue = pair.trim().split(":");
                    if (keyValue.length != 2) continue;
                    String caseValue = keyValue[0].trim();
                    String result = keyValue[1].trim();
                    if (!value.equals(caseValue)) continue;
                    return result;
                }
                return defaultCase;
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to parse 'Switch Case' placeholder: " + dps.placeholderString, (Throwable)ex);
            }
        }
        LOGGER.error("[FANCYMENU] Failed to parse 'Switch Case' placeholder: " + dps.placeholderString);
        return null;
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("value");
        l.add("cases");
        l.add("default");
        return l;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.get((String)"fancymenu.placeholders.switch_case", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.switch_case.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.get((String)"fancymenu.fancymenu.editor.dynamicvariabletextfield.categories.advanced", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("value", "1");
        values.put("cases", "1:first case,2:second case,3:third case");
        values.put("default", "default case");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }
}

