/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.net;

import de.maxhenkel.camera.ClientImageUploadManager;
import de.maxhenkel.camera.ImageProcessor;
import de.maxhenkel.camera.corelib.net.Message;
import java.awt.image.BufferedImage;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessageUploadCustomImage
implements Message<MessageUploadCustomImage> {
    public static final CustomPacketPayload.Type<MessageUploadCustomImage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"camera", (String)"upload"));
    private UUID uuid;

    public MessageUploadCustomImage() {
    }

    public MessageUploadCustomImage(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.CLIENTBOUND;
    }

    @Override
    public void executeClientSide(IPayloadContext context) {
        BufferedImage image = ClientImageUploadManager.getAndRemoveImage(this.uuid);
        if (image == null) {
            return;
        }
        ImageProcessor.sendScreenshotThreaded(this.uuid, image);
    }

    @Override
    public MessageUploadCustomImage fromBytes(RegistryFriendlyByteBuf buf) {
        this.uuid = buf.readUUID();
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeUUID(this.uuid);
    }

    @Override
    public CustomPacketPayload.Type<MessageUploadCustomImage> type() {
        return TYPE;
    }
}

