/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.item;

import com.google.common.collect.Iterables;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.item.DescriptionItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class VehicleItem
extends DescriptionItem {
    private final VehicleConstructor constructor;
    private final boolean onWater;

    public VehicleItem(Item.Properties settings, VehicleConstructor constructor) {
        this(settings, constructor, true);
    }

    public VehicleItem(Item.Properties settings, VehicleConstructor constructor, boolean onWater) {
        super(settings);
        this.constructor = constructor;
        this.onWater = onWater;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        BlockHitResult hitResult = VehicleItem.getPlayerPOVHitResult((Level)world, (Player)user, (ClipContext.Fluid)(this.onWater ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE));
        if (hitResult.getType() == HitResult.Type.MISS) {
            VehicleItem.error(user, "immersive_aircraft.tooltip.no_target");
            return InteractionResultHolder.pass((Object)itemStack);
        }
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            VehicleEntity entity = this.constructor.create(world);
            entity.readItemTag(itemStack);
            entity.setPos(hitResult.getLocation().x, hitResult.getLocation().y, hitResult.getLocation().z);
            entity.setYRot(user.getYRot());
            if (!world.noCollision((Entity)entity, entity.getBoundingBox())) {
                VehicleItem.error(user, "immersive_aircraft.tooltip.no_space");
                return InteractionResultHolder.fail((Object)itemStack);
            }
            if (!world.isClientSide) {
                world.addFreshEntity((Entity)entity);
                world.gameEvent((Entity)user, (Holder)GameEvent.ENTITY_PLACE, BlockPos.containing((Position)hitResult.getLocation()));
                if (!user.getAbilities().instabuild) {
                    itemStack.shrink(1);
                }
            }
            user.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)world.isClientSide());
        }
        return InteractionResultHolder.pass((Object)itemStack);
    }

    private static void error(Player user, String message) {
        user.displayClientMessage((Component)Component.translatable((String)message).withStyle(ChatFormatting.RED), true);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltips, TooltipFlag flags) {
        super.appendHoverText(stack, ctx, tooltips, flags);
        ItemContainerContents data = (ItemContainerContents)stack.get(DataComponents.CONTAINER);
        if (data != null) {
            tooltips.add((Component)Component.translatable((String)"immersive_aircraft.tooltip.inventory", (Object[])new Object[]{Iterables.size((Iterable)data.nonEmptyItems())}));
        }
    }

    public static interface VehicleConstructor {
        public VehicleEntity create(Level var1);
    }
}

