/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mindfuldarkness.client.gui.screens;

import fuzs.mindfuldarkness.MindfulDarkness;
import fuzs.mindfuldarkness.client.gui.components.NewTextureButton;
import fuzs.mindfuldarkness.client.gui.components.NewTextureSliderButton;
import fuzs.mindfuldarkness.client.handler.ColorChangedAssetsManager;
import fuzs.mindfuldarkness.client.handler.DaytimeSwitcherHandler;
import fuzs.mindfuldarkness.client.util.DarkeningAlgorithm;
import fuzs.mindfuldarkness.config.ClientConfig;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class PixelConfigScreen
extends Screen {
    public static final Component ALGORITHM_COMPONENT = Component.translatable((String)"screen.daytime_switcher.algorithm");
    public static final Component INTERFACE_DARKNESS_COMPONENT = Component.translatable((String)"screen.daytime_switcher.interface_darkness");
    public static final Component FONT_BRIGHTNESS_COMPONENT = Component.translatable((String)"screen.daytime_switcher.front_brightness");
    private final Screen lastScreen;
    protected int imageWidth = 176;
    protected int imageHeight = 166;
    protected int leftPos;
    protected int topPos;
    private boolean markedDirty;

    public PixelConfigScreen(Screen lastScreen) {
        super(CommonComponents.EMPTY);
        this.lastScreen = lastScreen;
    }

    protected void init() {
        AbstractWidget[] buttons;
        super.init();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        for (AbstractWidget button2 : buttons = DaytimeSwitcherHandler.makeButtons(this.minecraft, this, this.leftPos, this.topPos, this.imageWidth)) {
            this.addRenderableWidget((GuiEventListener)button2);
        }
        final ClientConfig clientConfig = (ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class);
        this.addRenderableWidget((GuiEventListener)new NewTextureButton(this.leftPos + 13, this.topPos + 32, 150, 20, ((DarkeningAlgorithm)((Object)clientConfig.darkeningAlgorithm.get())).getComponent(), button -> {
            int length = DarkeningAlgorithm.values().length;
            DarkeningAlgorithm darkeningAlgorithm = DarkeningAlgorithm.values()[((((DarkeningAlgorithm)((Object)((Object)clientConfig.darkeningAlgorithm.get()))).ordinal() + (PixelConfigScreen.hasShiftDown() ? -1 : 1)) % length + length) % length];
            clientConfig.darkeningAlgorithm.set((Object)darkeningAlgorithm);
            button.setMessage(darkeningAlgorithm.getComponent());
            if (((Boolean)((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).darkTheme.get()).booleanValue()) {
                ColorChangedAssetsManager.INSTANCE.reset();
                this.markedDirty = true;
            }
        }));
        (this.addRenderableWidget((GuiEventListener)new NewTextureSliderButton(this.leftPos + 13, this.topPos + 81, 150, 18, CommonComponents.EMPTY, (Double)clientConfig.textureDarkness.get()){

            protected void updateMessage() {
                this.setTooltip(Tooltip.create((Component)Component.literal((String)String.format("%.0f%%", this.value * 100.0))));
            }

            protected void applyValue() {
                clientConfig.textureDarkness.set((Object)this.value);
                if (((Boolean)((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).darkTheme.get()).booleanValue()) {
                    ColorChangedAssetsManager.INSTANCE.reset();
                    PixelConfigScreen.this.markedDirty = true;
                }
            }
        })).setTooltip(Tooltip.create((Component)Component.literal((String)String.format("%.0f%%", (Double)clientConfig.textureDarkness.get() * 100.0))));
        (this.addRenderableWidget((GuiEventListener)new NewTextureSliderButton(this.leftPos + 13, this.topPos + 129, 150, 18, CommonComponents.EMPTY, (Double)clientConfig.fontBrightness.get()){

            protected void updateMessage() {
                this.setTooltip(Tooltip.create((Component)Component.literal((String)String.format("%.0f%%", this.value * 100.0))));
            }

            protected void applyValue() {
                clientConfig.fontBrightness.set((Object)this.value);
                PixelConfigScreen.this.markedDirty = true;
            }
        })).setTooltip(Tooltip.create((Component)Component.literal((String)String.format("%.0f%%", (Double)clientConfig.fontBrightness.get() * 100.0))));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderLabels(guiGraphics, mouseX, mouseY);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(DaytimeSwitcherHandler.TEXTURE_LOCATION, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        DaytimeSwitcherHandler.drawThemeBackground(guiGraphics, this.leftPos, this.topPos, this.imageWidth);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        NewTextureButton.drawCenteredString(guiGraphics, this.font, ALGORITHM_COMPONENT, this.width / 2, this.topPos + 19, -12566464, false);
        NewTextureButton.drawCenteredString(guiGraphics, this.font, INTERFACE_DARKNESS_COMPONENT, this.width / 2, this.topPos + 67, -12566464, false);
        NewTextureButton.drawCenteredString(guiGraphics, this.font, FONT_BRIGHTNESS_COMPONENT, this.width / 2, this.topPos + 115, -12566464, false);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.minecraft.options.keyInventory.matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        return false;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        this.saveSettings();
        this.lastScreen.onClose();
    }

    public void closeToLastScreen() {
        this.saveSettings();
        this.minecraft.setScreen(this.lastScreen);
    }

    private void saveSettings() {
        if (this.markedDirty) {
            ClientConfig clientConfig = (ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class);
            clientConfig.darkeningAlgorithm.save();
            clientConfig.textureDarkness.save();
            clientConfig.fontBrightness.save();
        }
    }
}

