/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mindfuldarkness.client.handler;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.resources.ResourceLocation;

public class ColorChangedAssetsManager {
    public static final ColorChangedAssetsManager INSTANCE = new ColorChangedAssetsManager();
    private final Set<ResourceLocation> colorChangingTextures = Sets.newHashSet();

    public void add(ResourceLocation path) {
        this.colorChangingTextures.add(path);
    }

    public void reset() {
        if (!RenderSystem.isOnRenderThread()) {
            return;
        }
        TextureManager textureManager = Minecraft.getInstance().getTextureManager();
        if (textureManager != null) {
            for (ResourceLocation path : this.colorChangingTextures) {
                AbstractTexture abstractTexture = (AbstractTexture)textureManager.byPath.remove(path);
                if (abstractTexture == null) continue;
                textureManager.safeClose(path, abstractTexture);
                if (!(abstractTexture instanceof Tickable)) continue;
                textureManager.tickableTextures.remove(abstractTexture);
            }
            this.colorChangingTextures.clear();
        }
    }
}

