/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mindfuldarkness.client.handler;

import fuzs.mindfuldarkness.MindfulDarkness;
import fuzs.mindfuldarkness.client.gui.screens.PixelConfigScreen;
import fuzs.mindfuldarkness.client.handler.FontColorHandler;
import fuzs.mindfuldarkness.config.ClientConfig;
import fuzs.puzzleslib.api.client.gui.v2.components.SpritelessImageButton;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.DefaultedValue;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.Nullable;

public class DaytimeSwitcherHandler {
    public static final ResourceLocation TEXTURE_LOCATION = MindfulDarkness.id("textures/gui/daytime_switcher.png");
    public static final String KEY_DEBUG_IDENTIFIER = "screen.debug.identifier";
    public static final String KEY_DEBUG_MENU_TYPE = "screen.debug.menuType";
    private static AbstractWidget[] buttons;

    public static void onEndTick(Minecraft minecraft) {
        DaytimeSwitcherHandler.setHorizontalButtonPosition(minecraft.screen);
    }

    public static void onAfterMouseClick(Screen screen, double mouseX, double mouseY, int button) {
        DaytimeSwitcherHandler.setHorizontalButtonPosition(screen);
    }

    private static void setHorizontalButtonPosition(Screen screen) {
        if (buttons == null) {
            return;
        }
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            if (screen instanceof RecipeUpdateListener) {
                int leftPos = containerScreen.leftPos;
                int imageWidth = containerScreen.imageWidth;
                buttons[0].setX(leftPos + imageWidth - 3 - 21);
                buttons[1].setX(leftPos + imageWidth - 3 - 40);
                buttons[2].setX(leftPos + imageWidth - 3 - 68);
                buttons[3].setX(leftPos + imageWidth - 3 - 95);
            }
        }
    }

    public static EventResult onScreenOpening(@Nullable Screen oldScreen, DefaultedValue<Screen> newScreen) {
        if (newScreen.get() == null) {
            buttons = null;
        } else if (!(oldScreen instanceof PixelConfigScreen)) {
            Object message;
            String identifier;
            Minecraft minecraft = Minecraft.getInstance();
            if (((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).debugAllScreens && (identifier = FontColorHandler.getScreenIdentifier((Screen)newScreen.get())) != null) {
                message = Component.translatable((String)KEY_DEBUG_IDENTIFIER, (Object[])new Object[]{ComponentUtils.wrapInSquareBrackets((Component)Component.literal((String)identifier))});
                if (minecraft.level != null) {
                    minecraft.gui.getChat().addMessage((Component)message);
                } else {
                    MindfulDarkness.LOGGER.info(message.getString());
                }
            }
            if ((message = newScreen.get()) instanceof AbstractContainerScreen) {
                MenuType menuType;
                AbstractContainerScreen containerScreen = (AbstractContainerScreen)message;
                if (((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).debugContainerTypes && (menuType = containerScreen.getMenu().menuType) != null) {
                    MutableComponent component = Component.literal((String)BuiltInRegistries.MENU.getKey((Object)menuType).toString());
                    MutableComponent message2 = Component.translatable((String)KEY_DEBUG_MENU_TYPE, (Object[])new Object[]{ComponentUtils.wrapInSquareBrackets((Component)component)});
                    minecraft.gui.getChat().addMessage((Component)message2);
                }
            }
        }
        return EventResult.PASS;
    }

    public static void onDrawBackground(AbstractContainerScreen<?> screen, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (DaytimeSwitcherHandler.supportsDaytimeSwitcher(screen)) {
            DaytimeSwitcherHandler.drawThemeBackground(guiGraphics, screen.leftPos, screen.topPos, screen.imageWidth);
        }
    }

    public static void drawThemeBackground(GuiGraphics guiGraphics, int leftPos, int topPos, int imageWidth) {
        guiGraphics.blit(TEXTURE_LOCATION, leftPos + imageWidth - 3 - 101, topPos - 24, 0.0f, 226.0f, 101, 24, 256, 256);
    }

    private static boolean supportsDaytimeSwitcher(AbstractContainerScreen<?> containerScreen) {
        if (((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).hideInGameSwitcher) {
            return false;
        }
        if (containerScreen.height >= containerScreen.imageHeight + 48) {
            if (containerScreen instanceof CreativeModeInventoryScreen) {
                return false;
            }
            MenuType menuType = containerScreen.getMenu().menuType;
            return menuType == null || !((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).menuBlacklist.contains((Object)menuType);
        }
        return false;
    }

    public static void onAfterInit(Minecraft minecraft, AbstractContainerScreen<?> screen, int screenWidth, int screenHeight, List<AbstractWidget> widgets, UnaryOperator<AbstractWidget> addWidget, Consumer<AbstractWidget> removeWidget) {
        if (DaytimeSwitcherHandler.supportsDaytimeSwitcher(screen)) {
            for (AbstractWidget button : buttons = DaytimeSwitcherHandler.makeButtons(minecraft, screen, screen.leftPos, screen.topPos, screen.imageWidth)) {
                addWidget.apply(button);
            }
        }
    }

    public static AbstractWidget[] makeButtons(Minecraft minecraft, Screen screen, int leftPos, int topPos, int imageWidth) {
        AbstractWidget[] abstractWidgets;
        abstractWidgets = new AbstractWidget[]{new SpritelessImageButton(leftPos + imageWidth - 3 - 21, topPos - 18, 15, 15, 224, 0, TEXTURE_LOCATION, button -> screen.onClose()), new SpritelessImageButton(leftPos + imageWidth - 3 - 40, topPos - 18, 15, 15, 239, 0, TEXTURE_LOCATION, button -> {
            if (screen instanceof PixelConfigScreen) {
                PixelConfigScreen pixelConfigScreen = (PixelConfigScreen)screen;
                pixelConfigScreen.closeToLastScreen();
            } else {
                minecraft.setScreen((Screen)new PixelConfigScreen(screen));
            }
        }), new SpritelessImageButton(leftPos + imageWidth - 3 - 68, topPos - 20, 24, 19, 200, 0, TEXTURE_LOCATION, button -> DaytimeSwitcherHandler.toggleThemeButtons(abstractWidgets[3], abstractWidgets[2], true)), new SpritelessImageButton(leftPos + imageWidth - 3 - 95, topPos - 20, 24, 19, 176, 0, TEXTURE_LOCATION, button -> DaytimeSwitcherHandler.toggleThemeButtons(abstractWidgets[3], abstractWidgets[2], true))};
        DaytimeSwitcherHandler.toggleThemeButtons(abstractWidgets[3], abstractWidgets[2], false);
        return abstractWidgets;
    }

    private static void toggleThemeButtons(AbstractWidget lightThemeWidget, AbstractWidget darkThemeWidget, boolean toggleSetting) {
        boolean darkTheme;
        if (toggleSetting) {
            DaytimeSwitcherHandler.activateDaytimeSwitch();
        }
        lightThemeWidget.active = darkTheme = ((Boolean)((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).darkTheme.get()).booleanValue();
        darkThemeWidget.active = !darkTheme;
    }

    public static void activateDaytimeSwitch() {
        ModConfigSpec.BooleanValue configValue;
        configValue.set((Object)((Boolean)(configValue = ((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).darkTheme).get() == false ? 1 : 0));
        configValue.save();
    }
}

