/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mindfuldarkness.client.handler;

import fuzs.mindfuldarkness.MindfulDarkness;
import fuzs.mindfuldarkness.client.util.HSPConversionUtil;
import fuzs.mindfuldarkness.client.util.RGBBrightnessUtil;
import fuzs.mindfuldarkness.config.ClientConfig;
import java.util.Objects;
import java.util.OptionalInt;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookEditScreen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.Nullable;

public class FontColorHandler {
    private static boolean renderInDarkness;

    public static void onBeforeRender(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float tickDelta) {
        String identifier = FontColorHandler.getScreenIdentifier(screen);
        if (identifier == null || !((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).fontColorBlacklist.contains(identifier)) {
            renderInDarkness = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String getScreenIdentifier(Screen screen) {
        Objects.requireNonNull(screen, "screen is null");
        Component title = screen.getTitle();
        ComponentContents componentContents = title.getContents();
        if (componentContents instanceof PlainTextContents.LiteralContents) {
            PlainTextContents.LiteralContents literalContents = (PlainTextContents.LiteralContents)componentContents;
            try {
                String string = literalContents.text();
                return string;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        componentContents = title.getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatableContents = (TranslatableContents)componentContents;
            return translatableContents.getKey();
        }
        if (screen instanceof BookEditScreen) {
            return "book.edit.title";
        }
        if (!(screen instanceof BookViewScreen)) return null;
        return "book.view.title";
    }

    public static void onAfterRender(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float tickDelta) {
        renderInDarkness = false;
    }

    public static int adjustFontColor(int fontColor) {
        if (renderInDarkness && MindfulDarkness.CONFIG.getHolder(ClientConfig.class).isAvailable() && ((Boolean)((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).darkTheme.get()).booleanValue()) {
            return FontColorHandler.tryAdjustColor(fontColor).orElse(fontColor);
        }
        return fontColor;
    }

    private static OptionalInt tryAdjustColor(int color) {
        double targetBrightness;
        double[] hspColorArray = RGBBrightnessUtil.unpackRGBToHSP(color);
        if (hspColorArray[2] < (targetBrightness = ((Double)((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).fontBrightness.get()).doubleValue())) {
            double[] rgbColorArray = HSPConversionUtil.HSPtoRGB(hspColorArray[0], hspColorArray[1], targetBrightness);
            int alpha = FastColor.ARGB32.alpha((int)color);
            color = RGBBrightnessUtil.packRGBColor(rgbColorArray);
            return OptionalInt.of(FastColor.ARGB32.color((int)alpha, (int)color));
        }
        return OptionalInt.empty();
    }
}

