/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mindfuldarkness.client.util;

import fuzs.mindfuldarkness.client.util.CompactConversionsUtil;
import fuzs.mindfuldarkness.client.util.HSPConversionUtil;
import net.minecraft.util.Mth;

public class RGBBrightnessUtil {
    private static final int GRAYSCALE_DELTA = 3;

    public static int darkenColorHSP(int packedColor, double brightness) {
        double[] hspColorArray = RGBBrightnessUtil.unpackRGBToHSP(packedColor);
        double[] rgbColorArray = HSPConversionUtil.HSPtoRGB(hspColorArray[0], hspColorArray[1], hspColorArray[2] * brightness);
        return RGBBrightnessUtil.packRGBColor(rgbColorArray);
    }

    public static double[] unpackRGBToHSP(int packedColor) {
        int red = packedColor >> 16 & 0xFF;
        int green = packedColor >> 8 & 0xFF;
        int blue = packedColor & 0xFF;
        return HSPConversionUtil.RGBtoHSP((double)red / 255.0, (double)green / 255.0, (double)blue / 255.0);
    }

    public static int darkenColorHSV(int packedColor, double brightness) {
        double[] hsvColorArray = RGBBrightnessUtil.unpackRGBToHSV(packedColor);
        double[] rgbColorArray = CompactConversionsUtil.hsv2rgb((float)hsvColorArray[0], (float)hsvColorArray[1], (float)(hsvColorArray[2] * brightness));
        return RGBBrightnessUtil.packRGBColor(rgbColorArray);
    }

    public static double[] unpackRGBToHSV(int packedColor) {
        int red = packedColor >> 16 & 0xFF;
        int green = packedColor >> 8 & 0xFF;
        int blue = packedColor & 0xFF;
        return CompactConversionsUtil.rgb2hsv(red, green, blue);
    }

    public static int darkenColorHSL(int packedColor, double brightness) {
        double[] hslColorArray = RGBBrightnessUtil.unpackRGBToHSL(packedColor);
        double[] rgbColorArray = CompactConversionsUtil.hsl2rgb((float)hslColorArray[0], (float)hslColorArray[1], (float)(hslColorArray[2] * brightness));
        return RGBBrightnessUtil.packRGBColor(rgbColorArray);
    }

    public static double[] unpackRGBToHSL(int packedColor) {
        int red = packedColor >> 16 & 0xFF;
        int green = packedColor >> 8 & 0xFF;
        int blue = packedColor & 0xFF;
        return CompactConversionsUtil.rgb2hsl((double)red / 255.0, (double)green / 255.0, (double)blue / 255.0);
    }

    public static int packRGBColor(double[] rgbColorArray) {
        return RGBBrightnessUtil.packRGBColor((int)(rgbColorArray[0] * 255.0), (int)(rgbColorArray[1] * 255.0), (int)(rgbColorArray[2] * 255.0));
    }

    public static int packRGBColor(int red, int green, int blue) {
        return Mth.clamp((int)red, (int)0, (int)255) << 16 | Mth.clamp((int)green, (int)0, (int)255) << 8 | Mth.clamp((int)blue, (int)0, (int)255);
    }

    public static int multiplyColorComponentsBy(int packedColor, double multiplier, boolean onlyGrayscale) {
        multiplier = Math.max(multiplier, 0.0);
        int r = RGBBrightnessUtil.getR(packedColor);
        int g = RGBBrightnessUtil.getG(packedColor);
        int b = RGBBrightnessUtil.getB(packedColor);
        if (!onlyGrayscale || RGBBrightnessUtil.isGrayscaleColor(r, g, b)) {
            r = (int)Math.min((double)r * multiplier, 255.0);
            g = (int)Math.min((double)g * multiplier, 255.0);
            b = (int)Math.min((double)b * multiplier, 255.0);
            return r << 16 | g << 8 | b;
        }
        return packedColor;
    }

    public static int getA(int abgrColor) {
        return abgrColor >> 24 & 0xFF;
    }

    public static int getR(int abgrColor) {
        return abgrColor >> 0 & 0xFF;
    }

    public static int getG(int abgrColor) {
        return abgrColor >> 8 & 0xFF;
    }

    public static int getB(int abgrColor) {
        return abgrColor >> 16 & 0xFF;
    }

    private static boolean isGrayscaleColor(int r, int g, int b) {
        int average = (r + g + b) / 3;
        return Math.abs(average - r) < 3 && Math.abs(average - g) < 3 && Math.abs(average - b) < 3;
    }

    public static int brightenColor(int packedColor, double brightenBy) {
        brightenBy = Math.max(brightenBy, 0.0);
        int red = packedColor >> 16 & 0xFF;
        int green = packedColor >> 8 & 0xFF;
        int blue = packedColor & 0xFF;
        int average = (red + green + blue) / 3;
        int increase = (int)((double)average * (1.0 + brightenBy));
        int[] colorArray = RGBBrightnessUtil.redistributeBrightenedColorComponents(red + increase, green + increase, blue + increase);
        return colorArray[0] << 16 | colorArray[1] << 8 | colorArray[0];
    }

    private static int[] redistributeBrightenedColorComponents(int red, int green, int blue) {
        int[] colorArray = new int[]{red, green, blue};
        int max = Math.max(red, Math.max(green, blue));
        if (max > 255) {
            int total = red + green + blue;
            if (total > 765) {
                colorArray[2] = 255;
                colorArray[1] = 255;
                colorArray[0] = 255;
            } else {
                int x = (765 - total) / (3 * max - total);
                int gray = 255 - x * max;
                colorArray[0] = gray + x * red;
                colorArray[1] = gray + x * green;
                colorArray[2] = gray + x * blue;
            }
        }
        return colorArray;
    }

    public static int darkenColor(int packedColor, double darkenBy) {
        darkenBy = Mth.clamp((double)darkenBy, (double)0.0, (double)1.0);
        int red = packedColor >> 16 & 0xFF;
        int green = packedColor >> 8 & 0xFF;
        int blue = packedColor & 0xFF;
        int average = (red + green + blue) / 3;
        int decrease = (int)((double)average * darkenBy);
        int[] colorArray = RGBBrightnessUtil.redistributeDarkenedColorComponents(red - decrease, green - decrease, blue - decrease);
        return colorArray[0] << 16 | colorArray[1] << 8 | colorArray[2];
    }

    private static int[] redistributeDarkenedColorComponents(int red, int green, int blue) {
        int[] colorArray = new int[]{red, green, blue};
        int min = Math.min(red, Math.min(green, blue));
        if (min < 0) {
            int total = red + green + blue;
            if (total < 0) {
                colorArray[2] = 0;
                colorArray[1] = 0;
                colorArray[0] = 0;
            } else {
                int x = total / (total - 3 * min);
                int gray = x * min;
                colorArray[0] = gray - x * red;
                colorArray[1] = gray - x * green;
                colorArray[2] = gray - x * blue;
            }
        }
        return colorArray;
    }
}

