/*
 * Decompiled with CFR 0.152.
 */
package com.mcwlights.kikoz.objects;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TorchObject
extends FaceAttachedHorizontalDirectionalBlock {
    protected final ParticleOptions flame;
    protected static final VoxelShape BOT = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0);
    protected static final VoxelShape WEST = Block.box((double)10.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape EAST = Block.box((double)0.0, (double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0);
    protected static final VoxelShape NORTH = Block.box((double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)6.0);

    public TorchObject(BlockBehaviour.Properties properties, ParticleOptions flame) {
        super(properties);
        this.flame = flame;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return TorchObject.canAttach((LevelReader)world, (BlockPos)pos, (Direction)TorchObject.getConnectedDirection((BlockState)state).getOpposite()) && state.getValue((Property)FACE) != AttachFace.CEILING;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        switch ((AttachFace)state.getValue((Property)FACE)) {
            case FLOOR: {
                return BOT;
            }
            case WALL: {
                switch (direction) {
                    case EAST: {
                        return EAST;
                    }
                    case WEST: {
                        return WEST;
                    }
                    case SOUTH: {
                        return SOUTH;
                    }
                    case NORTH: {
                        return NORTH;
                    }
                    case UP: {
                        return BOT;
                    }
                    case DOWN: {
                        return BOT;
                    }
                }
            }
            case CEILING: {
                return BOT;
            }
        }
        return null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, FACE});
    }

    protected MapCodec<? extends FaceAttachedHorizontalDirectionalBlock> codec() {
        return null;
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        Direction direction = (Direction)stateIn.getValue((Property)FACING);
        double d0 = (double)pos.getX() + 0.5;
        double d1 = (double)pos.getY() + 0.7;
        double d2 = (double)pos.getZ() + 0.5;
        Direction direction1 = direction.getOpposite();
        switch ((AttachFace)stateIn.getValue((Property)FACE)) {
            case FLOOR: {
                worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
                worldIn.addParticle(this.flame, d0, d1, d2, 0.0, 0.0, 0.0);
                break;
            }
            case WALL: {
                worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + 0.27 * (double)direction1.getStepX(), d1 + 0.22, d2 + 0.27 * (double)direction1.getStepZ(), 0.0, 0.0, 0.0);
                worldIn.addParticle(this.flame, d0 + 0.27 * (double)direction1.getStepX(), d1 + 0.22, d2 + 0.27 * (double)direction1.getStepZ(), 0.0, 0.0, 0.0);
                break;
            }
        }
    }
}

