/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.mixin;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements CarryOnDataManager.ICarrying {
    @Unique
    private static final EntityDataAccessor<CompoundTag> CARRY_DATA_KEY = SynchedEntityData.defineId(Player.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);

    @Override
    public void setCarryOnData(CarryOnData data) {
        data.setSelected(this.getInventory().selected);
        CompoundTag nbt = data.getNbt();
        nbt.putInt("tick", this.tickCount);
        this.getEntityData().set(CARRY_DATA_KEY, (Object)nbt);
    }

    @Override
    public CarryOnData getCarryOnData() {
        CompoundTag data = (CompoundTag)this.getEntityData().get(CARRY_DATA_KEY);
        return new CarryOnData(data.copy());
    }

    @Shadow
    public abstract Inventory getInventory();

    private PlayerMixin(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
    }

    @Inject(method={"defineSynchedData(Lnet/minecraft/network/syncher/SynchedEntityData$Builder;)V"}, at={@At(value="RETURN")})
    private void onDefineSynchedData(SynchedEntityData.Builder builder, CallbackInfo ci) {
        builder.define(CARRY_DATA_KEY, (Object)new CompoundTag());
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="RETURN")})
    private void onAddAdditionalSaveData(CompoundTag tag, CallbackInfo info) {
        CarryOnData carry = CarryOnDataManager.getCarryData((Player)this);
        tag.put("CarryOnData", (Tag)carry.getNbt());
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="RETURN")})
    private void onReadAdditionalSaveData(CompoundTag tag, CallbackInfo info) {
        if (tag.contains("CarryOnData")) {
            CarryOnData data = new CarryOnData(tag.getCompound("CarryOnData"));
            this.setCarryOnData(data);
        }
    }
}

